/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerStateChange;
import javax.swing.JSlider;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.utils.BdvUtils;

public class PlanarModeController {
    private final BdvHandle bdvHandle;
    private final ImageLabelingModel model;
    private final JSlider zSlider;
    private boolean ignoreChange = false;

    public PlanarModeController(BdvHandle bdvHandle, ImageLabelingModel model, JSlider zSlider) {
        this.bdvHandle = bdvHandle;
        this.model = model;
        this.zSlider = zSlider;
        zSlider.setVisible(false);
        this.initZSlider();
    }

    public void setActive(boolean active) {
        if (active) {
            BdvUtils.blockRotation(this.bdvHandle);
            BdvUtils.resetView(this.bdvHandle.getViewerPanel());
        } else {
            BdvUtils.unblockRotation(this.bdvHandle);
        }
        this.zSlider.setVisible(active);
    }

    private void initZSlider() {
        this.updateZSliderPosition();
        this.zSlider.addChangeListener(ignore -> {
            if (this.ignoreChange) {
                return;
            }
            this.updateViewerTransform();
        });
        this.bdvHandle.getViewerPanel().state().changeListeners().add(change -> {
            if (change != ViewerStateChange.VIEWER_TRANSFORM_CHANGED) {
                return;
            }
            this.updateZSliderPosition();
        });
    }

    private void updateViewerTransform() {
        Interval interval = this.getLabelInterval();
        if (interval.numDimensions() < 3) {
            return;
        }
        int z = this.zSlider.getValue();
        double xcenter = 0.5 * (double)(interval.min(0) + interval.max(0));
        double ycenter = 0.5 * (double)(interval.min(1) + interval.max(1));
        double[] v = new double[]{xcenter, ycenter, z};
        AffineTransform3D labelTransform = this.getLabelTransform();
        labelTransform.apply(v, v);
        AffineTransform3D viewerTransform = this.bdvHandle.getViewerPanel().state().getViewerTransform();
        viewerTransform.apply(v, v);
        viewerTransform.translate(new double[]{0.0, 0.0, -v[2]});
        this.bdvHandle.getViewerPanel().state().setViewerTransform(viewerTransform);
    }

    private void updateZSliderPosition() {
        Interval interval = this.getLabelInterval();
        if (interval.numDimensions() < 3) {
            return;
        }
        double xcenter = 0.5 * (double)(interval.min(0) + interval.max(0));
        double ycenter = 0.5 * (double)(interval.min(1) + interval.max(1));
        long min = interval.min(2);
        long max = interval.max(2);
        double[] a = new double[]{xcenter, ycenter, min};
        double[] b = new double[]{xcenter, ycenter, max};
        AffineTransform3D labelTransform = this.getLabelTransform();
        AffineTransform3D viewerTransform = this.bdvHandle.getViewerPanel().state().getViewerTransform();
        labelTransform.apply(a, a);
        viewerTransform.apply(a, a);
        labelTransform.apply(b, b);
        viewerTransform.apply(b, b);
        this.ignoreChange = true;
        this.zSlider.setMinimum((int)min);
        this.zSlider.setMaximum((int)max);
        double z = ((double)min * b[2] - (double)max * a[2]) / (b[2] - a[2]);
        if (!Double.isNaN(z)) {
            this.zSlider.setValue((int)z);
        }
        this.ignoreChange = false;
    }

    private Interval getLabelInterval() {
        Interval interval = this.model.labeling().get().interval();
        if (this.model.isTimeSeries()) {
            interval = Intervals.hyperSlice((Interval)interval, (int)(interval.numDimensions() - 1));
        }
        return interval;
    }

    private AffineTransform3D getLabelTransform() {
        return this.model.labelTransformation();
    }
}

