/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.dog2;

import java.util.Collections;
import java.util.List;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.labkit.pixel_classification.gpu.GpuFeatureInput;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuPixelWiseOperation;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureOp;

@Plugin(type=FeatureOp.class, label="difference of gaussians")
public class SingleDifferenceOfGaussiansFeature
extends AbstractFeatureOp {
    @Parameter
    private double sigma1 = 1.0;
    @Parameter
    private double sigma2 = 2.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public void apply(FeatureInput in, List<RandomAccessibleInterval<FloatType>> out) {
        this.dog(in, out.get(0));
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList("difference of gaussians sigma1=" + this.sigma1 + " sigma2=" + this.sigma2);
    }

    private void dog(FeatureInput in, RandomAccessibleInterval<FloatType> result) {
        this.subtract(in.gauss(this.sigma1), in.gauss(this.sigma2), result);
    }

    private void subtract(RandomAccessibleInterval<DoubleType> minuend, RandomAccessibleInterval<DoubleType> subtrahend, RandomAccessibleInterval<FloatType> result) {
        LoopBuilder.setImages(minuend, subtrahend, result).forEachPixel((a, b, r) -> r.setReal(a.getRealFloat() - b.getRealFloat()));
    }

    @Override
    public void prefetch(GpuFeatureInput input) {
        input.prefetchGauss(this.sigma1, input.targetInterval());
        input.prefetchGauss(this.sigma2, input.targetInterval());
    }

    @Override
    public void apply(GpuFeatureInput input, List<GpuView> output) {
        GpuView gauss1 = input.gauss(this.sigma1, input.targetInterval());
        GpuView gauss2 = input.gauss(this.sigma2, input.targetInterval());
        this.subtract(input.gpuApi(), gauss1, gauss2, output.get(0));
    }

    private void subtract(GpuApi gpu, GpuView minuend, GpuView subtrahend, GpuView result) {
        GpuPixelWiseOperation.gpu(gpu).addInput("a", minuend).addInput("b", subtrahend).addOutput("r", result).forEachPixel("r = a - b");
    }
}

