/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.pixel_classification.pixel_feature.filter.stats;

import java.util.Collections;
import java.util.List;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;
import sc.fiji.labkit.pixel_classification.gpu.GpuFeatureInput;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuApi;
import sc.fiji.labkit.pixel_classification.gpu.api.GpuView;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.AbstractFeatureOp;
import sc.fiji.labkit.pixel_classification.pixel_feature.filter.FeatureInput;

public abstract class AbstractSingleStatisticFeature
extends AbstractFeatureOp {
    @Parameter
    private double radius = 1.0;

    @Override
    public int count() {
        return 1;
    }

    @Override
    public List<String> attributeLabels() {
        return Collections.singletonList(this.filterName() + " filter radius=" + this.radius);
    }

    protected abstract String filterName();

    @Override
    public void apply(FeatureInput input, List<RandomAccessibleInterval<FloatType>> output) {
        int[] windowSize = this.getWindowSize();
        this.apply(windowSize, input.original(), output.get(0));
    }

    protected abstract void apply(int[] var1, RandomAccessible<FloatType> var2, RandomAccessibleInterval<FloatType> var3);

    @Override
    public void prefetch(GpuFeatureInput input) {
        input.prefetchOriginal((Interval)this.requiredSourceInterval(input.targetInterval()));
    }

    @Override
    public void apply(GpuFeatureInput input, List<GpuView> output) {
        try (GpuApi gpu = input.gpuApi().subScope();){
            GpuView original = input.original((Interval)this.requiredSourceInterval(input.targetInterval()));
            int[] windowSize = this.getWindowSize();
            this.apply(gpu, windowSize, original, output.get(0));
        }
    }

    protected abstract void apply(GpuApi var1, int[] var2, GpuView var3, GpuView var4);

    private int[] getWindowSize() {
        return this.globalSettings().pixelSize().stream().mapToInt(pixelSize -> 1 + 2 * Math.max(0, (int)(this.radius / pixelSize))).toArray();
    }

    private FinalInterval requiredSourceInterval(Interval targetInterval) {
        long[] borderSize = this.globalSettings().pixelSize().stream().mapToLong(pixelSize -> Math.max(0L, (long)(this.radius / pixelSize))).toArray();
        return Intervals.expand((Interval)targetInterval, (long[])borderSize);
    }
}

