/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Objects;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.scijava.convert.ConvertService;
import org.scijava.plot.Plot;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;
import org.scijava.ui.viewer.plot.PlotDisplay;
import org.scijava.ui.viewer.plot.PlotDisplayPanel;

public class SwingPlotDisplayPanel
extends JPanel
implements PlotDisplayPanel {
    private final DisplayWindow window;
    private final PlotDisplay display;
    private final ConvertService convertService;
    private Dimension prefferedSize;

    public SwingPlotDisplayPanel(PlotDisplay display, DisplayWindow window, ConvertService convertService) {
        this.display = display;
        this.window = window;
        this.convertService = convertService;
        this.setLayout(new BorderLayout());
        this.initPreferredSize();
        this.setupChart();
        window.setContent((DisplayPanel)this);
    }

    private void initPreferredSize() {
        Plot plot = (Plot)this.display.get(0);
        this.prefferedSize = new Dimension(plot.getPreferredWidth(), plot.getPreferredHeight());
    }

    private void setupChart() {
        JFreeChart chart = this.convertToJFreeChart((Plot)this.display.get(0));
        this.add((Component)new ChartPanel(chart));
    }

    private JFreeChart convertToJFreeChart(Plot plot) {
        return (JFreeChart)Objects.requireNonNull(this.convertService.convert((Object)plot, JFreeChart.class));
    }

    public static boolean supports(Plot abstractPlot, ConvertService convertService) {
        return convertService.supports((Object)abstractPlot, JFreeChart.class);
    }

    public PlotDisplay getDisplay() {
        return this.display;
    }

    public DisplayWindow getWindow() {
        return this.window;
    }

    public void redoLayout() {
    }

    public void setLabel(String s) {
    }

    public void redraw() {
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefferedSize;
    }
}

