/*
 * Decompiled with CFR 0.152.
 */
package graphcut;

import fiji.util.gui.OverlayedImageCanvas;
import graphcut.GraphCut;
import graphcut.ImageOverlay;
import graphcut.Terminal;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.StackStatistics;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.img.ImagePlusAdapter;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public class Graph_Cut<T extends RealType<T> & NativeType<T>>
implements PlugIn {
    private ImagePlus imp;
    private ImagePlus edge;
    private ImagePlus seg;
    private ImagePlus seq;
    private float dataWeight = 0.5f;
    private float pottsWeight = 5.0f;
    private float edgeWeight = 50.0f;
    private float edgeVariance = 50.0f;
    private boolean implicitEdgeWeights = true;
    private static final float DATA_SCALE = 0.01f;
    private static final int DATA_MIN = 0;
    private static final int DATA_MAX = 100;
    private static final float DATA_INIT = 0.5f;
    private static final float POTTS_SCALE = 0.01f;
    private static final int POTTS_MIN = 0;
    private static final int POTTS_MAX = 1000;
    private static final float POTTS_INIT = 5.0f;
    private static final float EDGE_SCALE = 0.1f;
    private static final int EDGE_MIN = 0;
    private static final int EDGE_MAX = 1000;
    private static final float EDGE_INIT = 50.0f;
    private static final float EDGE_VARIANCE_SCALE = 0.1f;
    private static final int EDGE_VARIANCE_MIN = 0;
    private static final int EDGE_VARIANCE_MAX = 1000;
    private static final float EDGE_VARIANCE_INIT = 50.0f;
    private boolean eightConnect = true;
    private GraphCutWindow win;
    private ImageOverlay resultOverlay;
    private LUT overlayLUT;
    private ImagePlus displayImage;
    private float overlayAlpha = 0.5f;
    private boolean showColorOverlay = false;
    private Panel all = new Panel();
    private JPanel applyPanel;
    private JPanel buttonsPanel;
    private JPanel dataPanel;
    private JPanel pottsPanel;
    private JPanel edgesPanel;
    private JPanel edgeVariancePanel;
    private JPanel edgeSelectorPanel;
    private JButton applyButton;
    private JButton sequenceButton;
    private JButton batchButton;
    private JButton overlayButton;
    private JSlider dataSlider;
    private JSlider pottsSlider;
    private JSlider edgeSlider;
    private JSlider edgeVarianceSlider;
    private JComboBox edgeSelector;

    public void run(String arg) {
        IJ.log((String)"Starting plugin Graph Cut");
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.showMessage((String)"Please open an image first.");
            return;
        }
        int channels = this.imp.getNChannels();
        if (channels > 1) {
            int channel = 0;
            while (channel <= 0 || channel > channels) {
                channel = (int)IJ.getNumber((String)("Please give the number of the channel you wish to consider for the segmentation (1 - " + channels + "):"), (double)1.0);
            }
            this.imp = this.extractChannel(this.imp, channel);
        }
        this.displayImage = new ImagePlus();
        this.displayImage.setProcessor("Graph Cut", this.imp.getProcessor().duplicate());
        IJ.log((String)"Starting GUI...");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IJ.log((String)"Creating window...");
                Graph_Cut.this.win = new GraphCutWindow(Graph_Cut.this.displayImage);
                Graph_Cut.this.win.pack();
            }
        });
    }

    public ImagePlus processSingleChannelImage(ImagePlus imp, ImagePlus edge, float dataWeight, float pottsWeight, float edgeWeight) {
        int[] dimensions = imp.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int zslices = dimensions[3];
        ImagePlus seg = IJ.createImage((String)(imp.getTitle() + " GraphCut segmentation"), (String)"8-bit", (int)width, (int)height, (int)zslices);
        seg.setCalibration(imp.getCalibration());
        this.processSingleChannelImage(imp, edge, dataWeight, pottsWeight, edgeWeight, seg);
        return seg;
    }

    public void processSingleChannelImage(ImagePlus imp, ImagePlus edge, float dataWeight, float pottsWeight, float edgeWeight, ImagePlus seg) {
        long[][] neighborPositions;
        float maxValue = (float)Math.pow(2.0, imp.getBitDepth());
        if (imp.getBitDepth() == 32) {
            maxValue = (float)new StackStatistics((ImagePlus)imp).max;
        }
        ImagePlusImg image = ImagePlusAdapter.wrap((ImagePlus)imp);
        ImagePlusImg edgeImage = null;
        if (edge != null) {
            edgeImage = ImagePlusAdapter.wrap((ImagePlus)edge);
        }
        long[] dimensions = new long[image.numDimensions()];
        image.dimensions(dimensions);
        long imageSize = image.size();
        if (imageSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Image too large: " + imageSize);
        }
        int numNodes = (int)imageSize;
        int numEdges = 0;
        if (edge != null) {
            int[] edgeDimensions = edge.getDimensions();
            this.implicitEdgeWeights = (long)edgeDimensions[0] != 2L * dimensions[0] - 1L;
        }
        if (this.eightConnect) {
            int prod1 = 1;
            for (int d = 0; d < dimensions.length; ++d) {
                prod1 = (int)((long)prod1 * (2L * dimensions[d] - 1L));
            }
            int prod2 = 1;
            for (int d = 0; d < dimensions.length; ++d) {
                prod2 = (int)((long)prod2 * dimensions[d]);
            }
            int prod3 = 1;
            for (int d = 0; d < dimensions.length; ++d) {
                prod3 = (int)((long)prod3 * (dimensions[d] - 1L));
            }
            numEdges = prod1 - prod2 + prod3;
        } else {
            for (int d = 0; d < dimensions.length; ++d) {
                numEdges = (int)((long)numEdges + ((long)numNodes - (long)numNodes / dimensions[d]));
            }
        }
        Cursor cursor = image.localizingCursor();
        long[] imagePosition = new long[dimensions.length];
        IJ.log((String)("Creating graph structure of " + numNodes + " nodes and " + numEdges + " edges..."));
        long start = System.currentTimeMillis();
        GraphCut graphCut = new GraphCut(numNodes, numEdges);
        long end = System.currentTimeMillis();
        IJ.log((String)("...done. (" + (end - start) + "ms)"));
        IJ.log((String)("Setting terminal weights with data prior " + dataWeight + "..."));
        start = System.currentTimeMillis();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(imagePosition);
            int nodeNum = this.listPosition(imagePosition, dimensions);
            float value = ((RealType)cursor.get()).getRealFloat();
            float probData = value / maxValue;
            float probPrior = dataWeight;
            float fweight = -((float)Math.log(probData)) - (float)Math.log(probPrior);
            float bweight = -((float)Math.log(1.0 - (double)probData)) - (float)Math.log(1.0 - (double)probPrior);
            graphCut.setTerminalWeights(nodeNum, fweight, bweight);
        }
        end = System.currentTimeMillis();
        IJ.log((String)("...done. (" + (end - start) + "ms)"));
        if (this.eightConnect) {
            int numNeighbors = dimensions.length * 2;
            int numDiagonal = 1;
            for (int d = 0; d < dimensions.length; ++d) {
                numDiagonal *= 2;
            }
            numNeighbors += numDiagonal;
            IJ.log((String)("num neighbors per pixel: " + (numNeighbors /= 2)));
            neighborPositions = new long[numNeighbors][dimensions.length];
            Arrays.fill(neighborPositions[0], -1L);
            for (int i = 1; i < neighborPositions.length; ++i) {
                System.arraycopy(neighborPositions[i - 1], 0, neighborPositions[i], 0, dimensions.length);
                boolean valid = false;
                block7: do {
                    int d;
                    for (d = dimensions.length - 1; d >= 0; --d) {
                        long[] lArray = neighborPositions[i];
                        int n = d;
                        lArray[n] = lArray[n] + 1L;
                        if (neighborPositions[i][d] < 2L) break;
                        neighborPositions[i][d] = -1L;
                    }
                    for (d = dimensions.length - 1; d >= 0; --d) {
                        if (neighborPositions[i][d] >= 0L) continue;
                        valid = true;
                        continue block7;
                    }
                } while (!valid);
                System.out.println(Arrays.toString(neighborPositions[i]));
            }
        } else {
            neighborPositions = new long[dimensions.length][dimensions.length];
            for (int d = 0; d < dimensions.length; ++d) {
                Arrays.fill(neighborPositions[d], 0L);
                neighborPositions[d][d] = -1L;
            }
        }
        IJ.log((String)("Setting edge weights to " + pottsWeight + "..."));
        RandomAccess edgeCursor = null;
        RandomAccess neighborCursor = null;
        if (edge != null) {
            IJ.log((String)("   (under consideration of edge image with weight " + edgeWeight + ")"));
            if (this.implicitEdgeWeights) {
                cursor = edgeImage.localizingCursor();
                neighborCursor = edgeImage.randomAccess();
            } else {
                cursor = image.localizingCursor();
                neighborCursor = image.randomAccess();
                edgeCursor = edgeImage.randomAccess();
            }
        } else {
            cursor = image.localizingCursor();
            neighborCursor = image.randomAccess();
        }
        long[] neighborPosition = new long[dimensions.length];
        long[] edgePosition = new long[dimensions.length];
        int e = 0;
        start = System.currentTimeMillis();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.localize(imagePosition);
            int nodeNum = this.listPosition(imagePosition, dimensions);
            float value = ((RealType)cursor.get()).getRealFloat();
            block12: for (int i = 0; i < neighborPositions.length; ++i) {
                for (int d = 0; d < dimensions.length; ++d) {
                    neighborPosition[d] = imagePosition[d] + neighborPositions[i][d];
                    edgePosition[d] = 2L * imagePosition[d] + neighborPositions[i][d];
                    if (neighborPosition[d] < 0L || neighborPosition[d] >= dimensions[d]) continue block12;
                }
                int neighborNum = this.listPosition(neighborPosition, dimensions);
                float weight = pottsWeight;
                if (edge != null) {
                    if (this.implicitEdgeWeights) {
                        neighborCursor.setPosition(neighborPosition);
                        float neighborValue = ((RealType)neighborCursor.get()).getRealFloat();
                        weight += edgeWeight * this.edgeLikelihood(value, neighborValue, imagePosition, neighborPosition, dimensions);
                    } else {
                        edgeCursor.setPosition(edgePosition);
                        float edgeValue = ((RealType)edgeCursor.get()).getRealFloat();
                        weight += edgeWeight * this.edgeLikelihood(0.0f, edgeValue, imagePosition, neighborPosition, dimensions);
                    }
                }
                graphCut.setEdgeWeight(nodeNum, neighborNum, weight);
                ++e;
            }
        }
        end = System.currentTimeMillis();
        IJ.log((String)("...done inserting " + e + " edges. (" + (end - start) + "ms)"));
        IJ.log((String)"Calculating max flow...");
        start = System.currentTimeMillis();
        float maxFlow = graphCut.computeMaximumFlow(false, null);
        end = System.currentTimeMillis();
        IJ.log((String)("...done. Max flow is " + maxFlow + ". (" + (end - start) + "ms)"));
        ImagePlusImg segmentation = ImagePlusAdapter.wrap((ImagePlus)seg);
        Cursor segCursor = segmentation.localizingCursor();
        imagePosition = new long[dimensions.length];
        while (segCursor.hasNext()) {
            segCursor.fwd();
            segCursor.localize(imagePosition);
            int nodeNum = this.listPosition(imagePosition, dimensions);
            if (graphCut.getTerminal(nodeNum) == Terminal.FOREGROUND) {
                ((RealType)segCursor.get()).setReal(255.0);
                continue;
            }
            ((RealType)segCursor.get()).setReal(0.0);
        }
    }

    public ImagePlus createSequenceImage(ImagePlus imp, ImagePlus edge, float dataStart, float dataStop, float dataStep, float pottsWeight, float edgeWeight) {
        int i;
        int[] dimensions = imp.getDimensions();
        int width = dimensions[0];
        int height = dimensions[1];
        int zslices = dimensions[3];
        int frames = (int)((dataStop - dataStart) / dataStep) + 1;
        ImageStack seqStack = new ImageStack(width, height);
        int numThreads = Runtime.getRuntime().availableProcessors() + 1;
        class ImageProcessingThread
        extends Thread {
            ImageStack result;
            final ImagePlus imp;
            final ImagePlus edge;
            final float dataStart;
            final float numSteps;
            final float dataStep;
            final float pottsWeight;
            final float edgeWeight;

            public ImageProcessingThread(ImagePlus imp, ImagePlus edge, float dataStart, int numSteps, float dataStep, float pottsWeight, float edgeWeight) {
                this.imp = imp;
                this.edge = edge;
                this.dataStart = dataStart;
                this.numSteps = numSteps;
                this.dataStep = dataStep;
                this.pottsWeight = pottsWeight;
                this.edgeWeight = edgeWeight;
            }

            @Override
            public void run() {
                this.result = new ImageStack(this.imp.getWidth(), this.imp.getHeight());
                float dataWeight = this.dataStart;
                int i = 0;
                while ((float)i < this.numSteps) {
                    IJ.log((String)("Processing data weight " + dataWeight + "..."));
                    IJ.showProgress((double)((float)i / this.numSteps));
                    ImagePlus seg = Graph_Cut.this.processSingleChannelImage(this.imp, this.edge, dataWeight, this.pottsWeight, this.edgeWeight);
                    for (int s = 0; s < seg.getStack().getSize(); ++s) {
                        this.result.addSlice("", seg.getStack().getProcessor(s + 1));
                    }
                    dataWeight += this.dataStep;
                    ++i;
                }
            }

            public ImageStack getResult() {
                return this.result;
            }
        }
        Vector<ImageProcessingThread> threads = new Vector<ImageProcessingThread>(numThreads);
        int numSteps = frames / numThreads;
        for (i = 0; i < numThreads; ++i) {
            float start = dataStart + dataStep * (float)(i * numSteps + 1);
            if (i == numThreads - 1) {
                numSteps = frames - (numThreads - 1) * numSteps;
            }
            IJ.log((String)("Starting thread " + i + " from " + start + ", " + numSteps + " steps (step " + dataStep + ")"));
            threads.add(new ImageProcessingThread(imp, edge, start, numSteps, dataStep, pottsWeight, edgeWeight));
            ((ImageProcessingThread)threads.get(i)).start();
        }
        for (i = 0; i < numThreads; ++i) {
            try {
                ((ImageProcessingThread)threads.get(i)).join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        IJ.showProgress((double)1.0);
        for (ImageProcessingThread ipt : threads) {
            ImageStack result = ipt.getResult();
            IJ.log((String)("Merging result with " + result.getSize() + " slices..."));
            for (int s = 0; s < result.getSize(); ++s) {
                seqStack.addSlice("", result.getProcessor(s + 1));
            }
        }
        ImagePlus seq = new ImagePlus(imp.getTitle() + " sequence segmentation " + dataStart + " - " + dataStop, seqStack);
        seq.setDimensions(1, zslices, frames);
        seq.setOpenAsHyperStack(true);
        return seq;
    }

    public void batchProcessImages() {
        int decision;
        String storeDir = "";
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File[] imageFiles = fileChooser.getSelectedFiles();
        boolean showResults = true;
        boolean storeResults = false;
        if (imageFiles.length >= 3 && (decision = JOptionPane.showConfirmDialog(null, "You decided to process three or more image files. Do you want the results to be stored on the disk instead of opening them in Fiji?", "Save results?", 0)) == 0) {
            fileChooser.setFileSelectionMode(1);
            fileChooser.setMultiSelectionEnabled(false);
            returnVal = fileChooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            storeDir = fileChooser.getSelectedFile().getPath();
            showResults = false;
            storeResults = true;
        }
        int numProcessors = Runtime.getRuntime().availableProcessors();
        IJ.log((String)("Processing " + imageFiles.length + " image files in " + numProcessors + " threads...."));
        this.setButtonsEnabled(false);
        Thread[] threads = new Thread[numProcessors];
        for (int i = 0; i < numProcessors; ++i) {
            class ImageProcessingThread
            extends Thread {
                final int numThread;
                final int numProcessors;
                final File[] imageFiles;
                final boolean storeResults;
                final boolean showResults;
                final String storeDir;

                public ImageProcessingThread(int numThread, int numProcessors, File[] imageFiles, boolean storeResults, boolean showResults, String storeDir) {
                    this.numThread = numThread;
                    this.numProcessors = numProcessors;
                    this.imageFiles = imageFiles;
                    this.storeResults = storeResults;
                    this.showResults = showResults;
                    this.storeDir = storeDir;
                }

                @Override
                public void run() {
                    for (int i = this.numThread; i < this.imageFiles.length; i += this.numProcessors) {
                        File file = this.imageFiles[i];
                        ImagePlus batchImage = IJ.openImage((String)file.getPath());
                        if (batchImage.getNChannels() > 1) {
                            batchImage = Graph_Cut.this.extractChannel(batchImage, 1);
                        }
                        IJ.log((String)("Processing image " + file.getName() + " in thread " + this.numThread));
                        ImagePlus segmentation = Graph_Cut.this.processSingleChannelImage(batchImage, null, Graph_Cut.this.dataWeight, Graph_Cut.this.pottsWeight, Graph_Cut.this.edgeWeight);
                        if (this.showResults) {
                            segmentation.show();
                            batchImage.show();
                        }
                        if (!this.storeResults) continue;
                        String filename = this.storeDir + File.separator + file.getName();
                        IJ.log((String)("Saving results to " + filename));
                        IJ.save((ImagePlus)segmentation, (String)filename);
                        segmentation.close();
                        batchImage.close();
                    }
                }
            }
            threads[i] = new ImageProcessingThread(i, numProcessors, imageFiles, storeResults, showResults, storeDir);
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setButtonsEnabled(true);
    }

    private ImagePlus extractChannel(ImagePlus imp, int channel) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int zslices = imp.getNSlices();
        int frames = imp.getNFrames();
        FileInfo fileInfo = imp.getOriginalFileInfo();
        ImageStack stack2 = new ImageStack(width, height);
        ImagePlus imp2 = new ImagePlus();
        imp2.setTitle("C" + channel + "-" + imp.getTitle());
        for (int t = 1; t <= frames; ++t) {
            for (int z = 1; z <= zslices; ++z) {
                int slice = imp.getStackIndex(channel, z, t);
                stack2.addSlice("", imp.getStack().getProcessor(slice));
            }
        }
        imp2.setStack(stack2);
        imp2.setDimensions(1, zslices, frames);
        if (zslices * frames > 1) {
            imp2.setOpenAsHyperStack(true);
        }
        imp2.setFileInfo(fileInfo);
        return imp2;
    }

    private ImagePlus extractZSlice(ImagePlus imp, int zslice) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        int channels = imp.getNChannels();
        int frames = imp.getNFrames();
        FileInfo fileInfo = imp.getOriginalFileInfo();
        ImageStack stack2 = new ImageStack(width, height);
        ImagePlus imp2 = new ImagePlus();
        imp2.setTitle("Z" + zslice + "-" + imp.getTitle());
        for (int f = 1; f <= frames; ++f) {
            for (int c = 1; c <= channels; ++c) {
                int slice = imp.getStackIndex(c, zslice, f);
                stack2.addSlice("", imp.getStack().getProcessor(slice));
            }
        }
        imp2.setStack(stack2);
        imp2.setDimensions(channels, 1, frames);
        if (channels * frames > 1) {
            imp2.setOpenAsHyperStack(true);
        }
        imp2.setFileInfo(fileInfo);
        return imp2;
    }

    private void updateSegmentationImage() {
        if (this.seg == null) {
            this.seg = this.processSingleChannelImage(this.imp, this.edge, this.dataWeight, this.pottsWeight, this.edgeWeight);
        } else {
            this.processSingleChannelImage(this.imp, this.edge, this.dataWeight, this.pottsWeight, this.edgeWeight, this.seg);
        }
    }

    private void createSequence() {
        int decision;
        String storeDir = "";
        JFileChooser fileChooser = new JFileChooser(".");
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(true);
        int returnVal = fileChooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        File[] imageFiles = fileChooser.getSelectedFiles();
        boolean showResults = true;
        boolean storeResults = false;
        if (imageFiles.length >= 3 && (decision = JOptionPane.showConfirmDialog(null, "You decided to process three or more image files. Do you want the results to be stored on the disk instead of opening them in Fiji?", "Save results?", 0)) == 0) {
            fileChooser.setFileSelectionMode(1);
            fileChooser.setMultiSelectionEnabled(false);
            returnVal = fileChooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            storeDir = fileChooser.getSelectedFile().getPath();
            showResults = false;
            storeResults = true;
        }
        GenericDialog gd = new GenericDialog("Sequence Parameter");
        gd.addNumericField("Start", 0.0, 3);
        gd.addNumericField("End", 1.0, 3);
        gd.addNumericField("Step", 0.01, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        float start = (float)gd.getNextNumber();
        float end = (float)gd.getNextNumber();
        float step = (float)gd.getNextNumber();
        boolean zsliceByZslice = false;
        boolean rememberDecision = false;
        for (int i = 0; i < imageFiles.length; ++i) {
            File file = imageFiles[i];
            ImagePlus sequenceImage = IJ.openImage((String)file.getPath());
            int width = sequenceImage.getWidth();
            int height = sequenceImage.getHeight();
            int channels = sequenceImage.getNChannels();
            int zslices = sequenceImage.getNSlices();
            int sequenceLength = -1;
            if (zslices > 1 && !rememberDecision) {
                int decision2 = JOptionPane.showConfirmDialog(null, "Process image zslice by zslice (as opposed to as a whole)?", "Frame by frame?", 0);
                if (decision2 == 0) {
                    zsliceByZslice = true;
                }
                if (storeResults) {
                    rememberDecision = true;
                }
            }
            ImageStack resultStack = new ImageStack(width, height);
            for (int zslice = 1; zslice <= (zsliceByZslice ? zslices : 1); ++zslice) {
                ImagePlus edgeImage;
                ImagePlus sequenceSlice;
                ImagePlus imagePlus = sequenceSlice = zsliceByZslice ? this.extractZSlice(sequenceImage, zslice) : sequenceImage;
                if (channels > 1) {
                    edgeImage = this.extractChannel(sequenceSlice, 2);
                    sequenceSlice = this.extractChannel(sequenceSlice, 1);
                } else {
                    edgeImage = this.edge;
                }
                IJ.log((String)("Processing image " + file.getName() + (edgeImage != null ? " under consideration of edge image in " + edgeImage.getTitle() : "") + "..."));
                this.seq = this.createSequenceImage(sequenceSlice, edgeImage, start, end, step, this.pottsWeight, this.edgeWeight);
                if (sequenceLength == -1) {
                    sequenceLength = this.seq.getStackSize();
                }
                for (int s = 0; s < this.seq.getStack().getSize(); ++s) {
                    resultStack.addSlice("", this.seq.getStack().getProcessor(s + 1), zslice - 1 + s * zslice);
                }
            }
            ImagePlus result = new ImagePlus();
            result.setTitle("sequence-" + sequenceImage.getTitle());
            result.setStack(resultStack);
            result.setDimensions(1, zslices, sequenceLength);
            if (zslices * sequenceLength > 1) {
                result.setOpenAsHyperStack(true);
            }
            if (showResults) {
                result.show();
                result.updateAndDraw();
            }
            if (storeResults) {
                String filename = storeDir + File.separator + file.getName();
                IJ.log((String)("Saving results to " + filename));
                IJ.save((ImagePlus)result, (String)filename);
                if (!showResults) {
                    result.close();
                }
            }
            sequenceImage.close();
        }
    }

    private float edgeLikelihood(float value1, float value2, long[] position1, long[] position2, long[] dimensions) {
        float dist = 0.0f;
        for (int d = 0; d < dimensions.length; ++d) {
            dist += (float)((position1[d] - position2[d]) * (position1[d] - position2[d]));
        }
        dist = (float)Math.sqrt(dist);
        return (float)Math.exp(-((value1 - value2) * (value1 - value2)) / (2.0f * this.edgeVariance)) / dist;
    }

    private int listPosition(long[] imagePosition, long[] dimensions) {
        int pos = 0;
        int fac = 1;
        for (int d = 0; d < dimensions.length; ++d) {
            pos = (int)((long)pos + (long)fac * imagePosition[d]);
            fac = (int)((long)fac * dimensions[d]);
        }
        return pos;
    }

    private void setButtonsEnabled(boolean enabled) {
        this.applyButton.setEnabled(enabled);
        this.batchButton.setEnabled(enabled);
        this.overlayButton.setEnabled(enabled);
        this.sequenceButton.setEnabled(enabled);
    }

    private class GraphCutWindow
    extends ImageWindow {
        final ExecutorService exec;
        private ActionListener actionListener;
        private ChangeListener changeListener;

        GraphCutWindow(ImagePlus imp) {
            super(imp, (ImageCanvas)new CustomCanvas(imp));
            this.exec = Executors.newFixedThreadPool(1);
            this.actionListener = new ActionListener(){

                @Override
                public void actionPerformed(final ActionEvent e) {
                    GraphCutWindow.this.exec.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long end;
                            long start;
                            if (e.getSource() == Graph_Cut.this.applyButton) {
                                try {
                                    Graph_Cut.this.setButtonsEnabled(false);
                                    start = System.currentTimeMillis();
                                    Graph_Cut.this.updateSegmentationImage();
                                    end = System.currentTimeMillis();
                                    Graph_Cut.this.seg.show();
                                    Graph_Cut.this.seg.updateAndDraw();
                                    IJ.log((String)("Total time: " + (end - start) + "ms"));
                                    Graph_Cut.this.showColorOverlay = false;
                                    GraphCutWindow.this.toggleOverlay();
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                                finally {
                                    Graph_Cut.this.setButtonsEnabled(true);
                                }
                            }
                            if (e.getSource() == Graph_Cut.this.sequenceButton) {
                                try {
                                    Graph_Cut.this.setButtonsEnabled(false);
                                    start = System.currentTimeMillis();
                                    Graph_Cut.this.createSequence();
                                    end = System.currentTimeMillis();
                                    Graph_Cut.this.seq.show();
                                    Graph_Cut.this.seq.updateAndDraw();
                                    IJ.log((String)("Total time: " + (end - start) + "ms"));
                                }
                                catch (Exception e3) {
                                    e3.printStackTrace();
                                }
                                finally {
                                    Graph_Cut.this.setButtonsEnabled(true);
                                }
                            } else if (e.getSource() == Graph_Cut.this.overlayButton) {
                                GraphCutWindow.this.toggleOverlay();
                            } else if (e.getSource() == Graph_Cut.this.batchButton) {
                                Graph_Cut.this.batchProcessImages();
                            }
                            if (e.getSource() == Graph_Cut.this.edgeSelector) {
                                Graph_Cut.this.edge = (ImagePlus)Graph_Cut.this.edgeSelector.getSelectedItem();
                            }
                        }
                    });
                }
            };
            this.changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (e.getSource() == Graph_Cut.this.pottsSlider) {
                        Graph_Cut.this.pottsWeight = (float)source.getValue() * 0.01f;
                    }
                    if (e.getSource() == Graph_Cut.this.edgeSlider) {
                        Graph_Cut.this.edgeWeight = (float)source.getValue() * 0.1f;
                    }
                    if (e.getSource() == Graph_Cut.this.edgeVarianceSlider) {
                        Graph_Cut.this.edgeVariance = (float)source.getValue() * 0.1f;
                    }
                    if (e.getSource() == Graph_Cut.this.dataSlider) {
                        Graph_Cut.this.dataWeight = (float)source.getValue() * 0.01f;
                    }
                }
            };
            Graph_Cut.this.applyButton = new JButton("Segment image");
            Graph_Cut.this.applyButton.setToolTipText("Start the min-cut computation");
            Graph_Cut.this.batchButton = new JButton("Batch process");
            Graph_Cut.this.batchButton.setToolTipText("Apply the plugin to several images");
            Graph_Cut.this.overlayButton = new JButton("Toggle overlay");
            Graph_Cut.this.overlayButton.setToolTipText("Toggle the segmentation overlay in the image");
            Graph_Cut.this.sequenceButton = new JButton("Create sequence");
            Graph_Cut.this.sequenceButton.setToolTipText("Create a sequence of segmentations with different parameters");
            Graph_Cut.this.dataSlider = new JSlider(0, 0, 100, 50);
            Graph_Cut.this.dataSlider.setToolTipText("Adjust the expected numbers of foreground pixels.");
            Graph_Cut.this.dataSlider.setMajorTickSpacing(500);
            Graph_Cut.this.dataSlider.setMinorTickSpacing(10);
            Graph_Cut.this.dataSlider.setPaintTicks(true);
            Graph_Cut.this.dataSlider.setPaintLabels(true);
            Graph_Cut.this.pottsSlider = new JSlider(0, 0, 1000, 500);
            Graph_Cut.this.pottsSlider.setToolTipText("Adjust the smoothness of the segmentation.");
            Graph_Cut.this.pottsSlider.setMajorTickSpacing(500);
            Graph_Cut.this.pottsSlider.setMinorTickSpacing(10);
            Graph_Cut.this.pottsSlider.setPaintTicks(true);
            Graph_Cut.this.pottsSlider.setPaintLabels(true);
            Graph_Cut.this.edgeSlider = new JSlider(0, 0, 1000, 500);
            Graph_Cut.this.edgeSlider.setToolTipText("Adjust the influence of the edge image.");
            Graph_Cut.this.edgeSlider.setMajorTickSpacing(500);
            Graph_Cut.this.edgeSlider.setMinorTickSpacing(10);
            Graph_Cut.this.edgeSlider.setPaintTicks(true);
            Graph_Cut.this.edgeSlider.setPaintLabels(true);
            Graph_Cut.this.edgeVarianceSlider = new JSlider(0, 0, 1000, 500);
            Graph_Cut.this.edgeVarianceSlider.setToolTipText("Set the variance of the edge image.");
            Graph_Cut.this.edgeVarianceSlider.setMajorTickSpacing(500);
            Graph_Cut.this.edgeVarianceSlider.setMinorTickSpacing(10);
            Graph_Cut.this.edgeVarianceSlider.setPaintTicks(true);
            Graph_Cut.this.edgeVarianceSlider.setPaintLabels(true);
            Vector<ImagePlus> windowList = new Vector<ImagePlus>();
            int[] windowIds = WindowManager.getIDList();
            windowList.add(null);
            for (int i = 0; windowIds != null && i < windowIds.length; ++i) {
                windowList.add(WindowManager.getImage((int)windowIds[i]));
            }
            Graph_Cut.this.edgeSelector = new JComboBox(windowList);
            Graph_Cut.this.resultOverlay = new ImageOverlay();
            byte[] red = new byte[256];
            byte[] green = new byte[256];
            byte[] blue = new byte[256];
            for (int i = 0; i < 256; ++i) {
                if (i < 128) {
                    red[i] = -1;
                    green[i] = 0;
                    blue[i] = 0;
                    continue;
                }
                red[i] = 0;
                green[i] = -1;
                blue[i] = 0;
            }
            Graph_Cut.this.overlayLUT = new LUT(red, green, blue);
            AlphaComposite composite = AlphaComposite.getInstance(3, Graph_Cut.this.overlayAlpha);
            Graph_Cut.this.resultOverlay.setComposite(composite);
            ((OverlayedImageCanvas)this.ic).addOverlay((OverlayedImageCanvas.Overlay)Graph_Cut.this.resultOverlay);
            this.removeAll();
            this.setTitle("Graph Cut");
            Graph_Cut.this.applyButton.addActionListener(this.actionListener);
            Graph_Cut.this.batchButton.addActionListener(this.actionListener);
            Graph_Cut.this.overlayButton.addActionListener(this.actionListener);
            Graph_Cut.this.sequenceButton.addActionListener(this.actionListener);
            Graph_Cut.this.dataSlider.addChangeListener(this.changeListener);
            Graph_Cut.this.pottsSlider.addChangeListener(this.changeListener);
            Graph_Cut.this.edgeSlider.addChangeListener(this.changeListener);
            Graph_Cut.this.edgeVarianceSlider.addChangeListener(this.changeListener);
            Graph_Cut.this.edgeSelector.addActionListener(this.actionListener);
            Graph_Cut.this.applyPanel = new JPanel();
            Graph_Cut.this.applyPanel.setBorder(BorderFactory.createTitledBorder("Apply"));
            GridBagLayout applyLayout = new GridBagLayout();
            GridBagConstraints applyConstraints = new GridBagConstraints();
            applyConstraints.anchor = 18;
            applyConstraints.fill = 2;
            applyConstraints.gridwidth = 1;
            applyConstraints.gridheight = 1;
            applyConstraints.gridx = 0;
            applyConstraints.gridy = 0;
            applyConstraints.insets = new Insets(5, 5, 6, 6);
            Graph_Cut.this.applyPanel.setLayout(applyLayout);
            Graph_Cut.this.applyPanel.add((Component)Graph_Cut.this.applyButton, applyConstraints);
            ++applyConstraints.gridy;
            Graph_Cut.this.applyPanel.add((Component)Graph_Cut.this.batchButton, applyConstraints);
            ++applyConstraints.gridy;
            Graph_Cut.this.applyPanel.add((Component)Graph_Cut.this.overlayButton, applyConstraints);
            ++applyConstraints.gridy;
            Graph_Cut.this.applyPanel.add((Component)Graph_Cut.this.sequenceButton, applyConstraints);
            ++applyConstraints.gridy;
            GridBagLayout dataLayout = new GridBagLayout();
            GridBagConstraints dataConstraints = new GridBagConstraints();
            Graph_Cut.this.dataPanel = new JPanel();
            Graph_Cut.this.dataPanel.setBorder(BorderFactory.createTitledBorder("Foreground bias"));
            Graph_Cut.this.dataPanel.setLayout(dataLayout);
            dataConstraints.anchor = 18;
            dataConstraints.fill = 2;
            dataConstraints.gridwidth = 1;
            dataConstraints.gridheight = 1;
            dataConstraints.gridx = 0;
            dataConstraints.gridy = 0;
            Graph_Cut.this.dataPanel.add((Component)Graph_Cut.this.dataSlider, dataConstraints);
            ++dataConstraints.gridy;
            dataConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout pottsLayout = new GridBagLayout();
            GridBagConstraints pottsConstraints = new GridBagConstraints();
            Graph_Cut.this.pottsPanel = new JPanel();
            Graph_Cut.this.pottsPanel.setBorder(BorderFactory.createTitledBorder("Smoothness"));
            Graph_Cut.this.pottsPanel.setLayout(pottsLayout);
            pottsConstraints.anchor = 18;
            pottsConstraints.fill = 2;
            pottsConstraints.gridwidth = 1;
            pottsConstraints.gridheight = 1;
            pottsConstraints.gridx = 0;
            pottsConstraints.gridy = 0;
            Graph_Cut.this.pottsPanel.add((Component)Graph_Cut.this.pottsSlider, pottsConstraints);
            ++pottsConstraints.gridy;
            pottsConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout edgesLayout = new GridBagLayout();
            GridBagConstraints edgesConstraints = new GridBagConstraints();
            Graph_Cut.this.edgesPanel = new JPanel();
            Graph_Cut.this.edgesPanel.setBorder(BorderFactory.createTitledBorder("Edge image influence"));
            Graph_Cut.this.edgesPanel.setLayout(edgesLayout);
            edgesConstraints.anchor = 18;
            edgesConstraints.fill = 2;
            edgesConstraints.gridwidth = 1;
            edgesConstraints.gridheight = 1;
            edgesConstraints.gridx = 0;
            edgesConstraints.gridy = 0;
            Graph_Cut.this.edgesPanel.add((Component)Graph_Cut.this.edgeSlider, edgesConstraints);
            ++edgesConstraints.gridy;
            edgesConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout edgeVarianceLayout = new GridBagLayout();
            GridBagConstraints edgeVarianceConstraints = new GridBagConstraints();
            Graph_Cut.this.edgeVariancePanel = new JPanel();
            Graph_Cut.this.edgeVariancePanel.setBorder(BorderFactory.createTitledBorder("Edge image decay"));
            Graph_Cut.this.edgeVariancePanel.setLayout(edgeVarianceLayout);
            edgeVarianceConstraints.anchor = 18;
            edgeVarianceConstraints.fill = 2;
            edgeVarianceConstraints.gridwidth = 1;
            edgeVarianceConstraints.gridheight = 1;
            edgeVarianceConstraints.gridx = 0;
            edgeVarianceConstraints.gridy = 0;
            Graph_Cut.this.edgeVariancePanel.add((Component)Graph_Cut.this.edgeVarianceSlider, edgeVarianceConstraints);
            ++edgeVarianceConstraints.gridy;
            edgeVarianceConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout edgeSelectorLayout = new GridBagLayout();
            GridBagConstraints edgeSelectorConstraints = new GridBagConstraints();
            Graph_Cut.this.edgeSelectorPanel = new JPanel();
            Graph_Cut.this.edgeSelectorPanel.setBorder(BorderFactory.createTitledBorder("Edge image"));
            Graph_Cut.this.edgeSelectorPanel.setLayout(edgeSelectorLayout);
            edgeSelectorConstraints.anchor = 18;
            edgeSelectorConstraints.fill = 2;
            edgeSelectorConstraints.gridwidth = 1;
            edgeSelectorConstraints.gridheight = 1;
            edgeSelectorConstraints.gridx = 0;
            edgeSelectorConstraints.gridy = 0;
            Graph_Cut.this.edgeSelectorPanel.add((Component)Graph_Cut.this.edgeSelector, edgeSelectorConstraints);
            ++edgeSelectorConstraints.gridy;
            edgeSelectorConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout buttonsLayout = new GridBagLayout();
            GridBagConstraints buttonsConstraints = new GridBagConstraints();
            Graph_Cut.this.buttonsPanel = new JPanel();
            Graph_Cut.this.buttonsPanel.setLayout(buttonsLayout);
            buttonsConstraints.anchor = 18;
            buttonsConstraints.fill = 2;
            buttonsConstraints.gridwidth = 1;
            buttonsConstraints.gridheight = 1;
            buttonsConstraints.gridx = 0;
            buttonsConstraints.gridy = 0;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.applyPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.dataPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.pottsPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.edgesPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.edgeVariancePanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            Graph_Cut.this.buttonsPanel.add((Component)Graph_Cut.this.edgeSelectorPanel, buttonsConstraints);
            ++buttonsConstraints.gridy;
            buttonsConstraints.insets = new Insets(5, 5, 6, 6);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints allConstraints = new GridBagConstraints();
            Graph_Cut.this.all.setLayout(layout);
            allConstraints.anchor = 18;
            allConstraints.fill = 2;
            allConstraints.gridwidth = 1;
            allConstraints.gridheight = 1;
            allConstraints.gridx = 0;
            allConstraints.gridy = 0;
            allConstraints.weightx = 0.0;
            allConstraints.weighty = 0.0;
            Graph_Cut.this.all.add((Component)Graph_Cut.this.buttonsPanel, allConstraints);
            ++allConstraints.gridx;
            allConstraints.weightx = 1.0;
            allConstraints.weighty = 1.0;
            final CustomCanvas canvas = (CustomCanvas)this.getCanvas();
            Graph_Cut.this.all.add((Component)((Object)canvas), allConstraints);
            GridBagLayout wingb = new GridBagLayout();
            GridBagConstraints winc = new GridBagConstraints();
            winc.anchor = 18;
            winc.fill = 1;
            winc.weightx = 1.0;
            winc.weighty = 1.0;
            this.setLayout(wingb);
            this.add(Graph_Cut.this.all, winc);
            for (Component p : new Component[]{Graph_Cut.this.all, Graph_Cut.this.buttonsPanel}) {
                for (KeyListener kl : this.getKeyListeners()) {
                    p.addKeyListener(kl);
                }
            }
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    GraphCutWindow.this.exec.shutdownNow();
                    Graph_Cut.this.applyButton.removeActionListener(GraphCutWindow.this.actionListener);
                    Graph_Cut.this.batchButton.removeActionListener(GraphCutWindow.this.actionListener);
                    Graph_Cut.this.overlayButton.removeActionListener(GraphCutWindow.this.actionListener);
                    Graph_Cut.this.sequenceButton.removeActionListener(GraphCutWindow.this.actionListener);
                    Graph_Cut.this.pottsSlider.removeChangeListener(GraphCutWindow.this.changeListener);
                    Graph_Cut.this.edgeSlider.removeChangeListener(GraphCutWindow.this.changeListener);
                    Graph_Cut.this.edgeSelector.removeActionListener(GraphCutWindow.this.actionListener);
                }
            });
            canvas.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent ce) {
                    Rectangle r = canvas.getBounds();
                    canvas.setDstDimensions(r.width, r.height);
                }
            });
        }

        void toggleOverlay() {
            Graph_Cut.this.showColorOverlay = !Graph_Cut.this.showColorOverlay;
            if (Graph_Cut.this.showColorOverlay) {
                ImageProcessor overlay = Graph_Cut.this.seg.getProcessor().duplicate();
                double shift = 127.0;
                overlay.multiply(shift + 1.0);
                overlay = overlay.convertToByte(false);
                overlay.setColorModel((ColorModel)Graph_Cut.this.overlayLUT);
                Graph_Cut.this.resultOverlay.setImage(overlay);
            } else {
                Graph_Cut.this.resultOverlay.setImage(null);
            }
            Graph_Cut.this.displayImage.updateAndDraw();
        }
    }

    private class CustomCanvas
    extends OverlayedImageCanvas {
        CustomCanvas(ImagePlus imp) {
            super(imp);
            Dimension dim = new Dimension(Math.min(512, imp.getWidth()), Math.min(512, imp.getHeight()));
            this.setMinimumSize(dim);
            this.setSize(dim.width, dim.height);
            this.setDstDimensions(dim.width, dim.height);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent ke) {
                    CustomCanvas.this.repaint();
                }
            });
        }

        public void setDrawingSize(int w, int h) {
        }

        public void setDstDimensions(int width, int height) {
            int y;
            this.dstWidth = width;
            this.dstHeight = height;
            int w = Math.min((int)((double)width / this.magnification), this.imp.getWidth());
            int h = Math.min((int)((double)height / this.magnification), this.imp.getHeight());
            int x = this.srcRect.x;
            if (x + w > this.imp.getWidth()) {
                x = w - this.imp.getWidth();
            }
            if ((y = this.srcRect.y) + h > this.imp.getHeight()) {
                y = h - this.imp.getHeight();
            }
            this.srcRect.setRect(x, y, w, h);
            this.repaint();
        }

        public void paint(Graphics g) {
            Rectangle srcRect = this.getSrcRect();
            double mag = this.getMagnification();
            int dw = (int)((double)srcRect.width * mag);
            int dh = (int)((double)srcRect.height * mag);
            g.setClip(0, 0, dw, dh);
            super.paint(g);
            int w = this.getWidth();
            int h = this.getHeight();
            g.setClip(0, 0, w, h);
            g.setColor(this.getBackground());
            g.fillRect(dw, 0, w - dw, h);
            g.fillRect(0, dh, w, h - dh);
        }
    }
}

