/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.SincInterpolator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SincInterpolatorTest
extends TestCase {
    private double[] _emaxs = new double[]{0.1, 0.01, 0.001};
    private double[] _fmaxs = new double[]{0.1, 0.3, 0.4, 0.45};
    private int[] _lmaxs = new int[]{8, 10, 12, 14, 16};

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(SincInterpolatorTest.class);
        TestRunner.run((Test)suite);
    }

    public void testExtrapolation() {
        int ix;
        SincInterpolator si = new SincInterpolator();
        Random random = new Random();
        int lmax = si.getMaximumLength();
        int nxu = 2 * lmax;
        int npad = lmax;
        double dxu = 1.0;
        double fxu = npad;
        int nx = npad + nxu + npad;
        double dx = 0.999;
        double fx = npad;
        float[] yi = new float[nxu];
        float[] yz = new float[nx];
        float[] yc = new float[nx];
        float[] yo = new float[nx];
        float[] yt = new float[nx];
        for (int ixu = 0; ixu < nxu; ++ixu) {
            float f = random.nextFloat();
            yc[ixu + npad] = f;
            yz[ixu + npad] = f;
            yi[ixu] = f;
        }
        for (int ipad = 0; ipad < npad; ++ipad) {
            yc[ipad] = yc[npad];
            yc[npad + nxu + ipad] = yc[npad + nxu - 1];
        }
        si.setExtrapolation(SincInterpolator.Extrapolation.ZERO);
        si.interpolate(nxu, dxu, fxu, yi, nx, dx, fx, yo);
        si.interpolate(npad + nxu + npad, dxu, 0.0, yz, nx, dx, fx, yt);
        for (ix = 0; ix < nx; ++ix) {
            SincInterpolatorTest.assertEquals((double)yo[ix], (double)yt[ix], (double)0.0);
        }
        si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
        si.interpolate(nxu, dxu, fxu, yi, nx, dx, fx, yo);
        si.interpolate(npad + nxu + npad, dxu, 0.0, yc, nx, dx, fx, yt);
        for (ix = 0; ix < nx; ++ix) {
            SincInterpolatorTest.assertEquals((double)yo[ix], (double)yt[ix], (double)0.0);
        }
    }

    public void testComplex() {
        int ix;
        SincInterpolator si = new SincInterpolator();
        Random random = new Random();
        int nxu = 100;
        double dxu = 3.14159;
        double fxu = 1.23456;
        float[] yr = new float[nxu];
        float[] yi = new float[nxu];
        float[] yc = new float[2 * nxu];
        for (int ixu = 0; ixu < nxu; ++ixu) {
            float f = random.nextFloat();
            yc[2 * ixu] = f;
            yr[ixu] = f;
            float f2 = random.nextFloat();
            yc[2 * ixu + 1] = f2;
            yi[ixu] = f2;
        }
        int nx = 200;
        double dx = -0.9 * dxu;
        double fx = fxu + (double)(nxu + 30) * dxu;
        float[] zr = new float[nx];
        float[] zi = new float[nx];
        float[] zc = new float[2 * nx];
        si.setExtrapolation(SincInterpolator.Extrapolation.ZERO);
        si.interpolate(nxu, dxu, fxu, yr, nx, dx, fx, zr);
        si.interpolate(nxu, dxu, fxu, yi, nx, dx, fx, zi);
        si.interpolateComplex(nxu, dxu, fxu, yc, nx, dx, fx, zc);
        for (ix = 0; ix < nx; ++ix) {
            SincInterpolatorTest.assertEquals((double)zr[ix], (double)zc[2 * ix], (double)0.0);
            SincInterpolatorTest.assertEquals((double)zi[ix], (double)zc[2 * ix + 1], (double)0.0);
        }
        si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
        si.interpolate(nxu, dxu, fxu, yr, nx, dx, fx, zr);
        si.interpolate(nxu, dxu, fxu, yi, nx, dx, fx, zi);
        si.interpolateComplex(nxu, dxu, fxu, yc, nx, dx, fx, zc);
        for (ix = 0; ix < nx; ++ix) {
            SincInterpolatorTest.assertEquals((double)zr[ix], (double)zc[2 * ix], (double)0.0);
            SincInterpolatorTest.assertEquals((double)zi[ix], (double)zc[2 * ix + 1], (double)0.0);
        }
    }

    public void testErrorAndFrequency() {
        for (double emax : this._emaxs) {
            for (double fmax : this._fmaxs) {
                SincInterpolator si = SincInterpolator.fromErrorAndFrequency(emax, fmax);
                this.testInterpolator(si);
            }
        }
    }

    public void testErrorAndLength() {
        for (double emax : this._emaxs) {
            for (int lmax : this._lmaxs) {
                SincInterpolator si = SincInterpolator.fromErrorAndLength(emax, lmax);
                this.testInterpolator(si);
            }
        }
    }

    public void testFrequencyAndLength() {
        for (double fmax : this._fmaxs) {
            for (int lmax : this._lmaxs) {
                if (!((1.0 - 2.0 * fmax) * (double)lmax > 1.0)) continue;
                SincInterpolator si = SincInterpolator.fromFrequencyAndLength(fmax, lmax);
                this.testInterpolator(si);
            }
        }
    }

    public void testAccumulate() {
        Random random = new Random(123456L);
        for (int repeat = 0; repeat < 5; ++repeat) {
            for (SincInterpolator.Extrapolation extrapolation : SincInterpolator.Extrapolation.values()) {
                int nxu = 201;
                double fxu = Math.PI;
                double dxu = Math.E;
                double exu = fxu + dxu * (double)(nxu - 1);
                float[] yu = new float[nxu];
                for (int i = 0; i < nxu; ++i) {
                    yu[i] = 2.0f * random.nextFloat() - 1.0f;
                }
                int nx = 2 * nxu;
                float[] x = new float[nx];
                float[] y = new float[nx];
                for (int i = 0; i < nxu; ++i) {
                    x[i] = (float)((1.2 * (double)random.nextFloat() - 0.1) * (exu - fxu) + fxu);
                    y[i] = 2.0f * random.nextFloat() - 1.0f;
                }
                SincInterpolator si = new SincInterpolator();
                si.setExtrapolation(extrapolation);
                float[] yi = new float[nx];
                si.interpolate(nxu, dxu, fxu, yu, nx, x, yi);
                float[] ya = new float[nxu];
                si.accumulate(nx, x, y, nxu, dxu, fxu, ya);
                double yuYa = 0.0;
                for (int ixu = 0; ixu < nxu; ++ixu) {
                    yuYa += (double)(yu[ixu] * ya[ixu]);
                }
                double yYi = 0.0;
                for (int ix = 0; ix < nx; ++ix) {
                    yYi += (double)(y[ix] * yi[ix]);
                }
                double ratio = yuYa / yYi;
                String message = "yu.ya=" + yuYa + " y.yi=" + yYi + " ratio=" + ratio;
                SincInterpolatorTest.trace(message);
                assert (ratio > 0.99999 && ratio < 1.00001) : message;
            }
        }
    }

    private void testInterpolator(SincInterpolator si) {
        this.testInterpolatorWithSweep(si);
    }

    private void testInterpolatorWithSweep(SincInterpolator si) {
        double emax = si.getMaximumError();
        double fmax = si.getMaximumFrequency();
        int lmax = si.getMaximumLength();
        long nbytes = si.getTableBytes();
        SincInterpolatorTest.trace("lmax=" + lmax + " fmax=" + fmax + " emax=" + emax + " nbytes=" + nbytes);
        int nmax = (int)(1000.0 * fmax);
        double xmax = Math.PI * (double)nmax / fmax;
        double dxu = 1.0;
        double fxu = 0.0;
        int nxu = 1 + (int)((xmax - fxu) / dxu);
        dxu = (xmax - fxu) / (double)(nxu - 1);
        float[] yu = new float[nxu];
        for (int ixu = 0; ixu < nxu; ++ixu) {
            double x = fxu + (double)ixu * dxu;
            yu[ixu] = (float)this.sweep(fmax, nmax, x);
        }
        si.setExtrapolation(SincInterpolator.Extrapolation.CONSTANT);
        double dx = 0.01 * dxu;
        double fx = 0.0;
        int nx = 1 + (int)((xmax - fx) / dx);
        dx = (xmax - fx) / (double)(nx - 1);
        float[] y = new float[nx];
        si.interpolate(nxu, dxu, fxu, yu, nx, dx, fx, y);
        double error = 0.0;
        for (int ix = 0; ix < nx; ++ix) {
            double yi = y[ix];
            double x = fx + (double)ix * dx;
            double ys = this.sweep(fmax, nmax, x);
            double ei = Math.abs(yi - ys);
            if (ei > emax) {
                SincInterpolatorTest.trace("    x=" + x + " ys=" + ys + " yi=" + yi);
            }
            error = Math.max(error, ei);
            SincInterpolatorTest.assertEquals((double)ys, (double)yi, (double)emax);
        }
        SincInterpolatorTest.trace("  error=" + error);
        if (error > emax) {
            SincInterpolatorTest.trace("  WARNING: error = " + error + " > emax = " + emax);
        }
        double shift = 0.5 * dxu;
        nx = nxu;
        dx = dxu;
        fx = fxu + shift;
        si.interpolate(nxu, dxu, fxu, yu, nx, dx, fx, y);
        error = 0.0;
        for (int ix = 0; ix < nx; ++ix) {
            double yi = y[ix];
            double x = fx + (double)ix * dx;
            double ys = this.sweep(fmax, nmax, x);
            double ei = Math.abs(yi - ys);
            if (ei > emax) {
                SincInterpolatorTest.trace("    x=" + x + " ys=" + ys + " yi=" + yi);
            }
            error = Math.max(error, ei);
            SincInterpolatorTest.assertEquals((double)ys, (double)yi, (double)emax);
        }
        SincInterpolatorTest.trace("  error=" + error);
    }

    private double sweep(double fmax, int nmax, double x) {
        return Math.cos(Math.PI * 2 * (double)nmax * Math.cos(x * fmax / (double)nmax));
    }

    private static void trace(String s) {
    }
}

