/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.CubicInterpolator;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class BicubicInterpolator2 {
    private int _n1;
    private int _n2;
    private float[] _x1;
    private float[] _x2;
    private float[][][][] _a;
    private int[] _ks = new int[]{0, 0};
    private static final float[][] AINV = new float[][]{{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-3.0f, 3.0f, 0.0f, 0.0f, -2.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {2.0f, -2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -3.0f, 3.0f, 0.0f, 0.0f, -2.0f, -1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 2.0f, -2.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f}, {-3.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, -3.0f, 0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -2.0f, 0.0f, -1.0f, 0.0f}, {9.0f, -9.0f, -9.0f, 9.0f, 6.0f, 3.0f, -6.0f, -3.0f, 6.0f, -6.0f, 3.0f, -3.0f, 4.0f, 2.0f, 2.0f, 1.0f}, {-6.0f, 6.0f, 6.0f, -6.0f, -3.0f, -3.0f, 3.0f, 3.0f, -4.0f, 4.0f, -2.0f, 2.0f, -2.0f, -2.0f, -1.0f, -1.0f}, {2.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f, -2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f}, {-6.0f, 6.0f, 6.0f, -6.0f, -4.0f, -2.0f, 4.0f, 2.0f, -3.0f, 3.0f, -3.0f, 3.0f, -2.0f, -1.0f, -2.0f, -1.0f}, {4.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f, -2.0f, -2.0f, 2.0f, -2.0f, 2.0f, -2.0f, 1.0f, 1.0f, 1.0f, 1.0f}};

    public BicubicInterpolator2(float[] x1, float[] x2, float[][] y) {
        this(Method.MONOTONIC, Method.MONOTONIC, x1, x2, y);
    }

    public BicubicInterpolator2(Method method1, Method method2, float[] x1, float[] x2, float[][] y) {
        this(method1, method2, x1.length, x2.length, x1, x2, y);
    }

    public BicubicInterpolator2(Method method1, Method method2, int n1, int n2, float[] x1, float[] x2, float[][] y) {
        Check.argument(ArrayMath.isMonotonic(x1), "array x1 is monotonic");
        Check.argument(ArrayMath.isMonotonic(x2), "array x2 is monotonic");
        this._n1 = n1;
        this._n2 = n2;
        this._x1 = ArrayMath.copy(n1, x1);
        this._x2 = ArrayMath.copy(n2, x2);
        this._a = BicubicInterpolator2.makeCoefficients(method1, method2, n1, n2, x1, x2, y);
    }

    public float interpolate(float x1, float x2) {
        return this.interpolate00(x1, x2);
    }

    public float interpolate00(float x1, float x2) {
        return this.interpolate00(x1, x2, this._ks);
    }

    public float interpolate10(float x1, float x2) {
        return this.interpolate10(x1, x2, this._ks);
    }

    public float interpolate01(float x1, float x2) {
        return this.interpolate01(x1, x2, this._ks);
    }

    public float[][] interpolate(Sampling s1, Sampling s2) {
        return this.interpolate00(s1, s2);
    }

    public float[][] interpolate00(Sampling s1, Sampling s2) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        float[][] y = new float[n2][n1];
        this.interpolate00(s1, s2, y);
        return y;
    }

    public void interpolate(Sampling s1, Sampling s2, float[][] y) {
        this.interpolate00(s1, s2, y);
    }

    public void interpolate00(Sampling s1, Sampling s2, float[][] y) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int[] k1 = BicubicInterpolator2.makeIndices(s1, this._x1);
        int[] k2 = BicubicInterpolator2.makeIndices(s2, this._x2);
        for (int i2 = 0; i2 < n2; ++i2) {
            float x2 = (float)s2.getValue(i2);
            for (int i1 = 0; i1 < n1; ++i1) {
                float x1 = (float)s1.getValue(i1);
                y[i2][i1] = this.interpolate00(x1, x2, k1[i1], k2[i2]);
            }
        }
    }

    public float[][] interpolate(float[] x1, float[] x2) {
        return this.interpolate00(x1, x2);
    }

    public float[][] interpolate00(float[] x1, float[] x2) {
        int n1 = x1.length;
        int n2 = x2.length;
        float[][] y = new float[n2][n1];
        this.interpolate00(x1, x2, y);
        return y;
    }

    public void interpolate(float[] x1, float[] x2, float[][] y) {
        this.interpolate00(x1, x2, y);
    }

    public void interpolate00(float[] x1, float[] x2, float[][] y) {
        int n1 = x1.length;
        int n2 = x2.length;
        int[] k1 = BicubicInterpolator2.makeIndices(x1, this._x1);
        int[] k2 = BicubicInterpolator2.makeIndices(x2, this._x2);
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                y[i2][i1] = this.interpolate00(x1[i1], x2[i2], k1[i1], k2[i2]);
            }
        }
    }

    private static void trace(String s) {
        System.out.println(s);
    }

    private static int index(float x, float[] xs, int i) {
        if ((i = ArrayMath.binarySearch(xs, x, i)) < 0) {
            int n = i = i < -1 ? -2 - i : 0;
        }
        if (i >= xs.length - 1) {
            i = xs.length - 2;
        }
        return i;
    }

    private void updateIndices(float x1, float x2, int[] ks) {
        ks[0] = BicubicInterpolator2.index(x1, this._x1, ks[0]);
        ks[1] = BicubicInterpolator2.index(x2, this._x2, ks[1]);
    }

    private static int[] makeIndices(float[] xi, float[] xs) {
        int n = xi.length;
        int[] ki = new int[n];
        ki[0] = BicubicInterpolator2.index(xi[0], xs, 0);
        for (int i = 1; i < n; ++i) {
            ki[i] = BicubicInterpolator2.index(xi[i], xs, ki[i - 1]);
        }
        return ki;
    }

    private static int[] makeIndices(Sampling si, float[] xs) {
        int n = si.getCount();
        int[] ki = new int[n];
        ki[0] = BicubicInterpolator2.index((float)si.getValue(0), xs, 0);
        for (int i = 1; i < n; ++i) {
            ki[i] = BicubicInterpolator2.index((float)si.getValue(i), xs, ki[i - 1]);
        }
        return ki;
    }

    private float interpolate00(float x1, float x2, int[] ks) {
        this.updateIndices(x1, x2, ks);
        return this.interpolate00(x1, x2, ks[0], ks[1]);
    }

    private float interpolate10(float x1, float x2, int[] ks) {
        this.updateIndices(x1, x2, ks);
        return this.interpolate10(x1, x2, ks[0], ks[1]);
    }

    private float interpolate01(float x1, float x2, int[] ks) {
        this.updateIndices(x1, x2, ks);
        return this.interpolate01(x1, x2, ks[0], ks[1]);
    }

    private float interpolate00(float x1, float x2, int k1, int k2) {
        return BicubicInterpolator2.eval00(this._a[k2][k1], x1 - this._x1[k1], x2 - this._x2[k2]);
    }

    private float interpolate10(float x1, float x2, int k1, int k2) {
        return BicubicInterpolator2.eval10(this._a[k2][k1], x1 - this._x1[k1], x2 - this._x2[k2]);
    }

    private float interpolate01(float x1, float x2, int k1, int k2) {
        return BicubicInterpolator2.eval01(this._a[k2][k1], x1 - this._x1[k1], x2 - this._x2[k2]);
    }

    private static float eval00(float[][] a, float d1, float d2) {
        return a[0][0] + d1 * (a[0][1] + d1 * (a[0][2] + d1 * a[0][3])) + d2 * (a[1][0] + d1 * (a[1][1] + d1 * (a[1][2] + d1 * a[1][3])) + d2 * (a[2][0] + d1 * (a[2][1] + d1 * (a[2][2] + d1 * a[2][3])) + d2 * (a[3][0] + d1 * (a[3][1] + d1 * (a[3][2] + d1 * a[3][3])))));
    }

    private static float eval10(float[][] a, float d1, float d2) {
        return a[0][1] + d2 * (a[1][1] + d2 * (a[2][1] + d2 * a[3][1])) + d1 * (2.0f * (a[0][2] + d2 * (a[1][2] + d2 * (a[2][2] + d2 * a[3][2]))) + d1 * (3.0f * (a[0][3] + d2 * (a[1][3] + d2 * (a[2][3] + d2 * a[3][3])))));
    }

    private static float eval01(float[][] a, float d1, float d2) {
        return a[1][0] + d1 * (a[1][1] + d1 * (a[1][2] + d1 * a[1][3])) + d2 * (2.0f * (a[2][0] + d1 * (a[2][1] + d1 * (a[2][2] + d1 * a[2][3]))) + d2 * (3.0f * (a[3][0] + d1 * (a[3][1] + d1 * (a[3][2] + d1 * a[3][3])))));
    }

    private static float[][] getA(float[] dxs, float[][] yds) {
        float d1 = dxs[1];
        float d2 = dxs[2];
        float[][] a = new float[4][4];
        int i = 0;
        for (int m2 = 0; m2 < 4; ++m2) {
            int m1 = 0;
            while (m1 < 4) {
                float am = 0.0f;
                int j = 0;
                for (int jd = 0; jd < 4; ++jd) {
                    int jp = 0;
                    while (jp < 4) {
                        if (AINV[i][j] != 0.0f) {
                            am += AINV[i][j] * yds[jd][jp] * dxs[jd];
                        }
                        ++jp;
                        ++j;
                    }
                }
                a[m2][m1] = am /= ArrayMath.pow(d1, (float)m1) * ArrayMath.pow(d2, (float)m2);
                ++m1;
                ++i;
            }
        }
        return a;
    }

    private static float[][][] makeDerivatives(Method method1, Method method2, int n1, int n2, float[] x1, float[] x2, float[][] y) {
        CubicInterpolator.Method cim1 = CubicInterpolator.Method.MONOTONIC;
        CubicInterpolator.Method cim2 = CubicInterpolator.Method.MONOTONIC;
        if (method1 == Method.SPLINE) {
            cim1 = CubicInterpolator.Method.SPLINE;
        }
        if (method2 == Method.SPLINE) {
            cim2 = CubicInterpolator.Method.SPLINE;
        }
        float[][] y00 = y;
        float[][] y10 = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] ys = new float[n1];
            for (int i1 = 0; i1 < n1; ++i1) {
                ys[i1] = y[i2][i1];
            }
            CubicInterpolator ci = new CubicInterpolator(cim1, n1, x1, ys);
            for (int i1 = 0; i1 < n1; ++i1) {
                y10[i2][i1] = ci.interpolate1(x1[i1]);
            }
        }
        float[][] y01 = new float[n2][n1];
        for (int i1 = 0; i1 < n1; ++i1) {
            float[] ys = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ys[i2] = y[i2][i1];
            }
            CubicInterpolator ci = new CubicInterpolator(cim2, n2, x2, ys);
            for (int i2 = 0; i2 < n2; ++i2) {
                y01[i2][i1] = ci.interpolate1(x2[i2]);
            }
        }
        float[][] y11 = new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] ys = new float[n1];
            for (int i1 = 0; i1 < n1; ++i1) {
                ys[i1] = y01[i2][i1];
            }
            CubicInterpolator ci = new CubicInterpolator(cim1, n1, x1, ys);
            for (int i1 = 0; i1 < n1; ++i1) {
                float[] fArray = y11[i2];
                int n = i1;
                fArray[n] = fArray[n] + 0.5f * ci.interpolate1(x1[i1]);
            }
        }
        for (int i1 = 0; i1 < n1; ++i1) {
            float[] ys = new float[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                ys[i2] = y10[i2][i1];
            }
            CubicInterpolator ci = new CubicInterpolator(cim2, n2, x2, ys);
            for (int i2 = 0; i2 < n2; ++i2) {
                float[] fArray = y11[i2];
                int n = i1;
                fArray[n] = fArray[n] + 0.5f * ci.interpolate1(x2[i2]);
            }
        }
        return new float[][][]{y00, y10, y01, y11};
    }

    private static float[][][][] makeCoefficients(Method method1, Method method2, int n1, int n2, float[] x1, float[] x2, float[][] y) {
        float[][][] yd = BicubicInterpolator2.makeDerivatives(method1, method2, n1, n2, x1, x2, y);
        float[][] y00 = yd[0];
        float[][] y10 = yd[1];
        float[][] y01 = yd[2];
        float[][] y11 = yd[3];
        float[][][][] a = new float[n2 - 1][n1 - 1][4][4];
        int i2 = 0;
        int j2 = 1;
        while (i2 < n2 - 1) {
            float dx2 = x2[j2] - x2[i2];
            int i1 = 0;
            int j1 = 1;
            while (i1 < n1 - 1) {
                float dx1 = x1[j1] - x1[i1];
                float[] dxs = new float[]{1.0f, dx1, dx2, dx1 * dx2};
                float[][] yds = new float[][]{{y00[i2][i1], y00[i2][j1], y00[j2][i1], y00[j2][j1]}, {y10[i2][i1], y10[i2][j1], y10[j2][i1], y10[j2][j1]}, {y01[i2][i1], y01[i2][j1], y01[j2][i1], y01[j2][j1]}, {y11[i2][i1], y11[i2][j1], y11[j2][i1], y11[j2][j1]}};
                a[i2][i1] = BicubicInterpolator2.getA(dxs, yds);
                ++i1;
                ++j1;
            }
            ++i2;
            ++j2;
        }
        return a;
    }

    public static enum Method {
        MONOTONIC,
        SPLINE;

    }
}

