/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Point4;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.Vector3;

public class Point3
extends Tuple3 {
    public Point3() {
    }

    public Point3(double x, double y, double z) {
        super(x, y, z);
    }

    public Point3(Point4 p) {
        super(p.x / p.w, p.y / p.w, p.z / p.w);
    }

    public Point3(Point3 p) {
        super(p.x, p.y, p.z);
    }

    public Point3 plus(Vector3 v) {
        return new Point3(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Point3 minus(Vector3 v) {
        return new Point3(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3 minus(Point3 q) {
        return new Vector3(this.x - q.x, this.y - q.y, this.z - q.z);
    }

    public Point3 plusEquals(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Point3 minusEquals(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Point3 affine(double a, Point3 q) {
        double b = 1.0 - a;
        Point3 p = this;
        return new Point3(b * p.x + a * q.x, b * p.y + a * q.y, b * p.z + a * q.z);
    }

    public double distanceTo(Point3 q) {
        double dx = this.x - q.x;
        double dy = this.y - q.y;
        double dz = this.z - q.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

