/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryStripArrayRetained;
import org.scijava.java3d.J3dI18N;

public abstract class GeometryStripArray
extends GeometryArray {
    GeometryStripArray() {
    }

    public GeometryStripArray(int vertexCount, int vertexFormat, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat);
        ((GeometryStripArrayRetained)this.retained).setStripVertexCounts(stripVertexCounts);
    }

    public GeometryStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap);
        ((GeometryStripArrayRetained)this.retained).setStripVertexCounts(stripVertexCounts);
    }

    public GeometryStripArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int[] stripVertexCounts) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        ((GeometryStripArrayRetained)this.retained).setStripVertexCounts(stripVertexCounts);
    }

    public int getNumStrips() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryStripArray0"));
        }
        return ((GeometryStripArrayRetained)this.retained).getNumStrips();
    }

    public void setStripVertexCounts(int[] stripVertexCounts) {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryStripArray2"));
        }
        ((GeometryStripArrayRetained)this.retained).setStripVertexCounts(stripVertexCounts);
    }

    public void getStripVertexCounts(int[] stripVertexCounts) {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("GeometryStripArray1"));
        }
        ((GeometryStripArrayRetained)this.retained).getStripVertexCounts(stripVertexCounts);
    }

    @Override
    public void setValidVertexCount(int validVertexCount) {
        throw new UnsupportedOperationException();
    }
}

