/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.behaviors.mouse;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnAWTEvent;
import org.scijava.java3d.WakeupOnBehaviorPost;
import org.scijava.java3d.utils.behaviors.mouse.MouseBehavior;
import org.scijava.java3d.utils.behaviors.mouse.MouseBehaviorCallback;
import org.scijava.vecmath.Vector3d;

public class MouseTranslate
extends MouseBehavior {
    double x_factor = 0.02;
    double y_factor = 0.02;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseTranslate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseTranslate() {
        super(0);
    }

    public MouseTranslate(int flags) {
        super(flags);
    }

    public MouseTranslate(Component c) {
        super(c, 0);
    }

    public MouseTranslate(Component c, TransformGroup transformGroup) {
        super(c, transformGroup);
    }

    public MouseTranslate(Component c, int flags) {
        super(c, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double factor) {
        this.x_factor = this.y_factor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.x_factor = xFactor;
        this.y_factor = yFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn(this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        this.processMouseEvent(evt);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int id = evt.getID();
            if (id == 506 && !evt.isAltDown() && evt.isMetaDown()) {
                this.x = evt.getX();
                this.y = evt.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                if (!this.reset && Math.abs(dy) < 50 && Math.abs(dx) < 50) {
                    this.transformGroup.getTransform(this.currXform);
                    this.translation.x = (double)dx * this.x_factor;
                    this.translation.y = (double)(-dy) * this.y_factor;
                    this.transformX.set(this.translation);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                    }
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(1, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == 501) {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

