/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform.inverse;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.inverse.AbstractDifferentiableRealTransform;
import net.imglib2.realtransform.inverse.DifferentiableRealTransform;

public class RegularizedDifferentiableRealTransform
extends AbstractDifferentiableRealTransform {
    protected final DifferentiableRealTransform dxfm;
    protected final double epsilon;

    public RegularizedDifferentiableRealTransform(DifferentiableRealTransform dxfm, double epsilon) {
        this.dxfm = dxfm;
        this.epsilon = epsilon;
    }

    @Override
    public AffineTransform jacobian(double[] x) {
        AffineTransform jac = this.dxfm.jacobian(x);
        for (int i = 0; i < jac.numSourceDimensions(); ++i) {
            jac.set(this.epsilon + (1.0 - this.epsilon) * jac.get(i, i), i, i);
        }
        return jac;
    }

    @Override
    public int numSourceDimensions() {
        return this.dxfm.numSourceDimensions();
    }

    @Override
    public int numTargetDimensions() {
        return this.dxfm.numTargetDimensions();
    }

    @Override
    public void apply(double[] source, double[] target) {
        this.dxfm.apply(source, target);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        this.dxfm.apply(source, target);
    }

    @Override
    public DifferentiableRealTransform copy() {
        return this.dxfm.copy();
    }
}

