/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import ij.ImagePlus;
import ij.ImageStack;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import sc.fiji.kappa.curve.BSpline;
import sc.fiji.kappa.curve.BezierGroup;
import sc.fiji.kappa.curve.BezierPoint;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.ControlPanel;
import sc.fiji.kappa.gui.ImageUtils;
import sc.fiji.kappa.gui.InfoPanel;
import sc.fiji.kappa.gui.KappaMenuBar;
import sc.fiji.kappa.gui.Overlay;
import sc.fiji.kappa.gui.ToolPanel;

public class KappaFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static final boolean DEBUG_MODE = false;
    public static final boolean DEFAULT_CTRL_PT_ADJUSTMENT = false;
    private boolean enableCtrlPtAdjustment = false;
    public static final String APPLICATION_NAME = "Kappa";
    public static final int APP_DEFAULT_WIDTH = 1250;
    public static final int APP_DEFAULT_HEIGHT = 950;
    public static final int APP_MIN_WIDTH = 700;
    public static final int APP_MIN_HEIGHT = 550;
    public static final int APP_DEFAULT_X = 0;
    public static final int APP_DEFAULT_Y = 0;
    public static final Color PANEL_COLOR = new Color(240, 240, 240);
    public static final Color DRAWING_PANEL_COLOR = new Color(180, 180, 180);
    public static final int COMBO_BOX_HEIGHT_OSX = 22;
    public static final int SCROLL_BAR_THICKNESS = 19;
    public static final double PERCENT_END_CONDITIONS = 0.1;
    public static final int PANEL_WIDTH = 225;
    public static final int DEFAULT_NO_CTRL_PTS = 4;
    public static final boolean ANTIALIASING_DEFAULT = false;
    public static final int DEFAULT_BG_THRESHOLD = 36;
    public static final int BG_AVERAGING_RANGE = 1;
    public static final String[] FITTING_ALGORITHMS = new String[]{"Point Distance Minimization", "Squared Distance Minimization"};
    public static final String[] CURVE_TYPES = new String[]{"B\u00e9zier Curve", "B-Spline"};
    public static final int BEZIER_CURVE = 0;
    public static final int B_SPLINE = 1;
    public static final int DEFAULT_INPUT_CURVE = 1;
    public static final String[] BSPLINE_TYPES = new String[]{"Open", "Closed"};
    private int bsplineType;
    private int inputType;
    public static final int DEFAULT_FITTING_ALGORITHM = 0;
    private String fittingAlgorithm;
    private double globalThreshold = 0.05;
    private double localThreshold = 0.05;
    private static final int DEFAULT_NUMBER_POINTS = 1000;
    private Overlay overlay;
    private BezierGroup curves = new BezierGroup(this);
    private List<Point2D> points = new ArrayList<Point2D>(4);
    private Curve currEditedCurve;
    private int currCtrlPt = 0;
    private boolean controlPointSelected;
    private boolean shiftPressed;
    private boolean dragged;
    private boolean fittingRunning;
    private int prevIndex;
    private final int INIT_LAYER = 1;
    private int maxLayer;
    private int maxLayerDigits;
    private ImagePlus displayedImageStack;
    private ImagePlus imageStack;
    private ImageStack[] imageStackLayers;
    private BufferedImage currImage;
    private BufferedImage scaled;
    private JLabel currImageLabel;
    private boolean[][] thresholded;
    private ScrollDrawingPane scrollPane;
    private double baseStrokeThickness = 1.0;
    private BufferedImage combined;
    private InfoPanel infoPanel;
    private ControlPanel controlPanel;
    private ToolPanel toolPanel;
    private KappaMenuBar kappaMenubar;
    @Parameter
    private Context context;

    public KappaFrame(Context context) {
        super(APPLICATION_NAME);
        context.inject((Object)this);
        this.setSize(1250, 950);
        this.setLocation(0, 0);
        this.setLayout(new BorderLayout());
        this.setInfoPanel(new InfoPanel(this));
        this.setControlPanel(new ControlPanel(this));
        this.setToolPanel(new ToolPanel(this));
        this.add((Component)this.getInfoPanel(), "East");
        this.add((Component)this.getControlPanel(), "South");
        this.add((Component)this.getToolPanel(), "North");
        this.setOverlay(new Overlay(this));
        this.setGlassPane(this.getOverlay());
        this.getOverlay().setOpaque(false);
        this.setInputType(1);
        this.setBsplineType(0);
        this.setFittingAlgorithm(FITTING_ALGORITHMS[0]);
        this.setCurrImageLabel(new JLabel());
        this.getCurrImageLabel().setHorizontalAlignment(0);
        this.setScrollPane(new ScrollDrawingPane(this.getCurrImageLabel()));
        this.getScrollPane().setVisible(true);
        this.add(this.getScrollPane());
        this.getScrollPane().getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "space pressed");
        this.getScrollPane().getInputMap().put(KeyStroke.getKeyStroke("released SPACE"), "space released");
        this.getScrollPane().getActionMap().put("space pressed", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!KappaFrame.this.getToolPanel().isEnabled(1) || KappaFrame.this.getToolPanel().isSelected(1)) {
                    return;
                }
                KappaFrame.this.setPrevIndex(0);
                while (!KappaFrame.this.getToolPanel().isSelected(KappaFrame.this.getPrevIndex())) {
                    KappaFrame.this.setPrevIndex(KappaFrame.this.getPrevIndex() + 1);
                }
                KappaFrame.this.getToolPanel().setSelected(1, true);
                KappaFrame.this.getScrollPane().setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        this.getScrollPane().getActionMap().put("space released", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!KappaFrame.this.getToolPanel().isEnabled(1)) {
                    return;
                }
                KappaFrame.this.getToolPanel().setSelected(KappaFrame.this.getPrevIndex(), true);
                KappaFrame.this.getScrollPane().setCursor(ToolPanel.TOOL_CURSORS[KappaFrame.this.getPrevIndex()]);
            }
        });
        this.getScrollPane().getInputMap().put(KeyStroke.getKeyStroke(16, 64), "shift pressed");
        this.getScrollPane().getInputMap().put(KeyStroke.getKeyStroke("released SHIFT"), "shift released");
        this.getScrollPane().getActionMap().put("shift pressed", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                KappaFrame.this.setShiftPressed(true);
            }
        });
        this.getScrollPane().getActionMap().put("shift released", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent event) {
                KappaFrame.this.setShiftPressed(false);
            }
        });
        this.setImageStack(null);
        this.setKappaMenubar(new KappaMenuBar(context, this));
        this.setJMenuBar(this.getKappaMenubar());
        this.setFocusable(true);
        this.requestFocusInWindow();
    }

    public InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    public BezierGroup getCurves() {
        return this.curves;
    }

    public List<Point2D> getPoints() {
        return this.points;
    }

    public ImagePlus getDisplayedImageStack() {
        return this.displayedImageStack;
    }

    public ImagePlus getImageStack() {
        return this.imageStack;
    }

    public BufferedImage getCurrImage() {
        return this.currImage;
    }

    public JLabel getCurrImageLabel() {
        return this.currImageLabel;
    }

    public KappaMenuBar getKappaMenubar() {
        return this.kappaMenubar;
    }

    public void fitCurves() {
        if (this.getCurves().getNoSelected() == 0) {
            return;
        }
        this.setFittingRunning(true);
        this.getOverlay().setVisible(true);
        this.getOverlay().drawNotification("Fitting in Progress...", this.getScrollPane().getVisibleRect(), -1);
        for (Curve c : this.getCurves().getSelected()) {
            List<Double> weights;
            List<Point2D> dataPoints;
            double oldError;
            if (!(c instanceof BSpline)) continue;
            double error = Double.MAX_VALUE;
            c.deshiftControlPoints(this.getControlPanel().getCurrentLayerSlider().getValue());
            boolean wasOpen = ((BSpline)c).isOpen();
            if (!((BSpline)c).isOpen()) {
                ((BSpline)c).convertToOpen(this.getControlPanel().getCurrentLayerSlider().getValue());
            }
            while ((oldError = error) > (error = ((BSpline)c).fittingIteration(dataPoints = c.getThresholdedPixels(), weights = this.getWeights(dataPoints), this.getControlPanel().getCurrentLayerSlider().getValue()))) {
            }
            error = oldError;
            if (this.isEnableCtrlPtAdjustment()) {
                ((BSpline)c).adjustControlPoints(dataPoints, weights, this.getControlPanel().getCurrentLayerSlider().getValue());
            }
            if (!wasOpen) {
                ((BSpline)c).convertToClosed(this.getControlPanel().getCurrentLayerSlider().getValue());
            }
            c.shiftControlPoints(this.getControlPanel().getCurrentLayerSlider().getValue());
            this.getInfoPanel().repaint();
            this.drawImageOverlay();
            this.getInfoPanel().updateHistograms();
        }
        this.setFittingRunning(false);
        this.getOverlay().setVisible(false);
    }

    public void resetCurves() {
        this.getInfoPanel().setListData(new Vector<String>());
        this.getInfoPanel().getList().setListData(this.getInfoPanel().getListData());
        this.setCurves(new BezierGroup(this));
    }

    protected void setScaledImage(double scale) {
        if (this.getCurrImage() == null) {
            return;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        int w = (int)(scale * (double)this.getCurrImage().getWidth());
        int h = (int)(scale * (double)this.getCurrImage().getHeight());
        this.setScaled(config.createCompatibleImage(w, h, 1));
        Graphics2D g2 = this.getScaled().createGraphics();
        if (this.getKappaMenubar().getAntialiasingMenu().getState()) {
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        g2.drawImage(this.getCurrImage(), 0, 0, w, h, null);
        if (this.getInfoPanel().getBgCheckBox().isSelected()) {
            g2.setColor(Color.ORANGE);
            for (int i = 0; i < this.getCurrImage().getWidth(); ++i) {
                for (int j = 0; j < this.getCurrImage().getHeight(); ++j) {
                    if (!this.getThresholded()[i][j]) continue;
                    g2.fillRect((int)Math.round((double)i * scale), (int)Math.round((double)j * scale), (int)Math.round(scale), (int)Math.round(scale));
                }
            }
        }
        g2.dispose();
    }

    public void drawImageOverlay() {
        if (this.getCurrImage() == null) {
            return;
        }
        double scale = (double)this.getControlPanel().getScaleSlider().getValue() / 100.0;
        this.combined = new BufferedImage(this.getScaled().getWidth(), this.getScaled().getHeight(), 1);
        Graphics2D g2 = (Graphics2D)this.combined.getGraphics();
        g2.drawImage((Image)this.getScaled(), 0, 0, null);
        if (this.getInfoPanel().getShowDatapointsCheckBox().isSelected()) {
            for (Curve c : this.getCurves()) {
                c.drawThresholdedPixels(g2, scale);
            }
        }
        g2.setColor(Color.GRAY);
        double strokeThickness = this.getStrokeThickness(scale);
        g2.setStroke(new BasicStroke((int)strokeThickness));
        int currentPoint = this.getInfoPanel().getPointSlider().getValue();
        if (this.curves.getSelected().length >= 1 && currentPoint > this.curves.getSelected()[0].getNoPoints()) {
            currentPoint = 0;
        }
        this.getCurves().draw(g2, scale, currentPoint, this.getKappaMenubar().getBoundingBoxMenu().getState(), this.getKappaMenubar().getScaleCurvesMenu().getState(), this.getKappaMenubar().getTangentMenu().getState(), this.getInfoPanel().getShowRadiusCheckBox().isSelected());
        if (this.getCurrCtrlPt() != 0) {
            int i;
            g2.setColor(Color.GRAY);
            for (i = 0; i < this.getCurrCtrlPt() - 1; ++i) {
                g2.drawLine((int)(this.getPoints().get(i).getX() * scale), (int)(this.getPoints().get(i).getY() * scale), (int)(this.getPoints().get(i + 1).getX() * scale), (int)(this.getPoints().get(i + 1).getY() * scale));
            }
            if (this.getInputType() == 1 && this.getBsplineType() == 1) {
                g2.drawLine((int)(this.getPoints().get(0).getX() * scale), (int)(this.getPoints().get(0).getY() * scale), (int)(this.getPoints().get(this.getPoints().size() - 1).getX() * scale), (int)(this.getPoints().get(this.getPoints().size() - 1).getY() * scale));
            }
            g2.setColor(Curve.CTRL_PT_COLOR);
            for (i = 0; i < this.getCurrCtrlPt(); ++i) {
                g2.fillRect((int)((this.getPoints().get(i).getX() - this.getCtrlPointSize()) * scale), (int)((this.getPoints().get(i).getY() - this.getCtrlPointSize()) * scale), (int)(2.0 * this.getCtrlPointSize() * scale), (int)(2.0 * this.getCtrlPointSize() * scale));
            }
        }
        this.getCurrImageLabel().setIcon(new ImageIcon(this.combined));
    }

    protected void setLayer(int layer, double scale) {
        this.setFrame(layer);
        this.setCurrImage(this.getDisplayedImageStack().getBufferedImage());
        this.setScaledImage(scale);
        this.getCurves().changeFrame(layer);
        this.updateDisplayed();
    }

    protected void setDisplayedChannels(boolean showRed, boolean showGreen, boolean showBlue) {
        this.getInfoPanel().setHistogramVisibility(showRed, showGreen, showBlue);
        this.setScaledImage((double)this.getControlPanel().getScaleSlider().getValue() / 100.0);
        this.getInfoPanel().repaint();
        this.drawImageOverlay();
    }

    protected void updateThresholded() {
        int thresholdLevel = this.getInfoPanel().getThresholdSlider().getValue();
        int channel = this.getInfoPanel().getThresholdChannelsComboBox().getSelectedIndex();
        ImageUtils imgUtils = new ImageUtils();
        for (int i = 0; i < this.getCurrImage().getWidth(); ++i) {
            for (int j = 0; j < this.getCurrImage().getHeight(); ++j) {
                int intensity;
                int[] rgb = imgUtils.getPixels(this.getDisplayedImageStack(), i, j);
                switch (channel) {
                    case 0: {
                        intensity = rgb[0];
                        break;
                    }
                    case 1: {
                        intensity = rgb[1];
                        break;
                    }
                    case 2: {
                        intensity = rgb[2];
                        break;
                    }
                    default: {
                        intensity = (rgb[0] + rgb[1] + rgb[2]) / 3;
                    }
                }
                this.getThresholded()[i][j] = intensity < thresholdLevel;
            }
        }
        this.setScaledImage((double)this.getControlPanel().getScaleSlider().getValue() / 100.0);
        this.drawImageOverlay();
    }

    private Point mapPoint(Point p) {
        Point ref = this.getScrollPane().getViewport().getViewPosition();
        if (this.getScrollPane().getHorizontalScrollBar().isVisible() && this.getScrollPane().getVerticalScrollBar().isVisible()) {
            return new Point(p.x + ref.x - 3, p.y + ref.y - 3);
        }
        if (this.getScrollPane().getVerticalScrollBar().isVisible()) {
            return new Point(p.x - (this.getCurrImageLabel().getWidth() - (int)((double)this.getControlPanel().getScaleSlider().getValue() / 100.0 * (double)this.getCurrImage().getWidth())) / 2 - 3, p.y + ref.y - 3);
        }
        if (this.getScrollPane().getHorizontalScrollBar().isVisible()) {
            return new Point(p.x + ref.x - 3, p.y - (this.getCurrImageLabel().getHeight() - (int)((double)this.getControlPanel().getScaleSlider().getValue() / 100.0 * (double)this.getCurrImage().getHeight())) / 2 - 3);
        }
        return new Point(p.x - (this.getCurrImageLabel().getWidth() - (int)((double)this.getControlPanel().getScaleSlider().getValue() / 100.0 * (double)this.getCurrImage().getWidth())) / 2 - 3, p.y - (this.getCurrImageLabel().getHeight() - (int)((double)this.getControlPanel().getScaleSlider().getValue() / 100.0 * (double)this.getCurrImage().getHeight())) / 2 - 3);
    }

    public String formatNumber(int number, int noDigits) {
        int i;
        if (number == 0) {
            return "0000";
        }
        StringBuilder numberAsString = new StringBuilder();
        int start = 1;
        for (i = 1; i < noDigits; ++i) {
            start *= 10;
        }
        for (i = start; i > number; i /= 10) {
            numberAsString.append("0");
        }
        numberAsString.append(Integer.toString(number));
        return numberAsString.toString();
    }

    private List<Double> getWeights(List<Point2D> dataPoints) {
        ArrayList<Double> weights = new ArrayList<Double>(dataPoints.size());
        ImageUtils imgUtils = new ImageUtils();
        for (Point2D p : dataPoints) {
            int[] rgb = imgUtils.getPixels(this.getDisplayedImageStack(), (int)p.getX(), (int)p.getY());
            int channel = this.getInfoPanel().getFittingChannelsComboBox().getSelectedIndex();
            double intensity = 0.0;
            switch (channel) {
                case 0: {
                    intensity = rgb[0];
                    break;
                }
                case 1: {
                    intensity = rgb[1];
                    break;
                }
                case 2: {
                    intensity = rgb[2];
                    break;
                }
                case 3: {
                    intensity = (rgb[0] + rgb[1] + rgb[2]) / 3;
                }
            }
            if (this.getInfoPanel().getDataRangeComboBox().getSelectedIndex() == 1) {
                intensity = this.getDisplayedImageStack().getBitDepth() == 24 ? 256.0 - intensity : (double)((int)(Math.pow(2.0, this.getDisplayedImageStack().getBitDepth()) - intensity));
            }
            weights.add(intensity);
        }
        return weights;
    }

    protected void updateDisplayed() {
        this.updateDisplayed(true);
    }

    protected void updateDisplayed(boolean updateHistogram) {
        if (this.getInfoPanel().getBgCheckBox().isSelected()) {
            this.updateThresholded();
        }
        this.drawImageOverlay();
        if (updateHistogram) {
            this.getInfoPanel().updateHistograms();
        }
    }

    protected void enterCurve() {
        if (this.getInputType() == 1) {
            this.getCurves().addCurve(this.getPoints(), this.getControlPanel().getCurrentLayerSlider().getValue(), this.getCurrCtrlPt(), 1, this.getBsplineType() == 0, (Integer)this.getInfoPanel().getThresholdRadiusSpinner().getValue());
        } else {
            this.getCurves().addCurve(this.getPoints(), this.getControlPanel().getCurrentLayerSlider().getValue(), this.getCurrCtrlPt(), 0, true, (Integer)this.getInfoPanel().getThresholdRadiusSpinner().getValue());
        }
        this.getInfoPanel().updateHistograms();
        this.getInfoPanel().getListData().addElement("  CURVE " + this.getCurves().getCount());
        this.getInfoPanel().getList().setListData(this.getInfoPanel().getListData());
        this.getInfoPanel().getList().setSelectedIndex(this.getCurves().size() - 1);
        this.getInfoPanel().getCurvesList().revalidate();
        this.getInfoPanel().getPointSlider().setEnabled(true);
        this.getInfoPanel().getPointSlider().setValue(0);
        this.setCurrCtrlPt(0);
        this.getKappaMenubar().getEnter().setEnabled(false);
        this.drawImageOverlay();
    }

    protected void deleteCurve() {
        if (this.getCurrCtrlPt() != 0) {
            this.setCurrCtrlPt(0);
        }
        if (this.getInfoPanel().getList().isSelectionEmpty()) {
            this.drawImageOverlay();
            return;
        }
        int[] selectedIndices = this.getInfoPanel().getList().getSelectedIndices();
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            this.getInfoPanel().getListData().removeElementAt(selectedIndices[i]);
            this.getCurves().remove(selectedIndices[i]);
        }
        this.getInfoPanel().getList().setListData(this.getInfoPanel().getListData());
        this.getScrollPane().revalidate();
        this.drawImageOverlay();
        this.getInfoPanel().repaint();
        this.getControlPanel().repaint();
    }

    public void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public double computeCurvature(double x, double a, double b) {
        return Math.abs(a * b * b * Math.sin(b * x) / Math.pow(1.0 + a * a * b * b * Math.cos(b * x) * Math.cos(b * x), 1.5)) / Curve.getMicronPixelFactor();
    }

    public double getCurvatureError(Curve c, double a, double b) {
        int noPoints = 0;
        double totalCurvatureError = 0.0;
        for (BezierPoint p : c.getDigitizedPoints()) {
            if (!(p.getX() >= (double)this.getCurrImage().getWidth() * 0.1) || !(p.getX() <= (double)this.getCurrImage().getWidth() * 0.9)) continue;
            totalCurvatureError += Math.abs(p.k - this.computeCurvature(p.getX(), a, b));
            ++noPoints;
        }
        return totalCurvatureError / ((double)noPoints * 1.0);
    }

    public double computePearsonR(Curve c, double a, double b) {
        List<BezierPoint> points = c.getDigitizedPoints();
        double m1 = 0.0;
        double m2 = 0.0;
        for (BezierPoint p : points) {
            m1 += p.k;
            m2 += this.computeCurvature(p.getX(), a, b);
        }
        m1 /= (double)points.size();
        m2 /= (double)points.size();
        double covariance = 0.0;
        double sd1 = 0.0;
        double sd2 = 0.0;
        for (BezierPoint p : points) {
            covariance += (p.k - m1) * (this.computeCurvature(p.getX(), a, b) - m2);
            sd1 += this.squared(p.k - m1);
            sd2 += this.squared(this.computeCurvature(p.getX(), a, b) - m2);
        }
        sd1 = Math.sqrt(sd1);
        sd2 = Math.sqrt(sd2);
        return covariance / (sd1 * sd2);
    }

    private double squared(double x) {
        return x * x;
    }

    private void setIntensityThreshold(double sigma) {
        ImageUtils imgUtils = new ImageUtils();
        double avgIntensity = 0.0;
        for (int x = 0; x < this.getCurrImage().getWidth(); ++x) {
            for (int y = 0; y < this.getCurrImage().getHeight(); ++y) {
                avgIntensity += (double)imgUtils.getPixels(this.getDisplayedImageStack(), x, y)[0];
            }
        }
        avgIntensity /= (double)(this.getCurrImage().getWidth() * this.getCurrImage().getHeight());
        double stdDev = 0.0;
        for (int x = 0; x < this.getCurrImage().getWidth(); ++x) {
            for (int y = 0; y < this.getCurrImage().getHeight(); ++y) {
                stdDev += this.squared((double)imgUtils.getPixels(this.getDisplayedImageStack(), x, y)[0] - avgIntensity);
            }
        }
        stdDev /= (double)(this.getCurrImage().getWidth() * this.getCurrImage().getHeight() - 1);
        stdDev = Math.sqrt(stdDev);
        System.out.println("Intensity Threshold: " + (int)(avgIntensity + sigma * stdDev));
        this.getInfoPanel().getDataThresholdSlider().setValue(Math.min((int)(avgIntensity + sigma * stdDev), 255));
    }

    public void setDisplayedImageStack(ImagePlus displayedImageStack) {
        this.displayedImageStack = displayedImageStack;
    }

    public void setImageStack(ImagePlus imageStack) {
        this.imageStack = imageStack;
    }

    public ImageStack[] getImageStackLayers() {
        return this.imageStackLayers;
    }

    public void setImageStackLayers(ImageStack[] imageStackLayers) {
        this.imageStackLayers = imageStackLayers;
    }

    public void setCurrImage(BufferedImage currImage) {
        this.currImage = currImage;
    }

    public BufferedImage getScaled() {
        return this.scaled;
    }

    public void setScaled(BufferedImage scaled) {
        this.scaled = scaled;
    }

    public void setCurrImageLabel(JLabel currImageLabel) {
        this.currImageLabel = currImageLabel;
    }

    protected boolean[][] getThresholded() {
        return this.thresholded;
    }

    protected void setThresholded(boolean[][] thresholded) {
        this.thresholded = thresholded;
    }

    public ScrollDrawingPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(ScrollDrawingPane scrollPane) {
        this.scrollPane = scrollPane;
    }

    public void setInfoPanel(InfoPanel infoPanel) {
        this.infoPanel = infoPanel;
    }

    public void setControlPanel(ControlPanel controlPanel) {
        this.controlPanel = controlPanel;
    }

    public void setToolPanel(ToolPanel toolPanel) {
        this.toolPanel = toolPanel;
    }

    public void setKappaMenubar(KappaMenuBar kappaMenubar) {
        this.kappaMenubar = kappaMenubar;
    }

    public int getMaxLayerDigits() {
        return this.maxLayerDigits;
    }

    public void setMaxLayerDigits(int maxLayerDigits) {
        this.maxLayerDigits = maxLayerDigits;
    }

    public int getMaxLayer() {
        return this.maxLayer;
    }

    public void setMaxLayer(int maxLayer) {
        this.maxLayer = maxLayer;
    }

    public int getINIT_LAYER() {
        return 1;
    }

    public int getPrevIndex() {
        return this.prevIndex;
    }

    public void setPrevIndex(int prevIndex) {
        this.prevIndex = prevIndex;
    }

    public boolean isFittingRunning() {
        return this.fittingRunning;
    }

    public void setFittingRunning(boolean fittingRunning) {
        this.fittingRunning = fittingRunning;
    }

    public boolean isDragged() {
        return this.dragged;
    }

    public void setDragged(boolean dragged) {
        this.dragged = dragged;
    }

    public boolean isShiftPressed() {
        return this.shiftPressed;
    }

    public void setShiftPressed(boolean shiftPressed) {
        this.shiftPressed = shiftPressed;
    }

    public boolean isControlPointSelected() {
        return this.controlPointSelected;
    }

    public void setControlPointSelected(boolean controlPointSelected) {
        this.controlPointSelected = controlPointSelected;
    }

    public int getCurrCtrlPt() {
        return this.currCtrlPt;
    }

    public void setCurrCtrlPt(int currCtrlPt) {
        this.currCtrlPt = currCtrlPt;
    }

    public Curve getCurrEditedCurve() {
        return this.currEditedCurve;
    }

    public void setCurrEditedCurve(Curve currEditedCurve) {
        this.currEditedCurve = currEditedCurve;
    }

    public void setPoints(List<Point2D> points) {
        this.points = points;
    }

    public void setCurves(BezierGroup curves) {
        this.curves = curves;
    }

    public void setOverlay(Overlay overlay) {
        this.overlay = overlay;
    }

    public String getFittingAlgorithm() {
        return this.fittingAlgorithm;
    }

    public void setFittingAlgorithm(String fittingAlgorithm) {
        this.fittingAlgorithm = fittingAlgorithm;
    }

    public int getInputType() {
        return this.inputType;
    }

    public void setInputType(int inputType) {
        this.inputType = inputType;
    }

    public int getBsplineType() {
        return this.bsplineType;
    }

    public void setBsplineType(int bsplineType) {
        this.bsplineType = bsplineType;
    }

    public boolean isEnableCtrlPtAdjustment() {
        return this.enableCtrlPtAdjustment;
    }

    public void setEnableCtrlPtAdjustment(boolean enableCtrlPtAdjustment) {
        this.enableCtrlPtAdjustment = enableCtrlPtAdjustment;
    }

    public double getGlobalThreshold() {
        return this.globalThreshold;
    }

    public void setGlobalThreshold(double globalThreshold) {
        this.globalThreshold = globalThreshold;
    }

    public double getLocalThreshold() {
        return this.localThreshold;
    }

    public void setLocalThreshold(double localThreshold) {
        this.localThreshold = localThreshold;
    }

    public int getNumberOfPointsPerCurve() {
        int n = this.curves.getSelected().length >= 1 ? this.curves.getSelected()[0].getNoPoints() : 1000;
        if (this.infoPanel != null && this.infoPanel.getPointSlider() != null && n != this.infoPanel.getPointSlider().getMaximum()) {
            this.infoPanel.getPointSlider().setMaximum(n);
            this.infoPanel.getPointSlider().setValue(1);
        }
        return n;
    }

    public boolean isImageRGBColor() {
        return this.getImageStack().getType() == 4 || this.getImageStack().getType() == 3;
    }

    public int getNFrames() {
        if (this.imageStack.getNSlices() > this.imageStack.getNFrames()) {
            return this.imageStack.getNSlices();
        }
        return this.imageStack.getNFrames();
    }

    public void setFrame(int frame) {
        if (this.imageStack.getNSlices() > this.imageStack.getNFrames()) {
            this.imageStack.setZ(frame);
        } else {
            this.imageStack.setT(frame);
        }
    }

    public boolean hasMultipleChannels() {
        return this.imageStack.getNChannels() > 1;
    }

    public double getStrokeThickness(double scale) {
        return this.baseStrokeThickness * scale;
    }

    public double getBaseStrokeThickness() {
        return this.baseStrokeThickness;
    }

    public void setBaseStrokeThickness(double strokeThickness) {
        this.baseStrokeThickness = strokeThickness;
    }

    public double getCtrlPointSize() {
        return 1.0 * this.baseStrokeThickness;
    }

    public double getSelectedCtrlPointSize() {
        return 2.0 * this.baseStrokeThickness;
    }

    public BufferedImage getCombinedImage() {
        return this.combined;
    }

    protected class ScrollDrawingPane
    extends JScrollPane {
        private static final long serialVersionUID = 1L;
        Point startPoint;
        Point startOrigin;

        public ScrollDrawingPane(JLabel imageLabel) {
            super(imageLabel);
            this.getViewport().setBackground(DRAWING_PANEL_COLOR);
            this.startPoint = new Point(0, 0);
            this.addMouseListener(new MouseHandler());
            this.addMouseMotionListener(new MouseMotionHandler());
            this.addMouseWheelListener(new MouseWheelHandler());
            this.setFocusable(true);
        }

        private class MouseWheelHandler
        implements MouseWheelListener {
            private MouseWheelHandler() {
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                double scale = (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0;
                if (notches < 0) {
                    int i;
                    KappaFrame.this.getControlPanel();
                    if (scale <= ControlPanel.SCALE_INCREMENTS[0]) {
                        return;
                    }
                    KappaFrame.this.getControlPanel();
                    KappaFrame.this.getControlPanel();
                    for (i = 1; i < ControlPanel.SCALE_INCREMENTS.length && ControlPanel.SCALE_INCREMENTS[i] < scale; ++i) {
                    }
                    KappaFrame.this.getControlPanel();
                    KappaFrame.this.getControlPanel().getScaleSlider().setValue((int)Math.floor(100.0 * ControlPanel.SCALE_INCREMENTS[--i]));
                } else {
                    int i;
                    KappaFrame.this.getControlPanel();
                    KappaFrame.this.getControlPanel();
                    if (scale >= ControlPanel.SCALE_INCREMENTS[ControlPanel.SCALE_INCREMENTS.length - 1]) {
                        return;
                    }
                    KappaFrame.this.getControlPanel();
                    KappaFrame.this.getControlPanel();
                    for (i = ControlPanel.SCALE_INCREMENTS.length - 2; i > 0 && ControlPanel.SCALE_INCREMENTS[i] > scale; --i) {
                    }
                    KappaFrame.this.getControlPanel();
                    KappaFrame.this.getControlPanel().getScaleSlider().setValue((int)Math.ceil(100.0 * ControlPanel.SCALE_INCREMENTS[++i]));
                }
            }
        }

        private class MouseMotionHandler
        implements MouseMotionListener {
            private MouseMotionHandler() {
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                ScrollDrawingPane.this.requestFocusInWindow();
                if (KappaFrame.this.getToolPanel().isSelected(0) && KappaFrame.this.getCurves().getNoSelected() != 0) {
                    for (Curve c : KappaFrame.this.getCurves().getSelected()) {
                        int index = c.controlPointIndex(KappaFrame.this.mapPoint(event.getPoint()), KappaFrame.this.getControlPanel().getCurrentLayerSlider().getValue(), (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0, false);
                        if (index == -1) continue;
                        c.setHoveredControlPoint(index);
                        KappaFrame.this.drawImageOverlay();
                        return;
                    }
                    boolean noneHovered = true;
                    for (Curve c : KappaFrame.this.getCurves().getSelected()) {
                        if (c.getHoveredControlPoint() == -1) continue;
                        noneHovered = false;
                    }
                    if (noneHovered) {
                        return;
                    }
                    for (Curve c : KappaFrame.this.getCurves().getSelected()) {
                        c.setHoveredControlPoint(-1);
                    }
                    KappaFrame.this.getInfoPanel().repaint();
                    KappaFrame.this.drawImageOverlay();
                }
            }

            @Override
            public void mouseDragged(MouseEvent event) {
                if (KappaFrame.this.getToolPanel().isSelected(0) && KappaFrame.this.isControlPointSelected()) {
                    Point newPt = KappaFrame.this.mapPoint(event.getPoint());
                    double scale = (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0;
                    KappaFrame.this.getCurrEditedCurve().addKeyFrame(new Point2D.Double(((Point2D)newPt).getX() / scale, ((Point2D)newPt).getY() / scale), KappaFrame.this.getControlPanel().getCurrentLayerSlider().getValue());
                    KappaFrame.this.getInfoPanel().updateHistograms();
                    KappaFrame.this.getInfoPanel().repaint();
                    KappaFrame.this.drawImageOverlay();
                }
                if (KappaFrame.this.getToolPanel().isSelected(1)) {
                    Point currentPoint = event.getPoint();
                    JViewport currentPort = KappaFrame.this.getScrollPane().getViewport();
                    int dx = currentPoint.x - ScrollDrawingPane.this.startPoint.x;
                    int dy = currentPoint.y - ScrollDrawingPane.this.startPoint.y;
                    int nx = ScrollDrawingPane.this.startOrigin.x - dx;
                    int ny = ScrollDrawingPane.this.startOrigin.y - dy;
                    int mx = 4;
                    int my = 4;
                    if (KappaFrame.this.getScrollPane().getHorizontalScrollBar().isVisible()) {
                        mx = 19;
                    }
                    if (KappaFrame.this.getScrollPane().getVerticalScrollBar().isVisible()) {
                        my = 19;
                    }
                    if (nx > currentPort.getViewSize().width - ScrollDrawingPane.this.getWidth() + mx) {
                        nx = currentPort.getViewSize().width - ScrollDrawingPane.this.getWidth() + mx;
                    }
                    if (nx < 0) {
                        nx = 0;
                    }
                    if (ny > currentPort.getViewSize().height - ScrollDrawingPane.this.getHeight() + my) {
                        ny = currentPort.getViewSize().height - ScrollDrawingPane.this.getHeight() + my;
                    }
                    if (ny < 0) {
                        ny = 0;
                    }
                    KappaFrame.this.getScrollPane().getViewport().setViewPosition(new Point(nx, ny));
                }
            }
        }

        private class MouseHandler
        extends MouseAdapter {
            private MouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent event) {
                KappaFrame.this.getInfoPanel().getPointSlider().setEnabled(KappaFrame.this.getCurves().isCurveSelected());
                if (KappaFrame.this.getToolPanel().isSelected(0)) {
                    boolean anythingClicked = false;
                    for (Curve curve : KappaFrame.this.getCurves().getSelected()) {
                        if (curve.controlPointIndex(KappaFrame.this.mapPoint(event.getPoint()), KappaFrame.this.getControlPanel().getCurrentLayerSlider().getValue(), (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0, true) == -1) continue;
                        anythingClicked = true;
                        KappaFrame.this.setCurrEditedCurve(curve);
                        KappaFrame.this.setControlPointSelected(true);
                    }
                    if (anythingClicked) {
                        return;
                    }
                    for (int i = 0; i < KappaFrame.this.getCurves().size(); ++i) {
                        Curve c = (Curve)KappaFrame.this.getCurves().get(i);
                        if (!c.isPointOnCurve(KappaFrame.this.mapPoint(event.getPoint()), KappaFrame.this.getControlPanel().getCurrentLayerSlider().getValue(), (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0)) continue;
                        anythingClicked = true;
                        if (!KappaFrame.this.isShiftPressed()) {
                            KappaFrame.this.getCurves().setAllUnselected();
                        }
                        if (c.isSelected()) {
                            KappaFrame.this.getCurves().setUnselected(c);
                            if (!KappaFrame.this.isShiftPressed()) {
                                KappaFrame.this.getInfoPanel().getList().clearSelection();
                            } else {
                                KappaFrame.this.getInfoPanel().getList().removeSelectionInterval(i, i);
                            }
                        } else {
                            KappaFrame.this.getCurves().setSelected(c);
                            KappaFrame.this.getInfoPanel().updateHistograms();
                            if (!KappaFrame.this.isShiftPressed()) {
                                KappaFrame.this.getInfoPanel().getList().setSelectedIndex(i);
                            } else {
                                KappaFrame.this.getInfoPanel().getList().addSelectionInterval(i, i);
                            }
                        }
                        KappaFrame.this.getInfoPanel().getCurvesList().revalidate();
                    }
                    if (anythingClicked) {
                        return;
                    }
                    if (!KappaFrame.this.isShiftPressed()) {
                        KappaFrame.this.getCurves().setAllUnselected();
                        KappaFrame.this.getInfoPanel().getList().clearSelection();
                        KappaFrame.this.getInfoPanel().updateHistograms();
                    }
                }
                if (KappaFrame.this.getToolPanel().isSelected(1)) {
                    ScrollDrawingPane.this.startPoint = event.getPoint();
                    ScrollDrawingPane.this.startOrigin = KappaFrame.this.getScrollPane().getViewport().getViewPosition();
                }
                if (KappaFrame.this.getToolPanel().isSelected(2)) {
                    if (KappaFrame.this.getCurrCtrlPt() == 0) {
                        KappaFrame.this.getCurves().setAllUnselected();
                        KappaFrame.this.getInfoPanel().getList().clearSelection();
                        KappaFrame.this.getInfoPanel().updateHistograms();
                        KappaFrame.this.setPoints(new ArrayList<Point2D>(4));
                        KappaFrame.this.getKappaMenubar().getDelete().setEnabled(true);
                    }
                    Point mappedPoint = KappaFrame.this.mapPoint(event.getPoint());
                    double scale = (double)KappaFrame.this.getControlPanel().getScaleSlider().getValue() / 100.0;
                    KappaFrame.this.getPoints().add(new Point2D.Double(((Point2D)mappedPoint).getX() / scale, ((Point2D)mappedPoint).getY() / scale));
                    KappaFrame.this.setCurrCtrlPt(KappaFrame.this.getCurrCtrlPt() + 1);
                    if (KappaFrame.this.getCurrCtrlPt() == 4 && KappaFrame.this.getInputType() == 1) {
                        KappaFrame.this.getKappaMenubar().getEnter().setEnabled(true);
                    } else if (KappaFrame.this.getCurrCtrlPt() >= 3 && KappaFrame.this.getInputType() == 0) {
                        KappaFrame.this.getKappaMenubar().getEnter().setEnabled(true);
                    }
                    KappaFrame.this.getInfoPanel().repaint();
                    KappaFrame.this.drawImageOverlay();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (KappaFrame.this.getToolPanel().isSelected(2) && KappaFrame.this.getCurrCtrlPt() == 0) {
                    KappaFrame.this.getControlPanel().repaint();
                }
                if (KappaFrame.this.getToolPanel().isSelected(0)) {
                    if (KappaFrame.this.isControlPointSelected()) {
                        KappaFrame.this.getCurrEditedCurve().resetControlPointSelection();
                    }
                    KappaFrame.this.setControlPointSelected(false);
                    KappaFrame.this.drawImageOverlay();
                    KappaFrame.this.getControlPanel().repaint();
                }
            }
        }
    }
}

