/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import sc.fiji.kappa.gui.KappaFrame;

public class Overlay
extends JComponent {
    public static final double NOTIFICATION_DRAW_LOCATION = 0.9;
    public static final int DEFAULT_OVERLAY_DURATION = 2000;
    private static final long serialVersionUID = 1L;
    private KappaFrame frame;

    public Overlay(KappaFrame frame) {
        this.frame = frame;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void drawNotification(String text, Rectangle viewrect) {
        this.drawNotification(text, viewrect, 2000);
    }

    public void drawNotification(String text, Rectangle viewrect, int overlayDurationMillis) {
        Graphics g = this.getGraphics();
        if (g != null) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setFont(new Font("Sans Serif", 0, 18));
            Rectangle2D textBounds = g.getFontMetrics(new Font("Sans Serif", 0, 18)).getStringBounds(text, g);
            int textLength = (int)textBounds.getWidth();
            int textHeight = (int)textBounds.getHeight();
            int drawX = (int)(viewrect.getWidth() / 2.0);
            int drawY = (int)(50.0 + viewrect.getHeight() * 0.9);
            g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.5f));
            g.fillRoundRect(drawX - textLength / 2 - 20, drawY - textHeight / 2 - 12, textLength + 40, textHeight + 24, 20, 20);
            g.setColor(Color.LIGHT_GRAY);
            g.drawRoundRect(drawX - textLength / 2 - 20, drawY - textHeight / 2 - 12, textLength + 40, textHeight + 24, 20, 20);
            g.setColor(Color.WHITE);
            g.drawString(text, drawX - textLength / 2, drawY - textHeight / 2 + 16);
            this.repaint();
            if (overlayDurationMillis >= 0) {
                Thread delayHide = new Thread(new DelayThread(overlayDurationMillis));
                delayHide.run();
            }
        }
    }

    private class DelayThread
    implements Runnable {
        private int timeMillis;

        public DelayThread(int timeMillis) {
            this.timeMillis = timeMillis;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.timeMillis);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Overlay.this.frame.getOverlay().setVisible(false);
        }
    }
}

