/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.blocks.FallbackProperties;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.blocks.PrimitiveTypeProperties;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Cast;
import net.imglib2.view.Views;

class FallbackPrimitiveBlocks<T extends NativeType<T>, A extends ArrayDataAccess<A>>
implements PrimitiveBlocks<T> {
    private final RandomAccessible<T> source;
    private final T type;
    private final PrimitiveTypeProperties<?, A> primitiveTypeProperties;
    private final NativeTypeFactory<T, A> nativeTypeFactory;

    public FallbackPrimitiveBlocks(FallbackProperties<T> props) {
        this(props.getView(), props.getViewType());
    }

    public FallbackPrimitiveBlocks(RandomAccessible<T> source, T type) {
        this.source = source;
        this.type = type;
        if (type.getEntitiesPerPixel().getRatio() != 1.0) {
            throw new IllegalArgumentException("Types with entitiesPerPixel != 1 are not supported");
        }
        this.nativeTypeFactory = (NativeTypeFactory)Cast.unchecked(type.getNativeTypeFactory());
        this.primitiveTypeProperties = (PrimitiveTypeProperties)Cast.unchecked(PrimitiveTypeProperties.get(this.nativeTypeFactory.getPrimitiveType()));
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public int numDimensions() {
        return this.source.numDimensions();
    }

    @Override
    public void copy(Interval interval, Object dest) {
        ArrayImg<T, DataAccess> img = new ArrayImg<T, DataAccess>((DataAccess)this.primitiveTypeProperties.wrap(dest), interval.dimensionsAsLongArray(), this.type.getEntitiesPerPixel());
        img.setLinkedType(this.nativeTypeFactory.createLinkedType(img));
        LoopBuilder.setImages(Views.interval(this.source, interval), img).forEachPixel((a, b) -> b.set(a));
    }

    @Override
    public PrimitiveBlocks<T> independentCopy() {
        return this;
    }

    @Override
    public PrimitiveBlocks<T> threadSafe() {
        return this;
    }
}

