/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import java.util.function.Consumer;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

class ArraySpliterator<T extends NativeType<T>>
implements LocalizableSpliterator<T> {
    private final ArrayImg<T, ?> img;
    private final T type;
    private final Index index;
    private final int fence;

    ArraySpliterator(ArrayImg<T, ?> img, int origin, int fence) {
        this.img = img;
        this.type = img.createLinkedType();
        this.index = this.type.index();
        this.fence = fence;
        this.type.updateContainer(this);
        this.index.set(origin - 1);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index.get() < this.fence - 1) {
            this.index.inc();
            action.accept(this.type);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        int len = this.fence - this.index.get() - 1;
        for (int i = 0; i < len; ++i) {
            this.index.inc();
            action.accept(this.type);
        }
    }

    @Override
    public ArraySpliterator<T> trySplit() {
        int mid;
        int lo = this.index.get() + 1;
        if (lo >= (mid = lo + this.fence >>> 1)) {
            return null;
        }
        ArraySpliterator<T> prefix = new ArraySpliterator<T>(this.img, lo, mid);
        this.index.set(mid - 1);
        return prefix;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index.get() - 1;
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    @Override
    public ArraySpliterator<T> copy() {
        return new ArraySpliterator<T>(this.img, this.index.get() + 1, this.fence);
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public int numDimensions() {
        return this.img.numDimensions();
    }

    @Override
    public void localize(int[] position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, position);
    }

    @Override
    public void localize(float[] position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, position);
    }

    @Override
    public void localize(double[] position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, position);
    }

    @Override
    public void localize(long[] position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, position);
    }

    @Override
    public void localize(Positionable position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, position);
    }

    @Override
    public void localize(RealPositionable position) {
        IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, (Positionable)position);
    }

    @Override
    public int getIntPosition(int d) {
        if (d == 0) {
            return this.index.get() % this.img.dim[0];
        }
        return IntervalIndexer.indexToPosition(this.index.get(), this.img.dim, this.img.steps, d);
    }

    @Override
    public long getLongPosition(int d) {
        return this.getIntPosition(d);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getIntPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getIntPosition(d);
    }
}

