/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.imglib2.Interval;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;

public class ViewTransforms {
    public static Mixed rotate(int numDimensions, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return new MixedTransform(numDimensions, numDimensions);
        }
        MixedTransform t = new MixedTransform(numDimensions, numDimensions);
        if (fromAxis != toAxis) {
            int[] component = new int[numDimensions];
            boolean[] inv = new boolean[numDimensions];
            for (int e = 0; e < numDimensions; ++e) {
                if (e == toAxis) {
                    component[e] = fromAxis;
                    inv[e] = true;
                    continue;
                }
                component[e] = e == fromAxis ? toAxis : e;
            }
            t.setComponentMapping(component);
            t.setComponentInversion(inv);
        }
        return t;
    }

    public static Mixed permute(int numDimensions, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return new MixedTransform(numDimensions, numDimensions);
        }
        int[] component = new int[numDimensions];
        for (int e = 0; e < numDimensions; ++e) {
            component[e] = e;
        }
        component[fromAxis] = toAxis;
        component[toAxis] = fromAxis;
        MixedTransform t = new MixedTransform(numDimensions, numDimensions);
        t.setComponentMapping(component);
        return t;
    }

    public static MixedTransform hyperSlice(int numDimensions, int d, long pos) {
        int n = numDimensions - 1;
        MixedTransform t = new MixedTransform(n, numDimensions);
        long[] translation = new long[numDimensions];
        translation[d] = pos;
        boolean[] zero = new boolean[numDimensions];
        int[] component = new int[numDimensions];
        for (int e = 0; e < numDimensions; ++e) {
            if (e < d) {
                zero[e] = false;
                component[e] = e;
                continue;
            }
            if (e > d) {
                zero[e] = false;
                component[e] = e - 1;
                continue;
            }
            zero[e] = true;
            component[e] = 0;
        }
        t.setTranslation(translation);
        t.setComponentZero(zero);
        t.setComponentMapping(component);
        return t;
    }

    public static MixedTransform translate(long ... translation) {
        int n = translation.length;
        MixedTransform t = new MixedTransform(n, n);
        t.setInverseTranslation(translation);
        return t;
    }

    public static MixedTransform translateInverse(long ... translation) {
        int n = translation.length;
        MixedTransform t = new MixedTransform(n, n);
        t.setTranslation(translation);
        return t;
    }

    public static MixedTransform moveAxis(int numDimensions, int fromAxis, int toAxis) {
        if (fromAxis == toAxis) {
            return new MixedTransform(numDimensions, numDimensions);
        }
        ArrayList<Integer> axisIndices = new ArrayList<Integer>();
        IntStream.rangeClosed(0, numDimensions - 1).forEach(axisIndices::add);
        axisIndices.remove(fromAxis);
        axisIndices.add(toAxis, fromAxis);
        int[] components = new int[numDimensions];
        for (int i = 0; i < numDimensions; ++i) {
            components[((Integer)axisIndices.get((int)i)).intValue()] = i;
        }
        MixedTransform t = new MixedTransform(numDimensions, numDimensions);
        t.setComponentMapping(components);
        return t;
    }

    public static MixedTransform zeroMin(Interval interval) {
        int n = interval.numDimensions();
        long[] offset = new long[n];
        interval.min(offset);
        long[] translation = Arrays.stream(offset).map(o -> -o).toArray();
        return ViewTransforms.translate(translation);
    }

    public static MixedTransform addDimension(int numDimensions) {
        int newNumDims = numDimensions + 1;
        return new MixedTransform(newNumDims, numDimensions);
    }

    public static MixedTransform invertAxis(int numDimensions, int d) {
        boolean[] inv = new boolean[numDimensions];
        inv[d] = true;
        MixedTransform t = new MixedTransform(numDimensions, numDimensions);
        t.setComponentInversion(inv);
        return t;
    }
}

