/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.composite.AbstractNumericComposite;
import net.imglib2.view.composite.CompositeFactory;

public class NumericComposite<T extends NumericType<T>>
extends AbstractNumericComposite<T, NumericComposite<T>> {
    public NumericComposite(RandomAccess<T> sourceAccess, int length) {
        super(sourceAccess, length);
    }

    @Override
    public NumericComposite<T> createVariable() {
        NumericType t = (NumericType)this.sourceAccess.get();
        Img img = NativeType.class.isInstance(t) ? new ArrayImgFactory<NativeType>((NativeType)((Object)t)).create(new long[]{this.length}) : new ListImgFactory<NumericType>(t).create(new long[]{this.length});
        return new NumericComposite(img.randomAccess(), this.length);
    }

    @Override
    public NumericComposite<T> copy() {
        return new NumericComposite<T>(this.sourceAccess.copy(), this.length);
    }

    public static class Factory<T extends NumericType<T>>
    implements CompositeFactory<T, NumericComposite<T>> {
        protected final int numChannels;

        public Factory(int numChannels) {
            this.numChannels = numChannels;
        }

        @Override
        public NumericComposite<T> create(RandomAccess<T> sourceAccess) {
            return new NumericComposite<T>(sourceAccess, this.numChannels);
        }
    }
}

