/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;
import ome.xml.model.primitives.Timestamp;

public class HitachiReader
extends FormatReader {
    private static final String MAGIC = "[SemImageFile]";
    private static final String DATE_FORMAT = "MM/dd/yyyy HH:mm:ss";
    private ImageReader helperReader;

    public HitachiReader() {
        super("Hitachi", "txt");
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .txt file plus one similarly-named .tif, .bmp, or .jpg file";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        String base = name;
        if (base.indexOf(46) >= 0) {
            base = base.substring(0, base.lastIndexOf("."));
        }
        if (HitachiReader.checkSuffix((String)name, (String)"txt")) {
            Location bmp = new Location(base + ".bmp");
            Location jpg = new Location(base + ".jpg");
            Location tif = new Location(base + ".tif");
            if (!(bmp.exists() || jpg.exists() || tif.exists())) {
                return false;
            }
            return super.isThisType(name, open);
        }
        String textFile = base + ".txt";
        return new Location(textFile).exists() && this.isThisType(textFile, open);
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = MAGIC.length();
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        if (stream.readString(blockLen).indexOf(MAGIC) >= 0) {
            return true;
        }
        stream.seek(stream.getFilePointer() - (long)blockLen);
        stream.setEncoding("UTF-16");
        String check = stream.readString((blockLen + 1) * 2);
        return check.indexOf(MAGIC) >= 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        this.helperReader.openBytes(no, buf, x, y, w, h);
        return buf;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.helperReader.getCurrentFile()};
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.helperReader != null) {
                this.helperReader.close();
            }
            this.helperReader = null;
        }
    }

    public void reopenFile() throws IOException {
        super.reopenFile();
        this.helperReader.reopenFile();
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!HitachiReader.checkSuffix((String)id, (String)"txt")) {
            String base = id;
            if (base.indexOf(46) >= 0) {
                base = base.substring(0, base.lastIndexOf("."));
            }
            id = base + ".txt";
            this.initFile(id);
            return;
        }
        super.initFile(id);
        String data = null;
        try (RandomAccessInputStream in = new RandomAccessInputStream(id);){
            long idLen = in.length();
            if (idLen > Integer.MAX_VALUE) {
                throw new IOException("File too large");
            }
            int len = (int)idLen;
            byte[] b = new byte[len];
            in.readFully(b);
            data = new String(b, "UTF-8");
            if (data.indexOf(MAGIC) < 0) {
                data = new String(b, "UTF-16");
            }
        }
        IniParser parser = new IniParser();
        parser.setBackslashContinuesLine(false);
        IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
        IniTable image = ini.getTable("SemImageFile");
        if (image == null) {
            throw new FormatException("Could not find 'SemImageFile' table.");
        }
        for (String key : image.keySet()) {
            if ("header".equals(key)) continue;
            this.addGlobalMeta(key, image.get(key));
        }
        String imageName = (String)image.get("SampleName");
        String pixelsFile = (String)image.get("ImageName");
        String date = (String)image.get("Date");
        String time = (String)image.get("Time");
        Location baseFile = new Location(id).getAbsoluteFile();
        Location parent = baseFile.getParentFile();
        Location pixels = new Location(parent, pixelsFile);
        if (pixels.exists()) {
            pixelsFile = pixels.getAbsolutePath();
        } else {
            LOGGER.warn("Stored file name {} not found, attempting to find pixels file", (Object)pixelsFile);
            String base = baseFile.getAbsolutePath();
            if (base.indexOf(46) >= 0) {
                base = base.substring(0, base.lastIndexOf("."));
            }
            Location bmp = new Location(base + ".bmp");
            Location jpg = new Location(base + ".jpg");
            Location tif = new Location(base + ".tif");
            if (tif.exists()) {
                pixelsFile = tif.getAbsolutePath();
            } else if (jpg.exists()) {
                pixelsFile = jpg.getAbsolutePath();
            } else if (bmp.exists()) {
                pixelsFile = bmp.getAbsolutePath();
            } else {
                throw new FormatException("Could not find pixels file");
            }
        }
        ClassList classes = ImageReader.getDefaultReaderClasses();
        Class[] classArray = classes.getClasses();
        ClassList newClasses = new ClassList(IFormatReader.class);
        for (Class c : classArray) {
            if (c.equals(HitachiReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helperReader = new ImageReader(newClasses);
        this.helperReader.setId(pixelsFile);
        this.core = new ArrayList(this.helperReader.getCoreMetadataList());
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM ? 1 : 0) != 0);
        store.setImageName(imageName, 0);
        date = DateTools.formatDate(date + " " + time, DATE_FORMAT);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        this.populateOMEMetadata(image, store);
    }

    private void populateOMEMetadata(IniTable image, MetadataStore store) {
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) {
            return;
        }
        String modelNumber = (String)image.get("InstructName");
        String serialNumber = (String)image.get("SerialNumber");
        Double pixelSize = DataTools.parseDouble((String)image.get("PixelSize"));
        String workingDistance = (String)image.get("WorkingDistance");
        Double stagePosXn = Double.valueOf((String)image.get("StagePositionX"));
        Double stagePosYn = Double.valueOf((String)image.get("StagePositionY"));
        Double stagePosZn = Double.valueOf((String)image.get("StagePositionZ"));
        Length stagePosXl = new Length((Number)stagePosXn, UNITS.REFERENCEFRAME);
        Length stagePosYl = new Length((Number)stagePosYn, UNITS.REFERENCEFRAME);
        Length stagePosZl = new Length((Number)stagePosZn, UNITS.REFERENCEFRAME);
        Length sizeX = FormatTools.getPhysicalSizeX((Double)pixelSize, (Unit)UNITS.NANOMETER);
        Length sizeY = FormatTools.getPhysicalSizeY((Double)pixelSize, (Unit)UNITS.NANOMETER);
        if (sizeX != null) {
            store.setPixelsPhysicalSizeX(sizeX, 0);
        }
        if (sizeY != null) {
            store.setPixelsPhysicalSizeY(sizeY, 0);
        }
        store.setPlanePositionX(stagePosXl, 0, 0);
        store.setPlanePositionY(stagePosYl, 0, 0);
        store.setPlanePositionZ(stagePosZl, 0, 0);
        String instrument = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrument, 0);
        store.setImageInstrumentRef(instrument, 0);
        if (modelNumber != null) {
            store.setMicroscopeModel(modelNumber, 0);
        }
        if (serialNumber != null) {
            store.setMicroscopeSerialNumber(serialNumber, 0);
        }
        if (workingDistance != null) {
            int end = workingDistance.indexOf(32);
            if (end < 0) {
                end = workingDistance.length();
            }
            workingDistance = workingDistance.substring(0, end);
            String objective = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveSettingsID(objective, 0);
            store.setObjectiveWorkingDistance(new Length((Number)DataTools.parseDouble(workingDistance), UNITS.MICROMETER), 0, 0);
        }
    }
}

