/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.fft;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

public class Bandpass<T extends NumericType<T>>
implements OutputAlgorithm<T>,
Benchmark {
    String errorMessage = "";
    boolean inPlace;
    boolean bandPass;
    Image<T> img;
    Image<T> output;
    int beginRadius;
    int endRadius;
    long processingTime;
    int[] origin;

    public Bandpass(Image<T> img, int beginRadius, int endRadius) {
        this.img = img;
        this.inPlace = false;
        this.bandPass = true;
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
        this.origin = img.createPositionArray();
        this.origin[0] = img.getDimension(0) - 1;
        for (int d = 1; d < this.origin.length; ++d) {
            this.origin[d] = img.getDimension(d) / 2;
        }
    }

    public void setImage(Image<T> img) {
        this.img = img;
    }

    public void setInPlace(boolean inPlace) {
        this.inPlace = inPlace;
    }

    public void setBandPass(boolean bandPass) {
        this.bandPass = bandPass;
    }

    public void setOrigin(int[] position) {
        this.origin = (int[])position.clone();
    }

    public void setBandPassRadius(int beginRadius, int endRadius) {
        this.beginRadius = beginRadius;
        this.endRadius = endRadius;
    }

    public Image<T> getImage() {
        return this.img;
    }

    public boolean getInPlace() {
        return this.inPlace;
    }

    public int getBeginBandPassRadius() {
        return this.beginRadius;
    }

    public int getEndBandPassRadius() {
        return this.endRadius;
    }

    public int[] getOrigin() {
        return this.origin;
    }

    @Override
    public boolean process() {
        Image<T> img;
        long startTime = System.currentTimeMillis();
        if (this.inPlace) {
            img = this.img;
        } else {
            this.output = this.img.clone();
            img = this.output;
        }
        LocalizableCursor<T> cursor = img.createLocalizableCursor();
        int[] pos = img.createPositionArray();
        boolean actAsBandPass = this.bandPass;
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(pos);
            float dist = Util.computeDistance(this.origin, pos);
            if (actAsBandPass) {
                if (!(dist < (float)this.beginRadius) && !(dist > (float)this.endRadius)) continue;
                ((NumericType)cursor.getType()).setZero();
                continue;
            }
            if (!(dist >= (float)this.beginRadius) || !(dist <= (float)this.endRadius)) continue;
            ((NumericType)cursor.getType()).setZero();
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public Image<T> getResult() {
        if (this.inPlace) {
            return this.img;
        }
        return this.output;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

