/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.planar;

import java.util.ArrayList;
import mpicbg.imglib.container.Container;
import mpicbg.imglib.container.DirectAccessContainerImpl;
import mpicbg.imglib.container.basictypecontainer.PlanarAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;
import mpicbg.imglib.container.planar.PlanarContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.planar.PlanarCursor;
import mpicbg.imglib.cursor.planar.PlanarCursor2D;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableByDimOutOfBoundsCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizableCursor;
import mpicbg.imglib.cursor.planar.PlanarLocalizablePlaneCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class PlanarContainer<T extends Type<T>, A extends ArrayDataAccess<A>>
extends DirectAccessContainerImpl<T, A>
implements PlanarAccess<A> {
    protected final PlanarContainerFactory factory;
    protected final int slices;
    protected final ArrayList<A> mirror;

    public PlanarContainer(int[] dim, int entitiesPerPixel) {
        this(new PlanarContainerFactory(), dim, entitiesPerPixel);
    }

    protected PlanarContainer(PlanarContainerFactory factory, int[] dim, int entitiesPerPixel) {
        this(factory, null, dim, entitiesPerPixel);
    }

    PlanarContainer(PlanarContainerFactory factory, A creator, int[] dim, int entitiesPerPixel) {
        super(factory, dim, entitiesPerPixel);
        int s = 1;
        for (int d = 2; d < this.numDimensions; ++d) {
            s *= dim[d];
        }
        this.slices = s;
        this.factory = factory;
        this.mirror = new ArrayList(this.slices);
        for (int i = 0; i < this.slices; ++i) {
            this.mirror.add(creator == null ? null : (ArrayDataAccess)creator.createArray(this.getDimension(0) * this.getDimension(1) * entitiesPerPixel));
        }
    }

    @Override
    public A update(Cursor<?> c) {
        return (A)((ArrayDataAccess)this.mirror.get(c.getStorageIndex()));
    }

    public int getSlices() {
        return this.slices;
    }

    public final int getIndex(int[] l) {
        if (this.numDimensions > 1) {
            return l[1] * this.dim[0] + l[0];
        }
        return l[0];
    }

    @Override
    public PlanarCursor<T> createCursor(Image<T> image) {
        if (this.numDimensions == 2) {
            return new PlanarCursor2D<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
        }
        return new PlanarCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableCursor<T> createLocalizableCursor(Image<T> image) {
        return new PlanarLocalizableCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizablePlaneCursor<T> createLocalizablePlaneCursor(Image<T> image) {
        return new PlanarLocalizablePlaneCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableByDimCursor<T> createLocalizableByDimCursor(Image<T> image) {
        return new PlanarLocalizableByDimCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer());
    }

    @Override
    public PlanarLocalizableByDimOutOfBoundsCursor<T> createLocalizableByDimCursor(Image<T> image, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        return new PlanarLocalizableByDimOutOfBoundsCursor<T>(this, image, this.linkedType.duplicateTypeOnSameDirectAccessContainer(), outOfBoundsFactory);
    }

    @Override
    public PlanarContainerFactory getFactory() {
        return this.factory;
    }

    @Override
    public void close() {
        for (ArrayDataAccess array : this.mirror) {
            array.close();
        }
    }

    @Override
    public boolean compareStorageContainerCompatibility(Container<?> container) {
        return this.compareStorageContainerDimensions(container) && this.getFactory().getClass().isInstance(container.getFactory());
    }

    @Override
    public A getPlane(int no) {
        return (A)((ArrayDataAccess)this.mirror.get(no));
    }

    @Override
    public void setPlane(int no, A plane) {
        this.mirror.set(no, plane);
    }
}

