/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.constant;

import mpicbg.imglib.container.constant.ConstantContainer;
import mpicbg.imglib.cursor.CursorImpl;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ConstantLocalizableByDimCursor<T extends Type<T>>
extends CursorImpl<T>
implements LocalizableByDimCursor<T> {
    final T type;
    protected final int numDimensions;
    protected final int[] position;
    protected final int[] dimensions;

    public ConstantLocalizableByDimCursor(ConstantContainer<T> container, Image<T> image, T type) {
        super(container, image);
        this.type = type;
        this.numDimensions = container.getNumDimensions();
        this.position = new int[this.numDimensions];
        this.dimensions = container.getDimensions();
        this.position[0] = -1;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public void fwd(int dim) {
        int n = dim;
        this.position[n] = this.position[n] + 1;
    }

    @Override
    public void move(int steps, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + steps;
    }

    @Override
    public void bck(int dim) {
        int n = dim;
        this.position[n] = this.position[n] - 1;
    }

    @Override
    public void moveRel(int[] vector) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.move(vector[d], d);
        }
    }

    @Override
    public void moveTo(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            int dist = position[d] - this.getPosition(d);
            if (dist == 0) continue;
            this.move(dist, d);
        }
    }

    @Override
    public void moveTo(Localizable localizable) {
        localizable.getPosition(this.position);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.getPosition(this.position);
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
    }

    @Override
    public void close() {
    }

    @Override
    public int getStorageIndex() {
        return 0;
    }

    @Override
    public void reset() {
        this.position[0] = -1;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
        }
    }

    @Override
    public boolean hasNext() {
        for (int d = this.numDimensions - 1; d >= 0; --d) {
            int sizeD = this.dimensions[d] - 1;
            if (this.position[d] < sizeD) {
                return true;
            }
            if (this.position[d] <= sizeD) continue;
            return false;
        }
        return false;
    }

    @Override
    public void fwd() {
        for (int d = 0; d < this.numDimensions; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] < this.dimensions[d]) break;
            this.position[d] = 0;
        }
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    @Override
    public String getPositionAsString() {
        String pos = "(" + this.position[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            pos = pos + ", " + this.position[d];
        }
        pos = pos + ")";
        return pos;
    }

    @Override
    public LocalNeighborhoodCursor<T> createLocalNeighborhoodCursor() {
        return LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor(this);
    }

    @Override
    public RegionOfInterestCursor<T> createRegionOfInterestCursor(int[] offset, int[] size) {
        return new RegionOfInterestCursor(this, offset, size);
    }
}

