/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.IntAccess;
import mpicbg.imglib.type.numeric.integer.GenericIntType;
import mpicbg.imglib.util.Util;

public class UnsignedIntType
extends GenericIntType<UnsignedIntType> {
    public UnsignedIntType(DirectAccessContainer<UnsignedIntType, ? extends IntAccess> intStorage) {
        super(intStorage);
    }

    public UnsignedIntType(long value) {
        super(UnsignedIntType.getCodedSignedIntChecked(value));
    }

    public UnsignedIntType() {
        this(0L);
    }

    public static int getCodedSignedIntChecked(long unsignedInt) {
        if (unsignedInt < 0L) {
            unsignedInt = 0L;
        } else if (unsignedInt > 0xFFFFFFFFL) {
            unsignedInt = 0xFFFFFFFFL;
        }
        return UnsignedIntType.getCodedSignedInt(unsignedInt);
    }

    public static int getCodedSignedInt(long unsignedInt) {
        return (int)(unsignedInt & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getUnsignedInt(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    @Override
    public DirectAccessContainer<UnsignedIntType, ? extends IntAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<UnsignedIntType, IntAccess> container = storageFactory.createIntInstance(dim, 1);
        UnsignedIntType linkedType = new UnsignedIntType((DirectAccessContainer<UnsignedIntType, ? extends IntAccess>)container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedIntType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedIntType(this.storage);
    }

    @Override
    public void mul(float c) {
        long a = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        long a = UnsignedIntType.getUnsignedInt(this.getValue());
        this.setValue(UnsignedIntType.getCodedSignedInt((int)Util.round((double)a * c)));
    }

    public long get() {
        return UnsignedIntType.getUnsignedInt(this.getValue());
    }

    @Override
    public void set(long f) {
        this.setValue(UnsignedIntType.getCodedSignedInt(f));
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public double getMaxValue() {
        return 4.294967295E9;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedIntType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public int compareTo(UnsignedIntType c) {
        long b;
        long a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public UnsignedIntType[] createArray1D(int size1) {
        return new UnsignedIntType[size1];
    }

    public UnsignedIntType[][] createArray2D(int size1, int size2) {
        return new UnsignedIntType[size1][size2];
    }

    public UnsignedIntType[][][] createArray3D(int size1, int size2, int size3) {
        return new UnsignedIntType[size1][size2][size3];
    }

    @Override
    public UnsignedIntType createVariable() {
        return new UnsignedIntType(0L);
    }

    @Override
    public UnsignedIntType copy() {
        return new UnsignedIntType(this.get());
    }
}

