/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.ChoiceWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class, priority=1.0)
public class SwingChoiceRadioWidget
extends SwingInputWidget<String>
implements ActionListener,
ChoiceWidget<JPanel> {
    private List<JRadioButton> radioButtons;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    public String getValue() {
        JRadioButton selectedButton = this.getSelectedButton();
        return selectedButton == null ? null : selectedButton.getText();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        String[] items = model.getChoices();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, this.getBoxAxis(model)));
        this.radioButtons = new ArrayList<JRadioButton>(items.length);
        for (String item : items) {
            JRadioButton radioButton = new JRadioButton(item);
            this.setToolTip(radioButton);
            radioButton.addActionListener(this);
            buttonGroup.add(radioButton);
            buttonPanel.add(radioButton);
            this.radioButtons.add(radioButton);
        }
        this.getComponent().add(buttonPanel);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isText() && model.isMultipleChoice() && this.isRadioButtonStyle(model);
    }

    private boolean isRadioButtonStyle(WidgetModel model) {
        return model.isStyle("radioButtonHorizontal") || model.isStyle("radioButtonVertical");
    }

    private int getBoxAxis(WidgetModel model) {
        if (model.isStyle("radioButtonHorizontal")) {
            return 0;
        }
        if (model.isStyle("radioButtonVertical")) {
            return 1;
        }
        throw new IllegalStateException("Invalid widget style: " + model.getItem().getWidgetStyle());
    }

    private JRadioButton getSelectedButton() {
        for (JRadioButton radioButton : this.radioButtons) {
            if (!radioButton.isSelected()) continue;
            return radioButton;
        }
        return null;
    }

    private JRadioButton getButton(Object value) {
        for (JRadioButton radioButton : this.radioButtons) {
            if (!radioButton.getText().equals(value)) continue;
            return radioButton;
        }
        return null;
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        JRadioButton radioButton = this.getButton(value);
        if (radioButton.isSelected()) {
            return;
        }
        radioButton.setSelected(true);
    }
}

