/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.boundingbox;

import net.imglib2.RealInterval;
import net.imglib2.RealPoint;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.type.Type;
import net.imglib2.util.Intervals;

public class BoxRealRandomAccessible<T extends Type<T>>
implements RealRandomAccessible<T> {
    private final int n;
    private final RealInterval interval;
    private final T insideValue;
    private final T outsideValue;

    public BoxRealRandomAccessible(RealInterval interval, T insideValue, T outsideValue) {
        this.n = interval.numDimensions();
        this.interval = interval;
        this.insideValue = insideValue.copy();
        this.outsideValue = outsideValue.copy();
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public RealRandomAccess<T> realRandomAccess() {
        return new Access();
    }

    @Override
    public RealRandomAccess<T> realRandomAccess(RealInterval interval) {
        return new Access();
    }

    @Override
    public T getType() {
        return this.insideValue;
    }

    public RealInterval getInterval() {
        return this.interval;
    }

    public class Access
    extends RealPoint
    implements RealRandomAccess<T> {
        public Access() {
            super(BoxRealRandomAccessible.this.n);
        }

        protected Access(Access a) {
            super(a);
        }

        @Override
        public T get() {
            return Intervals.contains(BoxRealRandomAccessible.this.interval, this) ? BoxRealRandomAccessible.this.insideValue : BoxRealRandomAccessible.this.outsideValue;
        }

        @Override
        public Access copy() {
            return new Access(this);
        }

        public Access copyRealRandomAccess() {
            return this.copy();
        }
    }
}

