/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.TransformEventHandler2D;
import bdv.TransformEventHandler3D;
import bdv.TransformEventHandlerFactory;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.util.AxisOrder;
import bdv.util.Bdv;
import bdv.viewer.ViewerOptions;
import bdv.viewer.render.AccumulateProjectorARGB;
import bdv.viewer.render.AccumulateProjectorFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.ui.behaviour.io.InputTriggerConfig;

public class BdvOptions {
    public final Values values = new Values();

    public static BdvOptions options() {
        return new BdvOptions();
    }

    public BdvOptions preferredSize(int w, int h) {
        this.values.width = w;
        this.values.height = h;
        return this;
    }

    public BdvOptions screenScales(double[] s) {
        Values.access$202(this.values, s);
        return this;
    }

    public BdvOptions targetRenderNanos(long t) {
        this.values.targetRenderNanos = t;
        return this;
    }

    public BdvOptions numRenderingThreads(int n) {
        this.values.numRenderingThreads = n;
        return this;
    }

    public BdvOptions numSourceGroups(int n) {
        this.values.numSourceGroups = n;
        return this;
    }

    public BdvOptions transformEventHandlerFactory(TransformEventHandlerFactory f) {
        this.values.transformEventHandlerFactory = f;
        return this;
    }

    public BdvOptions accumulateProjectorFactory(AccumulateProjectorFactory<ARGBType> f) {
        this.values.accumulateProjectorFactory = f;
        return this;
    }

    public BdvOptions inputTriggerConfig(InputTriggerConfig c) {
        this.values.inputTriggerConfig = c;
        return this;
    }

    public BdvOptions keymapManager(KeymapManager keymapManager) {
        this.values.keymapManager = keymapManager;
        return this;
    }

    public BdvOptions appearanceManager(AppearanceManager appearanceManager) {
        this.values.appearanceManager = appearanceManager;
        return this;
    }

    public BdvOptions sourceTransform(AffineTransform3D t) {
        this.values.sourceTransform.set(t);
        return this;
    }

    public BdvOptions frameTitle(String title) {
        this.values.frameTitle = title;
        return this;
    }

    public BdvOptions sourceTransform(double ... calibration) {
        double sx = calibration.length >= 1 ? calibration[0] : 1.0;
        double sy = calibration.length >= 2 ? calibration[1] : 1.0;
        double sz = calibration.length >= 3 ? calibration[2] : 1.0;
        this.values.sourceTransform.set(sx, 0.0, 0.0, 0.0, 0.0, sy, 0.0, 0.0, 0.0, 0.0, sz, 0.0);
        return this;
    }

    public BdvOptions is2D() {
        this.values.is2D = true;
        this.transformEventHandlerFactory(TransformEventHandler2D::new);
        return this;
    }

    public BdvOptions axisOrder(AxisOrder axisOrder) {
        this.values.axisOrder = axisOrder;
        return this;
    }

    public BdvOptions addTo(Bdv bdv) {
        this.values.addTo = bdv;
        return this;
    }

    public static class Values {
        private int width = -1;
        private int height = -1;
        private double[] screenScales = new double[]{1.0, 0.75, 0.5, 0.25, 0.125};
        private long targetRenderNanos = 30000000L;
        private int numRenderingThreads = 3;
        private int numSourceGroups = 10;
        private TransformEventHandlerFactory transformEventHandlerFactory = TransformEventHandler3D::new;
        private AccumulateProjectorFactory<ARGBType> accumulateProjectorFactory = AccumulateProjectorARGB.factory;
        private InputTriggerConfig inputTriggerConfig = null;
        private KeymapManager keymapManager = null;
        private AppearanceManager appearanceManager = null;
        private final AffineTransform3D sourceTransform = new AffineTransform3D();
        private String frameTitle = "BigDataViewer";
        private boolean is2D = false;
        private AxisOrder axisOrder = AxisOrder.DEFAULT;
        private Bdv addTo = null;

        Values() {
            this.sourceTransform.identity();
        }

        public BdvOptions optionsFromValues() {
            BdvOptions o = new BdvOptions().preferredSize(this.width, this.height).screenScales(this.screenScales).targetRenderNanos(this.targetRenderNanos).numRenderingThreads(this.numRenderingThreads).numSourceGroups(this.numSourceGroups).transformEventHandlerFactory(this.transformEventHandlerFactory).accumulateProjectorFactory(this.accumulateProjectorFactory).inputTriggerConfig(this.inputTriggerConfig).keymapManager(this.keymapManager).appearanceManager(this.appearanceManager).sourceTransform(this.sourceTransform).frameTitle(this.frameTitle).axisOrder(this.axisOrder).addTo(this.addTo);
            if (this.is2D()) {
                o.is2D();
            }
            return o;
        }

        public ViewerOptions getViewerOptions() {
            ViewerOptions o = ViewerOptions.options().screenScales(this.screenScales).targetRenderNanos(this.targetRenderNanos).numRenderingThreads(this.numRenderingThreads).numSourceGroups(this.numSourceGroups).is2D(this.is2D).transformEventHandlerFactory(this.transformEventHandlerFactory).accumulateProjectorFactory(this.accumulateProjectorFactory).inputTriggerConfig(this.inputTriggerConfig).keymapManager(this.keymapManager).appearanceManager(this.appearanceManager);
            if (this.hasPreferredSize()) {
                o.width(this.width).height(this.height);
            }
            return o;
        }

        public AffineTransform3D getSourceTransform() {
            return this.sourceTransform;
        }

        public String getFrameTitle() {
            return this.frameTitle;
        }

        public boolean is2D() {
            return this.is2D;
        }

        public boolean hasPreferredSize() {
            return this.width > 0 && this.height > 0;
        }

        public AxisOrder axisOrder() {
            return this.axisOrder;
        }

        public InputTriggerConfig getInputTriggerConfig() {
            return this.inputTriggerConfig;
        }

        public KeymapManager getKeymapManager() {
            return this.keymapManager;
        }

        public AppearanceManager getAppearanceManager() {
            return this.appearanceManager;
        }

        public Bdv addTo() {
            return this.addTo;
        }

        static /* synthetic */ double[] access$202(Values x0, double[] x1) {
            x0.screenScales = x1;
            return x1;
        }
    }
}

