/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import java.util.Comparator;
import java.util.List;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.realtransform.AffineTransform3D;

public interface MipmapOrdering {
    public static final RenderOrderComparator renderOrderComparator = new RenderOrderComparator();
    public static final PrefetchOrderComparator prefetchOrderComparator = new PrefetchOrderComparator();

    public MipmapHints getMipmapHints(AffineTransform3D var1, int var2, int var3);

    public static class MipmapHints {
        private final List<Level> levels;
        private final boolean renewHintsAfterPaintingOnce;

        public MipmapHints(List<Level> levels, boolean renewHintsAfterPaintingOnce) {
            this.levels = levels;
            this.renewHintsAfterPaintingOnce = renewHintsAfterPaintingOnce;
        }

        public List<Level> getLevels() {
            return this.levels;
        }

        public boolean renewHintsAfterPaintingOnce() {
            return this.renewHintsAfterPaintingOnce;
        }
    }

    public static class PrefetchOrderComparator
    implements Comparator<Level> {
        @Override
        public int compare(Level o1, Level o2) {
            return o1.prefetchOrder - o2.prefetchOrder;
        }
    }

    public static class RenderOrderComparator
    implements Comparator<Level> {
        @Override
        public int compare(Level o1, Level o2) {
            return o1.renderOrder - o2.renderOrder;
        }
    }

    public static class Level {
        private final int mipmapLevel;
        private final int renderOrder;
        private final int prefetchOrder;
        private final CacheHints renderCacheHints;
        private final CacheHints prefetchCacheHints;

        public Level(int mipmapLevel, int renderOrder, int prefetchOrder, CacheHints renderCacheHints, CacheHints prefetchCacheHints) {
            this.mipmapLevel = mipmapLevel;
            this.renderOrder = renderOrder;
            this.prefetchOrder = prefetchOrder;
            this.renderCacheHints = renderCacheHints;
            this.prefetchCacheHints = prefetchCacheHints;
        }

        public Level(int mipmapLevel, int renderOrder, int prefetchOrder) {
            this(mipmapLevel, renderOrder, prefetchOrder, null, null);
        }

        public int getMipmapLevel() {
            return this.mipmapLevel;
        }

        public int getRenderOrder() {
            return this.renderOrder;
        }

        public int getPrefetchOrder() {
            return this.prefetchOrder;
        }

        public CacheHints getRenderCacheHints() {
            return this.renderCacheHints;
        }

        public CacheHints getPrefetchCacheHints() {
            return this.prefetchCacheHints;
        }
    }
}

