/*
 * Decompiled with CFR 0.152.
 */
import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class CropEditor_
implements PlugInFilter {
    ImagePlus image;
    ImageStack stack;
    int w;
    int h;
    int d;
    boolean verbose = false;

    private static int getPixel(byte[] b, int index) {
        return b[index] & 0xFF;
    }

    public void run(ImageProcessor ip) {
        byte[] pixels;
        int z;
        this.stack = this.image.getStack();
        this.d = this.stack == null ? 1 : this.stack.getSize();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        GenericDialog gd = new GenericDialog("Parameters");
        gd.addNumericField("xStart", 0.0, 0);
        gd.addNumericField("xEnd", (double)(this.w - 1), 0);
        gd.addNumericField("yStart", 0.0, 0);
        gd.addNumericField("yEnd", (double)(this.h - 1), 0);
        gd.addNumericField("zStart", 0.0, 0);
        gd.addNumericField("zEnd", (double)(this.d - 1), 0);
        gd.addNumericField("fillValue", 0.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int xStart = (int)gd.getNextNumber();
        int xEnd = (int)gd.getNextNumber() + 1;
        int yStart = (int)gd.getNextNumber();
        int yEnd = (int)gd.getNextNumber() + 1;
        int zStart = (int)gd.getNextNumber();
        int zEnd = (int)gd.getNextNumber() + 1;
        byte fillValue = (byte)gd.getNextNumber();
        if (xStart >= xEnd || yStart >= yEnd || zStart >= zEnd) {
            IJ.error((String)"Invalid dimensions");
            return;
        }
        int newW = xEnd - xStart;
        int newH = yEnd - yStart;
        int newD = zEnd - zStart;
        ImageStack result = new ImageStack(newW, newH);
        byte[] backGround = null;
        if (fillValue != 0) {
            backGround = new byte[newW * newH];
            for (int i = 0; i < newW * newH; ++i) {
                backGround[i] = fillValue;
            }
        }
        for (z = zStart; z < 0; ++z) {
            pixels = new byte[newW * newH];
            if (backGround != null) {
                System.arraycopy(backGround, 0, pixels, 0, newW * newH);
            }
            result.addSlice(null, (Object)pixels);
        }
        for (z = 0; z < zEnd && z < this.d; ++z) {
            byte[] oldPixels = (byte[])this.stack.getProcessor(z + 1).getPixels();
            byte[] pixels2 = new byte[newW * newH];
            if (this.w == newW && this.h == newH) {
                System.arraycopy(oldPixels, 0, pixels2, 0, newW * newH);
            } else {
                int y;
                if (backGround != null) {
                    System.arraycopy(backGround, 0, pixels2, 0, newW * newH);
                }
                int n = y = yStart < 0 ? -yStart : 0;
                while (y < newH && y + yStart < this.h) {
                    int x;
                    int n2 = x = xStart < 0 ? -xStart : 0;
                    while (x < newW && x + xStart < this.w) {
                        pixels2[x + newW * y] = oldPixels[x + xStart + this.w * (y + yStart)];
                        ++x;
                    }
                    ++y;
                }
            }
            result.addSlice(null, (Object)pixels2);
        }
        for (z = this.d; z < zEnd; ++z) {
            pixels = new byte[newW * newH];
            if (backGround != null) {
                System.arraycopy(backGround, 0, pixels, 0, newW * newH);
            }
            result.addSlice(null, (Object)pixels);
        }
        ImagePlus r = new ImagePlus(this.image.getTitle() + " cropped", result);
        if (AmiraParameters.isAmiraMesh((ImagePlus)this.image)) {
            new AmiraParameters(this.image).setParameters(r);
        }
        if (IJ.getInstance() != null) {
            r.show();
        }
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 131;
    }
}

