/*
 * Decompiled with CFR 0.152.
 */
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;

public class Psychomorph_TEM_Reader
implements PlugInFilter {
    ImagePlus image;

    public int setup(String arg, ImagePlus ip) {
        this.image = ip;
        return 159;
    }

    public void run(ImageProcessor imp) {
        OpenDialog od = new OpenDialog("TEM File", null);
        String dir = od.getDirectory();
        String arg = od.getFileName();
        if (arg == null) {
            return;
        }
        try {
            TEM tem = new TEM();
            tem.readFile(dir + File.separator + arg);
            tem.setRoi(this.image);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        int i;
        if (args.length != 3 && args.length != 4) {
            System.err.println("Usage: prog <original-tem> <incomplete-tem> <output-tem>");
            System.err.println("       prog -scale <factor> <original-tem>  <output-tem>");
            System.exit(1);
        }
        TEM tem1 = new TEM();
        TEM tem2 = new TEM();
        if (args[0].equals("-scale")) {
            float factor = Float.parseFloat(args[1]);
            try {
                tem1.readFile(args[2]);
                int i2 = 0;
                while (i2 < tem1.pointCount) {
                    int n = i2;
                    tem1.x[n] = tem1.x[n] * factor;
                    int n2 = i2++;
                    tem1.y[n2] = tem1.y[n2] * factor;
                }
                tem1.writeFile(args[3]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            System.exit(0);
        }
        try {
            tem1.readFile(args[0]);
            tem2.readFile(args[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        Moving_Least_Squares.Method m = Moving_Least_Squares.getMethod(2);
        int n1 = tem1.pointCount;
        int n2 = tem2.pointCount;
        m.setCoordinates(tem1.x, tem1.y, tem2.x, tem2.y, n2);
        for (i = n2; i < n1; ++i) {
            m.calculate(tem1.x[i], tem1.y[i]);
            if (m.resultX < 1.0f) {
                m.resultX = 1.0f;
            }
            if (m.resultY < 1.0f) {
                m.resultY = 1.0f;
            }
            tem2.addPoint(m.resultX, m.resultY);
        }
        for (i = tem2.lineCount; i < tem1.lineCount; ++i) {
            tem2.addLine(tem1.lines[i]);
        }
        try {
            tem2.writeFile(args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static class TEM {
        int pointCount;
        int lineCount;
        float[] x;
        float[] y;
        int[][] lines;

        private TEM() {
        }

        void setRoi(ImagePlus imp) {
            int count = this.x.length;
            int[] x1 = new int[count];
            int[] y1 = new int[count];
            for (int i = 0; i < count; ++i) {
                x1[i] = Math.round(this.x[i]);
                y1[i] = Math.round(this.y[i]);
            }
            PointRoi roi = new PointRoi(x1, y1, count);
            imp.setRoi((Roi)roi);
            imp.updateAndDraw();
        }

        void readFile(String fileName) throws IOException {
            int i;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            this.pointCount = Integer.parseInt(in.readLine());
            this.x = new float[this.pointCount];
            this.y = new float[this.pointCount];
            for (i = 0; i < this.pointCount; ++i) {
                String[] values = Tools.split((String)in.readLine());
                this.x[i] = Float.parseFloat(values[0]);
                this.y[i] = Float.parseFloat(values[1]);
            }
            this.lineCount = Integer.parseInt(in.readLine());
            this.lines = new int[this.lineCount][];
            for (i = 0; i < this.lineCount; ++i) {
                in.readLine();
                int len = Integer.parseInt(in.readLine());
                String line = in.readLine();
                String[] values = Tools.split((String)line);
                if (len != values.length) {
                    throw new RuntimeException("len mismatch: len=" + len + ", line is " + line);
                }
                this.lines[i] = new int[len];
                for (int j = 0; j < len; ++j) {
                    this.lines[i][j] = Integer.parseInt(values[j]);
                }
            }
            in.close();
        }

        void writeFile(String fileName) throws IOException {
            int i;
            PrintStream out = new PrintStream(new FileOutputStream(fileName));
            out.println(this.pointCount);
            for (i = 0; i < this.pointCount; ++i) {
                out.println("" + this.x[i] + "\t" + this.y[i]);
            }
            out.println(this.lineCount);
            for (i = 0; i < this.lineCount; ++i) {
                out.println(0);
                int len = this.lines[i].length;
                out.println(len);
                for (int j = 0; j < len - 1; ++j) {
                    out.print(this.lines[i][j] + " ");
                }
                out.println(this.lines[i][len - 1]);
            }
            out.println(0);
            out.close();
        }

        boolean lineSetsEqual(TEM other) {
            if (this.lines.length != other.lines.length) {
                return false;
            }
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i].length != other.lines[i].length) {
                    return false;
                }
                for (int j = 0; j < this.lines[i].length; ++j) {
                    if (this.lines[i][j] == other.lines[i][j]) continue;
                    return false;
                }
            }
            return true;
        }

        void addPoint(float x, float y) {
            if (this.pointCount + 1 > this.x.length) {
                int newLength = this.pointCount + 32;
                float[] dummy = new float[newLength];
                System.arraycopy(this.x, 0, dummy, 0, this.pointCount);
                this.x = dummy;
                dummy = new float[newLength];
                System.arraycopy(this.y, 0, dummy, 0, this.pointCount);
                this.y = dummy;
            }
            this.x[this.pointCount] = x;
            this.y[this.pointCount++] = y;
        }

        void addLine(int[] line) {
            if (this.lineCount + 1 > this.lines.length) {
                int newLength = this.lineCount + 32;
                int[][] dummy = new int[newLength][];
                System.arraycopy(this.lines, 0, dummy, 0, this.lineCount);
                this.lines = dummy;
            }
            this.lines[this.lineCount++] = line;
        }
    }
}

