/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class Mask_Of_Nearby_Points
implements PlugIn {
    public static final String PLUGIN_VERSION = "1.1";

    public void run(String ignored) {
        int y;
        int z;
        int depth;
        int height;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No image to operate on.");
            return;
        }
        Calibration c = imagePlus.getCalibration();
        int type = imagePlus.getType();
        if (0 != type && 3 != type) {
            IJ.error((String)"The image must be either 8 bit for this plugin.");
            return;
        }
        int width = imagePlus.getWidth();
        if (width * (height = imagePlus.getHeight()) * (depth = imagePlus.getStackSize()) > Integer.MAX_VALUE) {
            IJ.error((String)"This stack is too large for this plugin (must have less than 2147483647 points.");
            return;
        }
        double defaultDistance = c.pixelWidth * 3.0;
        GenericDialog gd = new GenericDialog("Mask Of Nearby Points (version: 1.1)");
        gd.addNumericField("Add to mask points within distance (" + c.getUnits() + ")", defaultDistance, 4);
        gd.addMessage("(The default distance is 3 times the separation of voxels.)");
        gd.addNumericField("... of points with value at least: ", 128.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        double withinDistance = gd.getNextNumber();
        double minimumValue = gd.getNextNumber();
        int valuesEitherSideInX = (int)(withinDistance / c.pixelWidth);
        int valuesEitherSideInY = (int)(withinDistance / c.pixelHeight);
        int valuesEitherSideInZ = (int)(withinDistance / c.pixelDepth);
        float[][][] kernel = new float[2 * valuesEitherSideInZ + 1][2 * valuesEitherSideInY + 1][2 * valuesEitherSideInX + 1];
        for (int z2 = -valuesEitherSideInZ; z2 <= valuesEitherSideInZ; ++z2) {
            for (int y2 = -valuesEitherSideInY; y2 <= valuesEitherSideInY; ++y2) {
                for (int x = -valuesEitherSideInX; x <= valuesEitherSideInX; ++x) {
                    float distance;
                    double xdiff = (double)x * c.pixelWidth;
                    double ydiff = (double)y2 * c.pixelHeight;
                    double zdiff = (double)z2 * c.pixelDepth;
                    kernel[z2 + valuesEitherSideInZ][y2 + valuesEitherSideInY][x + valuesEitherSideInX] = distance = (float)Math.sqrt(xdiff * xdiff + ydiff * ydiff + zdiff * zdiff);
                }
            }
        }
        ImageStack stack = imagePlus.getStack();
        byte[][] sliceData = new byte[depth][];
        for (int z3 = 0; z3 < depth; ++z3) {
            ByteProcessor bp = (ByteProcessor)stack.getProcessor(z3 + 1);
            sliceData[z3] = (byte[])bp.getPixelsCopy();
        }
        float[][] distancesToNearestPoints = new float[depth][];
        for (z = 0; z < depth; ++z) {
            distancesToNearestPoints[z] = new float[width * height];
            for (y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    distancesToNearestPoints[z][y * width + x] = Float.MAX_VALUE;
                }
            }
        }
        for (z = 0; z < depth; ++z) {
            IJ.showProgress((double)((double)z / (double)depth));
            for (y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int value = sliceData[z][y * width + x] & 0xFF;
                    if ((double)value < minimumValue) continue;
                    int min_x = -valuesEitherSideInX;
                    int min_y = -valuesEitherSideInY;
                    int min_z = -valuesEitherSideInZ;
                    int max_x = valuesEitherSideInX;
                    int max_y = valuesEitherSideInY;
                    int max_z = valuesEitherSideInZ;
                    if (x < valuesEitherSideInX) {
                        min_x = -x;
                    }
                    if (y < valuesEitherSideInY) {
                        min_y = -y;
                    }
                    if (z < valuesEitherSideInZ) {
                        min_z = -z;
                    }
                    if (x >= width - valuesEitherSideInX) {
                        max_x = width - 1 - x;
                    }
                    if (y >= height - valuesEitherSideInY) {
                        max_y = height - 1 - y;
                    }
                    if (z >= depth - valuesEitherSideInZ) {
                        max_z = depth - 1 - z;
                    }
                    for (int kernel_z = min_z; kernel_z <= max_z; ++kernel_z) {
                        for (int kernel_y = min_y; kernel_y <= max_y; ++kernel_y) {
                            for (int kernel_x = min_x; kernel_x <= max_x; ++kernel_x) {
                                float newDistance = kernel[kernel_z + valuesEitherSideInZ][kernel_y + valuesEitherSideInY][kernel_x + valuesEitherSideInX];
                                int offset_z = z + kernel_z;
                                int offset_i = (y + kernel_y) * width + (x + kernel_x);
                                if (!(newDistance < distancesToNearestPoints[offset_z][offset_i])) continue;
                                distancesToNearestPoints[offset_z][offset_i] = newDistance;
                            }
                        }
                    }
                }
            }
        }
        ImageStack newStack = new ImageStack(width, height);
        for (int z4 = 0; z4 < depth; ++z4) {
            IJ.showProgress((double)((double)z4 / (double)depth));
            byte[] newSlice = new byte[width * height];
            for (int y3 = 0; y3 < height; ++y3) {
                for (int x = 0; x < width; ++x) {
                    if (!((double)distancesToNearestPoints[z4][y3 * width + x] <= withinDistance)) continue;
                    newSlice[y3 * width + x] = -1;
                }
            }
            ByteProcessor bp = new ByteProcessor(width, height);
            bp.setPixels((Object)newSlice);
            newStack.addSlice("", (ImageProcessor)bp);
        }
        IJ.showProgress((double)1.0);
        ImagePlus newImagePlus = new ImagePlus("within distance " + withinDistance + " of values over " + minimumValue, newStack);
        newImagePlus.show();
    }
}

