/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ij;

import ij.IJ;
import ij.ImagePlus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.ij.N5IJUtils;
import org.janelia.saalfeldlab.n5.ij.N5ScalePyramidExporter;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.N5DatasetDiscoverer;
import org.janelia.saalfeldlab.n5.universe.N5Factory;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DefaultSingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5Metadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.AxisUtils;
import org.janelia.saalfeldlab.n5.zarr.ZarrDatasetAttributes;
import org.janelia.saalfeldlab.n5.zarr.ZarrKeyValueReader;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, menuPath="File>Save As>HDF5/N5/Zarr/OME-NGFF (patch)", description="Insert the current image as a patch into an existing dataset at a user-defined offset. New datasets can be created and existing datsets can be extended.")
public class N5SubsetExporter
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @Parameter
    private UIService ui;
    @Parameter(label="Image")
    private ImagePlus image;
    @Parameter(label="Root url")
    private String containerRoot;
    @Parameter(label="Dataset", required=false, description="This argument is ignored if the N5ViewerMetadata style is selected")
    private String dataset;
    @Parameter(label="Thread count", required=true, min="1", max="256")
    private int nThreads = 1;
    @Parameter(label="Offset", required=false, description="The point in pixel units where the origin of this image will be written into the n5-dataset (comma-delimited)")
    private String subsetOffset;
    @Parameter(label="Format", style="listBox", choices={"Auto", "HDF5", "N5", "Zarr"})
    private String storageFormat = "Auto";
    @Parameter(label="Chunk size", description="The size of chunks to use if a new array is created. Comma separated, for example: \"64,32,16\".\n You may provide fewer values than the data dimension. In that case, the size will be expanded to necessary size with the last value, for example \"64\", will expand to \"64,64,64\" for 3D data.")
    private String chunkSizeArg = "64";
    @Parameter(label="Compression", style="listBox", description="The compression type to use if a new array is created.", choices={"gzip", "raw", "lz4", "xz", "blosc", "zstd"})
    private String compressionArg = "gzip";
    private long[] offset;

    public N5SubsetExporter() {
    }

    public N5SubsetExporter(ImagePlus image, String n5RootLocation, String n5Dataset, String subsetOffset) {
        this.setOptions(image, n5RootLocation, n5Dataset, subsetOffset);
    }

    public N5SubsetExporter(ImagePlus image, String n5RootLocation, String n5Dataset, long[] subsetOffset) {
        this.setOptions(image, n5RootLocation, n5Dataset, subsetOffset);
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, String subsetOffset) {
        this.image = image;
        this.containerRoot = containerRoot;
        this.dataset = dataset;
        this.subsetOffset = subsetOffset;
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, long[] subsetOffset) {
        this.image = image;
        this.containerRoot = containerRoot;
        this.dataset = dataset;
        this.offset = subsetOffset;
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, String subsetOffset, String chunkSizeArg, String compression) {
        this.image = image;
        this.containerRoot = containerRoot;
        this.dataset = dataset;
        this.subsetOffset = subsetOffset;
        this.chunkSizeArg = chunkSizeArg;
        this.compressionArg = compression;
    }

    public void setOptions(ImagePlus image, String containerRoot, String dataset, long[] subsetOffset, String chunkSizeArg, String compression) {
        this.image = image;
        this.containerRoot = containerRoot;
        this.dataset = dataset;
        this.offset = subsetOffset;
        this.chunkSizeArg = chunkSizeArg;
        this.compressionArg = compression;
    }

    public void setOffset(long[] offset) {
        this.offset = offset;
    }

    public <T extends RealType<T> & NativeType<T>, M extends N5DatasetMetadata> void process() throws IOException, InterruptedException, ExecutionException {
        String rootWithFormatPrefix = N5ScalePyramidExporter.containerRootWithFormatPrefix(this.containerRoot, this.storageFormat, true);
        if (rootWithFormatPrefix == null) {
            return;
        }
        N5Writer n5 = new N5Factory().zarrDimensionSeparator("/").s3UseCredentials().openWriter(this.containerRoot);
        this.write(n5);
        n5.close();
    }

    public void parseOffset() {
        int i;
        if (this.offset != null) {
            return;
        }
        int nd = this.image.getNDimensions();
        String[] blockArgList = this.subsetOffset.split(",");
        int[] dims = Intervals.dimensionsAsIntArray((Dimensions)ImageJFunctions.wrap((ImagePlus)this.image));
        this.offset = new long[nd];
        for (i = 0; i < blockArgList.length && i < nd; ++i) {
            this.offset[i] = Integer.parseInt(blockArgList[i]);
        }
        int N = blockArgList.length - 1;
        while (i < nd) {
            this.offset[i] = this.offset[N] > (long)dims[i] ? (long)dims[i] : this.offset[N];
            ++i;
        }
    }

    private <T extends RealType & NativeType, M extends N5DatasetMetadata> void write(N5Writer n5) throws IOException, InterruptedException, ExecutionException {
        IntervalView rai;
        this.parseOffset();
        Img ipImg = this.image.getType() == 4 ? (Img)N5IJUtils.wrapRgbAsInt(this.image) : ImageJFunctions.wrap((ImagePlus)this.image);
        IntervalView axisPermutedImg = rai = Views.translate((RandomAccessibleInterval)ipImg, (long[])this.offset);
        if (!n5.datasetExists(this.dataset)) {
            long[] dimensions = this.outputInterval((Interval)rai).dimensionsAsLongArray();
            int[] blockSize = N5ScalePyramidExporter.parseBlockSize(this.chunkSizeArg, dimensions);
            DatasetAttributes attributes = new DatasetAttributes(dimensions, blockSize, N5Utils.dataType((NativeType)((RealType)Util.getTypeFromInterval((Interval)rai))), N5ScalePyramidExporter.getCompression(this.compressionArg));
            n5.createDataset(this.dataset, attributes);
        } else {
            N5TreeNode root = N5DatasetDiscoverer.discover((N5Reader)n5);
            Optional<N5Metadata> metaOpt = root.getDescendant(N5URI.normalizeGroupPath((String)this.dataset)).filter(x -> {
                N5Metadata m = x.getMetadata();
                return m != null && m instanceof N5DatasetMetadata;
            }).map(N5TreeNode::getMetadata);
            if (metaOpt.isPresent()) {
                N5DatasetMetadata meta = (N5DatasetMetadata)metaOpt.get();
                if (meta instanceof AxisMetadata) {
                    int[] impPerm = AxisUtils.findImagePlusPermutation((AxisMetadata)((AxisMetadata)meta));
                    int[] p = Arrays.stream(impPerm).filter(x -> x >= 0).toArray();
                    if (!AxisUtils.isIdentityPermutation((int[])p)) {
                        axisPermutedImg = AxisUtils.permute((RandomAccessibleInterval)rai, (int[])p);
                    }
                } else if (N5SubsetExporter.zarrFOrderAndEmptyMetadata((N5Reader)n5, (N5Metadata)meta)) {
                    axisPermutedImg = AxisUtils.reverseDimensions((RandomAccessibleInterval)rai);
                }
            }
        }
        if (N5SubsetExporter.zarrFOrder((N5Reader)n5, this.dataset)) {
            axisPermutedImg = AxisUtils.reverseDimensions((RandomAccessibleInterval)axisPermutedImg);
        }
        if (this.nThreads == 1) {
            N5Utils.saveRegion((RandomAccessibleInterval)axisPermutedImg, (N5Writer)n5, (String)this.dataset);
        } else {
            ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.nThreads, this.nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.progressMonitor(threadPool);
            N5Utils.saveRegion((RandomAccessibleInterval)axisPermutedImg, (N5Writer)n5, (String)this.dataset, (ExecutorService)threadPool);
            threadPool.shutdown();
        }
    }

    private static boolean zarrFOrder(N5Reader n5, String path) {
        if (n5 instanceof ZarrKeyValueReader) {
            ZarrDatasetAttributes zattrs = ((ZarrKeyValueReader)n5).getDatasetAttributes(path);
            return !zattrs.isRowMajor();
        }
        return false;
    }

    private static boolean zarrFOrderAndEmptyMetadata(N5Reader n5, N5Metadata meta) {
        return meta instanceof N5DefaultSingleScaleMetadata && N5SubsetExporter.zarrFOrder(n5, meta.getPath());
    }

    private Interval outputInterval(Interval interval) {
        int N = interval.numDimensions();
        long[] min = new long[N];
        long[] max = new long[N];
        for (int i = 0; i < N; ++i) {
            min[i] = 0L;
            max[i] = interval.min(i) < 0L ? interval.dimension(i) - 1L : interval.max(i);
        }
        return new FinalInterval(min, max);
    }

    public void run() {
        try {
            this.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void progressMonitor(final ThreadPoolExecutor exec) {
        new Thread(){

            @Override
            public void run() {
                IJ.showProgress((double)0.01);
                try {
                    Thread.sleep(333L);
                    boolean done = false;
                    while (!done && !exec.isShutdown()) {
                        long N;
                        long i = exec.getCompletedTaskCount();
                        done = i == (N = exec.getTaskCount());
                        IJ.showProgress((double)((double)i / (double)N));
                        Thread.sleep(333L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IJ.showProgress((double)1.0);
            }
        }.start();
    }
}

