/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata.imagej;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thisptr.jackson.jq.BuiltinFunctionLoader;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.Versions;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Strings;
import net.thisptr.jackson.jq.path.Path;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.metadata.imagej.ImagePlusMetadataTemplate;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;

public class MetadataTemplateMapper
implements N5MetadataWriter<ImagePlusMetadataTemplate> {
    public ImagePlusMetadataTemplate template;
    private final Scope scope;
    private final String query;
    private Gson gson;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private ObjectMapper objMapper;
    public static final String RESOLUTION_ONLY_MAPPER = "{\n\"resolution\" : [.xResolution, .yResolution, .zResolution ]\n}";
    public static final String COSEM_MAPPER = "{\n\t\"transform\":\n\t{\n\t\"scale\": [.zResolution, .yResolution, .xResolution],\n\t\"translate\": [.zOrigin, .yOrigin, .xOrigin],\n\t\"axes\": [\"z\", \"y\", \"x\"],\n\t\"units\": [.globalUnit, .globalUnit, .globalUnit]\n\t}\n}";

    public MetadataTemplateMapper(Scope scope, String query) {
        this.scope = scope;
        this.query = query;
        this.gson = new GsonBuilder().create();
        this.objMapper = MAPPER;
    }

    public MetadataTemplateMapper(String query) {
        this(MetadataTemplateMapper.buildRootScope(), query);
    }

    public void setObjectMapper(ObjectMapper objMapper) {
        this.objMapper = objMapper;
    }

    public JsonQuery getQuery() throws JsonQueryException {
        return JsonQuery.compile((String)this.query, (Version)Versions.JQ_1_6);
    }

    public Scope getScope() {
        return this.scope;
    }

    public String mapToJson(ImagePlusMetadataTemplate metadata) throws IOException {
        return this.map(this.gson.toJson((Object)metadata));
    }

    public List<JsonNode> map(JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        this.getQuery().apply(this.scope, in, out::add);
        return out;
    }

    public String map(String input) throws IOException {
        List<JsonNode> out = this.map(this.objMapper.readTree(input));
        StringBuffer stringOutput = new StringBuffer();
        for (JsonNode node : out) {
            stringOutput.append(node.toString() + "\n");
        }
        return stringOutput.toString();
    }

    public Object computeToMap(String json) throws IOException {
        return this.gson.fromJson(this.map(json), Object.class);
    }

    public JsonElement computeToJson(String input) throws IOException {
        return new JsonParser().parse(this.map(input));
    }

    public static Scope buildRootScope() {
        Scope rootScope = Scope.newEmptyScope();
        BuiltinFunctionLoader.getInstance().loadFunctions(Versions.JQ_1_6, rootScope);
        rootScope.addFunction("repeat", 1, new Function(){

            public void apply(Scope scope, List<Expression> args, JsonNode in, Path path, PathOutput output, Version version) throws JsonQueryException {
                args.get(0).apply(scope, in, time -> output.emit((JsonNode)new TextNode(Strings.repeat((String)in.asText(), (int)time.asInt())), null));
            }
        });
        return rootScope;
    }

    public void writeMetadata(ImagePlusMetadataTemplate t, N5Writer n5, String group) throws Exception {
        Map map = (Map)this.computeToMap(this.gson.toJson((Object)t));
        for (String key : map.keySet()) {
            n5.setAttribute(group, key, map.get(key));
        }
    }

    public String toJsonString(ImagePlusMetadataTemplate t) throws Exception {
        return this.computeToJson(this.gson.toJson((Object)t)).toString();
    }
}

