/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.bead.laplace;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Iterator;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor3D;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.bead.laplace.DoGMaximum;
import mpicbg.spim.registration.bead.laplace.RejectStatistics;

public final class LaPlaceFunctions {
    public static void analyzeMaximum(LocalizableByDimCursor3D<FloatType> cursor, float minPeakValue, int width, int height, int depth, float sigma, float identityRadius, float maximaTolerance, RejectStatistics rs, ArrayList<DoGMaximum> localMaxima) {
        int x = cursor.getX();
        int y = cursor.getY();
        int z = cursor.getZ();
        int xs = cursor.getX();
        int ys = cursor.getY();
        int zs = cursor.getZ();
        boolean foundStableMaxima = true;
        boolean pointsValid = false;
        int count = 0;
        DoGMaximum resultVoxel = null;
        do {
            DoGMaximum currentVoxel = new DoGMaximum(xs, ys, zs, count);
            ++count;
            currentVoxel.hessianMatrix3x3 = LaPlaceFunctions.computeHessianMatrix3x3(cursor);
            try {
                LaPlaceFunctions.invert(currentVoxel.hessianMatrix3x3);
                currentVoxel.A = new Matrix(currentVoxel.hessianMatrix3x3, 3);
            }
            catch (NoninvertibleModelException e1) {
                currentVoxel.A = null;
            }
            if (currentVoxel.A == null) {
                ++rs.noInverseOfHessianMatrix;
                continue;
            }
            currentVoxel.derivativeVector = LaPlaceFunctions.computeDerivativeVector3(cursor);
            currentVoxel.B = new Matrix(currentVoxel.derivativeVector, 3);
            currentVoxel.X = currentVoxel.A.uminus().times(currentVoxel.B);
            currentVoxel.xd = currentVoxel.X.get(0, 0);
            currentVoxel.yd = currentVoxel.X.get(1, 0);
            currentVoxel.zd = currentVoxel.X.get(2, 0);
            foundStableMaxima = true;
            if (Math.abs(currentVoxel.xd) > 0.5 + (double)((float)count * maximaTolerance)) {
                xs = (int)((double)xs + Math.signum(currentVoxel.xd));
                foundStableMaxima = false;
            }
            if (Math.abs(currentVoxel.yd) > 0.5 + (double)((float)count * maximaTolerance)) {
                ys = (int)((double)ys + Math.signum(currentVoxel.yd));
                foundStableMaxima = false;
            }
            if (Math.abs(currentVoxel.zd) > 0.5 + (double)((float)count * maximaTolerance)) {
                zs = (int)((double)zs + Math.signum(currentVoxel.zd));
                foundStableMaxima = false;
            }
            if (!foundStableMaxima) {
                cursor.setPosition(xs, ys, zs);
            }
            pointsValid = true;
            if (!(foundStableMaxima || xs > 0 && xs < width - 1 && ys > 0 && ys < height - 1 && zs > 0 && zs < depth - 1)) {
                pointsValid = false;
            }
            resultVoxel = currentVoxel;
        } while (count <= 10 && !foundStableMaxima && pointsValid);
        if (resultVoxel == null || resultVoxel.A == null) {
            cursor.setPosition(x, y, z);
            return;
        }
        if (!foundStableMaxima) {
            ++rs.noStableMaxima;
            cursor.setPosition(x, y, z);
            return;
        }
        resultVoxel.quadrFuncValue = 0.0;
        for (int j = 0; j < 3; ++j) {
            resultVoxel.quadrFuncValue += resultVoxel.X.get(j, 0) * resultVoxel.derivativeVector[j];
        }
        resultVoxel.quadrFuncValue /= 2.0;
        resultVoxel.laPlaceValue = ((FloatType)cursor.getType()).get();
        resultVoxel.sumValue = resultVoxel.quadrFuncValue + resultVoxel.laPlaceValue;
        if (Math.abs(resultVoxel.sumValue) < (double)minPeakValue) {
            ++rs.peakTooLow;
            resultVoxel = null;
            cursor.setPosition(x, y, z);
            return;
        }
        resultVoxel.sigma = sigma;
        localMaxima.add(resultVoxel);
        cursor.setPosition(x, y, z);
    }

    public static final EigenvalueDecomposition computeEigenDecomposition(double[] matrix) {
        Matrix M = new Matrix(matrix, 3);
        EigenvalueDecomposition E = new EigenvalueDecomposition(M);
        double[] result = E.getImagEigenvalues();
        boolean found = false;
        for (double im : result) {
            if (!(im > 0.0)) continue;
            found = true;
        }
        if (found) {
            return null;
        }
        return E;
    }

    public static final double det(double[] a) {
        assert (a.length == 9) : "Matrix3x3 supports 3x3 double[][] only.";
        return a[0] * a[4] * a[8] + a[3] * a[7] * a[2] + a[6] * a[1] * a[5] - a[2] * a[4] * a[6] - a[5] * a[7] * a[0] - a[8] * a[1] * a[3];
    }

    public static final void invert(double[] a) throws NoninvertibleModelException {
        assert (a.length == 9) : "Matrix3x3 supports 3x3 double[][] only.";
        double det = LaPlaceFunctions.det(a);
        if (det == 0.0) {
            throw new NoninvertibleModelException("Matrix not invertible.");
        }
        double i00 = (a[4] * a[8] - a[5] * a[7]) / det;
        double i01 = (a[2] * a[7] - a[1] * a[8]) / det;
        double i02 = (a[1] * a[5] - a[2] * a[4]) / det;
        double i10 = (a[5] * a[6] - a[3] * a[8]) / det;
        double i11 = (a[0] * a[8] - a[2] * a[6]) / det;
        double i12 = (a[2] * a[3] - a[0] * a[5]) / det;
        double i20 = (a[3] * a[7] - a[4] * a[6]) / det;
        double i21 = (a[1] * a[6] - a[0] * a[7]) / det;
        double i22 = (a[0] * a[4] - a[1] * a[3]) / det;
        a[0] = i00;
        a[1] = i01;
        a[2] = i02;
        a[3] = i10;
        a[4] = i11;
        a[5] = i12;
        a[6] = i20;
        a[7] = i21;
        a[8] = i22;
    }

    public static final double[] computeDerivativeVector3(LocalizableByDimCursor<FloatType> cursor) {
        double[] derivativeVector = new double[3];
        cursor.fwd(0);
        derivativeVector[0] = ((FloatType)cursor.getType()).get();
        cursor.bck(0);
        cursor.bck(0);
        derivativeVector[0] = derivativeVector[0] - (double)((FloatType)cursor.getType()).get();
        derivativeVector[0] = derivativeVector[0] / 2.0;
        cursor.fwd(0);
        cursor.fwd(1);
        derivativeVector[1] = ((FloatType)cursor.getType()).get();
        cursor.bck(1);
        cursor.bck(1);
        derivativeVector[1] = derivativeVector[1] - (double)((FloatType)cursor.getType()).get();
        derivativeVector[1] = derivativeVector[1] / 2.0;
        cursor.fwd(1);
        cursor.fwd(2);
        derivativeVector[2] = ((FloatType)cursor.getType()).get();
        cursor.bck(2);
        cursor.bck(2);
        derivativeVector[2] = derivativeVector[2] - (double)((FloatType)cursor.getType()).get();
        derivativeVector[2] = derivativeVector[2] / 2.0;
        cursor.fwd(2);
        return derivativeVector;
    }

    public static final double[] computeHessianMatrix3x3(LocalizableByDimCursor<FloatType> cursor) {
        double[] hessianMatrix = new double[9];
        float temp = 2.0f * ((FloatType)cursor.getType()).get();
        cursor.fwd(0);
        hessianMatrix[0] = ((FloatType)cursor.getType()).get() - temp;
        cursor.bck(0);
        cursor.bck(0);
        hessianMatrix[0] = hessianMatrix[0] + (double)((FloatType)cursor.getType()).get();
        cursor.fwd(0);
        cursor.fwd(1);
        hessianMatrix[4] = ((FloatType)cursor.getType()).get() - temp;
        cursor.bck(1);
        cursor.bck(1);
        hessianMatrix[4] = hessianMatrix[4] + (double)((FloatType)cursor.getType()).get();
        cursor.fwd(1);
        cursor.fwd(2);
        hessianMatrix[8] = ((FloatType)cursor.getType()).get() - temp;
        cursor.bck(2);
        cursor.bck(2);
        hessianMatrix[8] = hessianMatrix[8] + (double)((FloatType)cursor.getType()).get();
        cursor.bck(1);
        float d = ((FloatType)cursor.getType()).get();
        cursor.fwd(1);
        cursor.fwd(1);
        float c = ((FloatType)cursor.getType()).get();
        cursor.fwd(2);
        cursor.fwd(2);
        float a = ((FloatType)cursor.getType()).get();
        cursor.bck(1);
        cursor.bck(1);
        float b = ((FloatType)cursor.getType()).get();
        hessianMatrix[5] = hessianMatrix[7] = (double)(((a - b) / 2.0f - (c - d) / 2.0f) / 2.0f);
        cursor.fwd(1);
        cursor.fwd(0);
        float e = ((FloatType)cursor.getType()).get();
        cursor.bck(0);
        cursor.bck(0);
        float f = ((FloatType)cursor.getType()).get();
        cursor.bck(2);
        cursor.bck(2);
        float h = ((FloatType)cursor.getType()).get();
        cursor.fwd(0);
        cursor.fwd(0);
        float g = ((FloatType)cursor.getType()).get();
        hessianMatrix[2] = hessianMatrix[6] = (double)(((e - f) / 2.0f - (g - h) / 2.0f) / 2.0f);
        cursor.fwd(2);
        cursor.fwd(1);
        float i = ((FloatType)cursor.getType()).get();
        cursor.bck(0);
        cursor.bck(0);
        float j = ((FloatType)cursor.getType()).get();
        cursor.bck(1);
        cursor.bck(1);
        float l = ((FloatType)cursor.getType()).get();
        cursor.fwd(0);
        cursor.fwd(0);
        float k = ((FloatType)cursor.getType()).get();
        hessianMatrix[1] = hessianMatrix[3] = (double)(((i - j) / 2.0f - (k - l) / 2.0f) / 2.0f);
        cursor.bck(0);
        cursor.fwd(1);
        return hessianMatrix;
    }

    public static boolean isSpecialPointMin(LocalizableByDimCursor3D<FloatType> cursor, float minInitialPeakValue) {
        float value = ((FloatType)cursor.getType()).get();
        if (Math.abs(value) < minInitialPeakValue) {
            return false;
        }
        LocalNeighborhoodCursor3D neighborhoodCursor = new LocalNeighborhoodCursor3D(cursor);
        boolean isMin = true;
        while (isMin && neighborhoodCursor.hasNext()) {
            neighborhoodCursor.fwd();
            isMin = ((FloatType)cursor.getType()).get() >= value;
        }
        neighborhoodCursor.reset();
        neighborhoodCursor.close();
        return isMin;
    }

    public static void subtractImagesInPlace(Image<FloatType> img1, Image<FloatType> img2, float norm) {
        if (!img1.getContainer().compareStorageContainerDimensions(img2.getContainer())) {
            IOFunctions.println("Containers are not of the same size, quitting.");
            return;
        }
        if (img1.getContainer().getClass().isInstance(img2.getContainer())) {
            Cursor c1 = img1.createCursor();
            Cursor c2 = img2.createCursor();
            while (c1.hasNext()) {
                c1.fwd();
                c2.fwd();
                ((FloatType)c1.getType()).sub((FloatType)c2.getType());
                ((FloatType)c1.getType()).mul(norm);
            }
            c1.close();
            c2.close();
        } else {
            IOFunctions.println("Containers are not of the same type, more complicated");
            LocalizableCursor c1 = img1.createLocalizableCursor();
            LocalizableByDimCursor c2 = img2.createLocalizableByDimCursor();
            int[] pos = new int[img1.getNumDimensions()];
            while (c1.hasNext()) {
                c1.fwd();
                c1.getPosition(pos);
                c2.setPosition(pos);
                ((FloatType)c1.getType()).sub((FloatType)c2.getType());
            }
            c1.close();
            c2.close();
        }
    }

    public static float[] computeSigma(int steps, float k, float initialSigma) {
        float[] sigma = new float[steps + 1];
        sigma[0] = initialSigma;
        for (int i = 1; i <= steps; ++i) {
            sigma[i] = sigma[i - 1] * k;
        }
        return sigma;
    }

    public static float getDiffSigma(float sigma_a, float sigma_b) {
        return (float)Math.sqrt(sigma_b * sigma_b - sigma_a * sigma_a);
    }

    public static float[] computeSigmaDiff(float[] sigma, float imageSigma) {
        int steps = sigma.length - 1;
        float[] sigmaDiff = new float[steps + 1];
        sigmaDiff[0] = LaPlaceFunctions.getDiffSigma(imageSigma, sigma[0]);
        for (int i = 1; i <= steps; ++i) {
            sigmaDiff[i] = LaPlaceFunctions.getDiffSigma(imageSigma, sigma[i]);
        }
        return sigmaDiff;
    }

    public static float computeK(int stepsPerOctave) {
        return (float)Math.pow(2.0, 1.0f / (float)stepsPerOctave);
    }

    public static float computeKWeight(float k) {
        return 1.0f / (k - 1.0f);
    }

    public static ArrayList<DoGMaximum> checkMaximaXTree(ArrayList<DoGMaximum> input, float identityRadius) {
        if (input.size() == 0) {
            return new ArrayList<DoGMaximum>();
        }
        double minX = 3.4028234663852886E38;
        double maxX = -3.4028234663852886E38;
        for (DoGMaximum resultVoxel : input) {
            double x = (double)resultVoxel.x + resultVoxel.xd;
            if (x < minX) {
                minX = x;
            }
            if (!(x > maxX)) continue;
            maxX = x;
        }
        int min = (int)minX;
        int max = (int)maxX + 1;
        ArrayList[] maxima = new ArrayList[max - min + 1];
        for (int i = 0; i < maxima.length; ++i) {
            maxima[i] = new ArrayList();
        }
        for (DoGMaximum resultVoxel : input) {
            double x = (double)resultVoxel.x + resultVoxel.xd;
            int startX = (int)(x - (double)identityRadius) - 1;
            int endX = (int)(x + (double)identityRadius) + 2;
            if (startX < min) {
                startX = min;
            }
            if (endX > max) {
                endX = max;
            }
            boolean isHighest = true;
            ArrayList<DoGMaximum> removeMaxima = new ArrayList<DoGMaximum>();
            int removeI = -1;
            for (int i = startX - min; i <= endX - min && isHighest; ++i) {
                Iterator k = maxima[i].iterator();
                while (k.hasNext() && isHighest) {
                    DoGMaximum otherMaximum = (DoGMaximum)k.next();
                    float distance = resultVoxel.getDistanceTo(otherMaximum);
                    if (!(distance <= identityRadius)) continue;
                    if (Math.abs(otherMaximum.sumValue) > Math.abs(resultVoxel.sumValue)) {
                        isHighest = false;
                        continue;
                    }
                    removeMaxima.add(otherMaximum);
                    removeI = i;
                }
            }
            if (isHighest && removeMaxima.size() > 0) {
                for (DoGMaximum otherMaximum : removeMaxima) {
                    maxima[removeI].remove(otherMaximum);
                }
            }
            if (!isHighest) continue;
            maxima[(int)Math.round(x) - min].add(resultVoxel);
        }
        ArrayList<DoGMaximum> localMaxima = new ArrayList<DoGMaximum>();
        for (int i = 0; i < maxima.length; ++i) {
            for (DoGMaximum dg : maxima[i]) {
                localMaxima.add(dg);
            }
        }
        return localMaxima;
    }
}

