/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.interestpoints;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.base.XmlIoSingleton;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;

public class XmlIoViewInterestPoints
extends XmlIoSingleton<ViewInterestPoints> {
    public XmlIoViewInterestPoints() {
        super("ViewInterestPoints", ViewInterestPoints.class);
        this.handledTags.add("ViewInterestPointsFile");
    }

    public Element toXml(ViewInterestPoints viewsInterestPoints) {
        Element elem = super.toXml();
        ArrayList<ViewInterestPointLists> viewIPlist = new ArrayList<ViewInterestPointLists>();
        viewIPlist.addAll(viewsInterestPoints.getViewInterestPoints().values());
        Collections.sort(viewIPlist);
        for (ViewInterestPointLists v : viewIPlist) {
            ArrayList<String> labelList = new ArrayList<String>();
            labelList.addAll(v.getHashMap().keySet());
            Collections.sort(labelList);
            for (String label : labelList) {
                InterestPointList list = v.getInterestPointList(label);
                elem.addContent((Content)this.viewInterestPointsToXml(list, v.getTimePointId(), v.getViewSetupId(), label));
            }
        }
        return elem;
    }

    public ViewInterestPoints fromXml(Element allInterestPointLists, File basePath, Map<ViewId, ViewDescription> viewDescriptions) throws SpimDataException {
        ViewInterestPoints viewsInterestPoints = (ViewInterestPoints)super.fromXml(allInterestPointLists);
        viewsInterestPoints.createViewInterestPoints(viewDescriptions);
        for (Element viewInterestPointsElement : allInterestPointLists.getChildren("ViewInterestPointsFile")) {
            int timepointId = Integer.parseInt(viewInterestPointsElement.getAttributeValue("timepoint"));
            int setupId = Integer.parseInt(viewInterestPointsElement.getAttributeValue("setup"));
            String label = viewInterestPointsElement.getAttributeValue("label");
            String parameters = viewInterestPointsElement.getAttributeValue("params");
            String interestPointFileName = viewInterestPointsElement.getTextTrim();
            ViewId viewId = new ViewId(timepointId, setupId);
            ViewInterestPointLists collection = viewsInterestPoints.getViewInterestPointLists(viewId);
            InterestPointList list = new InterestPointList(basePath, new File(interestPointFileName));
            list.setParameters(parameters);
            collection.addInterestPointList(label, list);
        }
        return viewsInterestPoints;
    }

    protected Element viewInterestPointsToXml(InterestPointList interestPointList, int tpId, int viewId, String label) {
        Element elem = new Element("ViewInterestPointsFile");
        elem.setAttribute("timepoint", Integer.toString(tpId));
        elem.setAttribute("setup", Integer.toString(viewId));
        elem.setAttribute("label", label);
        elem.setAttribute("params", interestPointList.getParameters());
        elem.setText(interestPointList.getFile().toString().replace("\\", "/"));
        return elem;
    }
}

