/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.TrackMatePlugIn;
import fiji.plugin.trackmate.features.edges.EdgeAnalyzer;
import fiji.plugin.trackmate.features.spot.SpotAnalyzerFactoryBase;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import fiji.plugin.trackmate.gui.GuiUtils;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardSequence;
import fiji.plugin.trackmate.gui.wizard.descriptors.LogPanelDescriptor2;
import fiji.plugin.trackmate.io.IOUtils;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.io.TmXmlReader;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.ViewUtils;
import fiji.plugin.trackmate.visualization.hyperstack.HyperStackDisplayer;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.JFrame;
import org.scijava.util.VersionUtils;

public class LoadTrackMatePlugIn
extends TrackMatePlugIn {
    @Override
    public void run(String filePath) {
        ImagePlus imp;
        TmXmlReader reader;
        File file;
        Logger logger = Logger.IJ_LOGGER;
        if (null == filePath || filePath.length() == 0) {
            Settings lastUsedSettings = SettingsPersistence.readLastUsedSettings(null, logger);
            file = TMUtils.proposeTrackMateSaveFile(lastUsedSettings, Logger.VOID_LOGGER);
            if (null == (file = IOUtils.askForFileForLoading(file, "Load a TrackMate XML file", null, logger))) {
                return;
            }
        } else {
            file = new File(filePath);
            if (!file.exists()) {
                IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)("Could not find file with path " + filePath + "."));
                return;
            }
            if (!file.canRead()) {
                IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)("Could not read file with path " + filePath + "."));
                return;
            }
        }
        if (!(reader = this.createReader(file)).isReadingOk()) {
            IJ.error((String)("TrackMate v" + TrackMate.PLUGIN_NAME_VERSION), (String)reader.getErrorMessage());
            return;
        }
        String version = reader.getVersion();
        if (VersionUtils.compare((String)version, (String)"2.1.0") < 0) {
            logger.error("Cannot read TrackMate file version lower than 2.1.0.\nAborting.\n");
            return;
        }
        if (!reader.isReadingOk()) {
            logger.error(reader.getErrorMessage());
            logger.error("Aborting.\n");
            return;
        }
        String logText = reader.getLog() + '\n';
        Model model = reader.getModel();
        if (!reader.isReadingOk()) {
            logger.error("Problem reading the model:\n" + reader.getErrorMessage());
        }
        if (null == (imp = reader.readImage())) {
            imp = ViewUtils.makeEmpytImagePlus(model);
        }
        Settings settings = reader.readSettings(imp);
        if (!reader.isReadingOk()) {
            logger.error("Problem reading the settings:\n" + reader.getErrorMessage());
        }
        if (settings == null) {
            logger.error("Problem reading the settings:\nThe file did not contain a settings element. Using default values.");
            settings = new Settings(imp);
        }
        for (SpotAnalyzerFactoryBase<?> spotAnalyzerFactoryBase : settings.getSpotAnalyzerFactories()) {
            model.getFeatureModel().declareSpotFeatures(spotAnalyzerFactoryBase.getFeatures(), spotAnalyzerFactoryBase.getFeatureNames(), spotAnalyzerFactoryBase.getFeatureShortNames(), spotAnalyzerFactoryBase.getFeatureDimensions(), spotAnalyzerFactoryBase.getIsIntFeature());
        }
        for (EdgeAnalyzer edgeAnalyzer : settings.getEdgeAnalyzers()) {
            model.getFeatureModel().declareEdgeFeatures(edgeAnalyzer.getFeatures(), edgeAnalyzer.getFeatureNames(), edgeAnalyzer.getFeatureShortNames(), edgeAnalyzer.getFeatureDimensions(), edgeAnalyzer.getIsIntFeature());
        }
        for (TrackAnalyzer trackAnalyzer : settings.getTrackAnalyzers()) {
            model.getFeatureModel().declareTrackFeatures(trackAnalyzer.getFeatures(), trackAnalyzer.getFeatureNames(), trackAnalyzer.getFeatureShortNames(), trackAnalyzer.getFeatureDimensions(), trackAnalyzer.getIsIntFeature());
        }
        TrackMate trackmate = this.createTrackMate(model, settings);
        this.postRead(trackmate);
        DisplaySettings displaySettings = reader.getDisplaySettings();
        SelectionModel selectionModel = new SelectionModel(model);
        if (!reader.isReadingOk()) {
            logger.error("Some errors occurred while reading file:\n");
            logger.error(reader.getErrorMessage());
        }
        HyperStackDisplayer displayer = new HyperStackDisplayer(model, selectionModel, settings.imp, displaySettings);
        displayer.render();
        String panelIdentifier = reader.getGUIState();
        if (null == panelIdentifier) {
            panelIdentifier = "ConfigureViews";
        }
        WizardSequence sequence = this.createSequence(trackmate, selectionModel, displaySettings);
        sequence.setCurrent(panelIdentifier);
        JFrame frame = sequence.run("TrackMate on " + settings.imp.getShortTitle());
        frame.setIconImage(Icons.TRACKMATE_ICON.getImage());
        GuiUtils.positionWindow(frame, (Component)settings.imp.getWindow());
        frame.setVisible(true);
        LogPanelDescriptor2 logDescriptor = (LogPanelDescriptor2)sequence.logDescriptor();
        LogPanel logPanel = (LogPanel)logDescriptor.getPanelComponent();
        Logger logger2 = logPanel.getLogger();
        logger2.log("Session log saved in the file:\n--------------------\n" + logText + "--------------------\n", Color.GRAY);
        String warning = reader.getErrorMessage();
        if (!warning.isEmpty()) {
            logger2.log("Warnings occured during reading the file:\n--------------------\n" + warning + "--------------------\n", Color.ORANGE.darker());
        }
        logger2.log("File loaded on " + TMUtils.getCurrentTimeString() + '\n', Logger.BLUE_COLOR);
        String welcomeMessage = "TrackMate v" + TrackMate.PLUGIN_NAME_VERSION + '\n';
        logger2.log(welcomeMessage, Logger.BLUE_COLOR);
        logger2.log("Please note that TrackMate is available through Fiji, and is based on a publication. If you use it successfully for your research please be so kind to cite our work:\n");
        logger2.log("Ershov, D., Phan, MS., Pylv\u00e4n\u00e4inen, J.W., Rigaud S.U., et al. TrackMate 7: integrating state-of-the-art segmentation algorithms into tracking pipelines. Nat Methods (2022). https://doi.org/10.1038/s41592-022-01507-1\n", Logger.GREEN_COLOR);
        logger2.log("https://doi.org/10.1038/s41592-022-01507-1\n", Logger.BLUE_COLOR);
        logger2.log("and / or:\n");
        logger2.log("Tinevez, JY.; Perry, N. & Schindelin, J. et al. (2017), 'TrackMate: An open and extensible platform for single-particle tracking.', Methods 115: 80-90, PMID 27713081.\n", Logger.GREEN_COLOR);
        logger2.log("https://www.sciencedirect.com/science/article/pii/S1046202316303346\n", Logger.BLUE_COLOR);
        if (!reader.isReadingOk()) {
            logger2.error("Some errors occurred while reading file:\n");
            logger2.error(reader.getErrorMessage());
        }
    }

    protected void postRead(TrackMate trackmate) {
    }

    protected TmXmlReader createReader(File lFile) {
        return new TmXmlReader(lFile);
    }

    public static void main(String[] args) {
        ImageJ.main((String[])args);
        LoadTrackMatePlugIn plugIn = new LoadTrackMatePlugIn();
        plugIn.run(null);
    }
}

