/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.graph;

import fiji.plugin.trackmate.Spot;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.imglib2.algorithm.Benchmark;
import net.imglib2.algorithm.OutputAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class FromContinuousBranches
implements OutputAlgorithm<SimpleWeightedGraph<Spot, DefaultWeightedEdge>>,
Benchmark {
    private static final String BASE_ERROR_MSG = "[FromContinuousBranches] ";
    private long processingTime;
    private final Collection<List<Spot>> branches;
    private final Collection<List<Spot>> links;
    private String errorMessage;
    private SimpleWeightedGraph<Spot, DefaultWeightedEdge> graph;

    public FromContinuousBranches(Collection<List<Spot>> branches, Collection<List<Spot>> links) {
        this.branches = branches;
        this.links = links;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public boolean checkInput() {
        long start = System.currentTimeMillis();
        if (null == this.branches) {
            this.errorMessage = "[FromContinuousBranches] branches are null.";
            return false;
        }
        if (null == this.links) {
            this.errorMessage = "[FromContinuousBranches] links are null.";
            return false;
        }
        for (List<Spot> link : this.links) {
            if (link.size() != 2) {
                this.errorMessage = "[FromContinuousBranches] A link is not made of two spots.";
                return false;
            }
            if (!this.checkIfInBranches(link.get(0))) {
                this.errorMessage = "[FromContinuousBranches] A spot in a link is not present in the branch collection: " + link.get(0) + " in the link " + link.get(0) + "-" + link.get(1) + ".";
                return false;
            }
            if (this.checkIfInBranches(link.get(1))) continue;
            this.errorMessage = "[FromContinuousBranches] A spot in a link is not present in the branch collection: " + link.get(1) + " in the link " + link.get(0) + "-" + link.get(1) + ".";
            return false;
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public boolean process() {
        long start = System.currentTimeMillis();
        this.graph = new SimpleWeightedGraph(DefaultWeightedEdge.class);
        for (List<Spot> branch : this.branches) {
            for (Spot spot : branch) {
                this.graph.addVertex((Object)spot);
            }
        }
        for (List<Spot> branch : this.branches) {
            Iterator<Spot> it = branch.iterator();
            Spot previous = it.next();
            while (it.hasNext()) {
                Spot spot = it.next();
                this.graph.addEdge((Object)previous, (Object)spot);
                previous = spot;
            }
        }
        for (List<Spot> link : this.links) {
            this.graph.addEdge((Object)link.get(0), (Object)link.get(1));
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public SimpleWeightedGraph<Spot, DefaultWeightedEdge> getResult() {
        return this.graph;
    }

    private final boolean checkIfInBranches(Spot spot) {
        for (List<Spot> branch : this.branches) {
            if (!branch.contains(spot)) continue;
            return true;
        }
        return false;
    }
}

