/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.tracking.kalman;

import Jama.Matrix;

public class CVMKalmanFilter {
    private final Matrix A;
    private Matrix P;
    private final Matrix Q;
    private final Matrix R;
    private Matrix X;
    private final Matrix H;
    private Matrix Xp;
    private int nOcclusion;

    public CVMKalmanFilter(double[] X0, double initStateCovariance, double positionProcessStd, double velocityProcessStd, double positionMeasurementStd) {
        int i;
        this.X = new Matrix(X0, 6);
        this.A = Matrix.identity((int)6, (int)6);
        for (i = 0; i < 3; ++i) {
            this.A.set(i, 3 + i, 1.0);
        }
        this.H = Matrix.identity((int)3, (int)6);
        this.P = Matrix.identity((int)6, (int)6).times(initStateCovariance);
        this.Q = Matrix.identity((int)6, (int)6);
        for (i = 0; i < 3; ++i) {
            this.Q.set(i, i, positionProcessStd * positionProcessStd);
            this.Q.set(3 + i, 3 + i, velocityProcessStd * velocityProcessStd);
        }
        this.R = Matrix.identity((int)3, (int)3).times(positionMeasurementStd * positionMeasurementStd);
    }

    public double[] predict() {
        this.Xp = this.A.times(this.X);
        this.P = this.A.times(this.P.times(this.A.transpose())).plus(this.Q);
        return this.Xp.getColumnPackedCopy();
    }

    public void update(double[] Xm) {
        if (null == Xm) {
            ++this.nOcclusion;
            this.X = this.Xp;
        } else {
            Matrix XM = new Matrix(Xm, 3);
            Matrix TEMP = this.H.times(this.P.times(this.H.transpose())).plus(this.R);
            Matrix K = this.P.times(this.H.transpose()).times(TEMP.inverse());
            this.X = this.Xp.plus(K.times(XM.minus(this.H.times(this.Xp))));
            this.P = Matrix.identity((int)6, (int)6).minus(K.times(this.H)).times(this.P);
        }
    }

    public double getPositionError() {
        return Math.sqrt((this.P.get(0, 0) + this.P.get(1, 1) + this.P.get(2, 2)) / 3.0);
    }

    public double getVelocityError() {
        return Math.sqrt((this.P.get(3, 3) + this.P.get(4, 4) + this.P.get(5, 5)) / 3.0);
    }

    public int getNOcclusion() {
        return this.nOcclusion;
    }
}

