/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class SpotOverlay
extends Roi {
    private static final long serialVersionUID = 1L;
    protected Spot editingSpot;
    protected final double[] calibration;
    protected FontMetrics fm;
    protected Collection<Spot> spotSelection = new ArrayList<Spot>();
    protected DisplaySettings displaySettings;
    protected final Model model;

    public SpotOverlay(Model model, ImagePlus imp, DisplaySettings displaySettings) {
        super(0, 0, imp);
        this.model = model;
        this.imp = imp;
        this.calibration = TMUtils.getSpatialCalibration(imp);
        this.displaySettings = displaySettings;
    }

    public void drawOverlay(Graphics g) {
        int xcorner = this.ic.offScreenX(0);
        int ycorner = this.ic.offScreenY(0);
        double magnification = this.getMagnification();
        SpotCollection spots = this.model.getSpots();
        if (!this.displaySettings.isSpotVisible()) {
            return;
        }
        boolean doLimitDrawingDepth = this.displaySettings.isZDrawingDepthLimited();
        double drawingDepth = this.displaySettings.getZDrawingDepth();
        DisplaySettings.TrackDisplayMode trackDisplayMode = this.displaySettings.getTrackDisplayMode();
        boolean selectionOnly = trackDisplayMode == DisplaySettings.TrackDisplayMode.SELECTION_ONLY;
        boolean filled = this.displaySettings.isSpotFilled();
        float alpha = (float)this.displaySettings.getSpotTransparencyAlpha();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform originalTransform = g2d.getTransform();
        Composite originalComposite = g2d.getComposite();
        Stroke originalStroke = g2d.getStroke();
        Color originalColor = g2d.getColor();
        Font originalFont = g2d.getFont();
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.setFont(this.displaySettings.getFont());
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.displaySettings.getUseAntialiasing() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.fm = g2d.getFontMetrics();
        double zslice = (double)(this.imp.getSlice() - 1) * this.calibration[2];
        double lMag = magnification;
        int frame = this.imp.getFrame() - 1;
        FeatureColorGenerator<Spot> colorGenerator = FeatureUtils.createSpotColorGenerator(this.model, this.displaySettings);
        g2d.setStroke(new BasicStroke((float)this.displaySettings.getLineThickness()));
        if (selectionOnly && null != this.spotSelection) {
            for (Spot spot : this.spotSelection) {
                int sFrame;
                if (spot == this.editingSpot || (sFrame = spot.getFeature("FRAME").intValue()) != frame) continue;
                double z = spot.getFeature("POSITION_Z");
                if (doLimitDrawingDepth && Math.abs(z - zslice) > drawingDepth) continue;
                Color color = colorGenerator.color(spot);
                g2d.setColor(color);
                this.drawSpot(g2d, spot, zslice, xcorner, ycorner, lMag, filled);
            }
        } else {
            Iterator<Spot> iterator = spots.iterator(frame, true);
            while (iterator.hasNext()) {
                Spot spot = iterator.next();
                if (this.editingSpot == spot || this.spotSelection != null && this.spotSelection.contains(spot)) continue;
                Color color = colorGenerator.color(spot);
                g2d.setColor(color);
                double z = spot.getFeature("POSITION_Z");
                if (doLimitDrawingDepth && Math.abs(z - zslice) > drawingDepth) continue;
                this.drawSpot(g2d, spot, zslice, xcorner, ycorner, lMag, filled);
            }
            if (null != this.spotSelection) {
                g2d.setStroke(new BasicStroke((float)this.displaySettings.getSelectionLineThickness()));
                g2d.setColor(this.displaySettings.getHighlightColor());
                for (Spot spot : this.spotSelection) {
                    int sFrame;
                    if (spot == this.editingSpot || (sFrame = spot.getFeature("FRAME").intValue()) != frame) continue;
                    this.drawSpot(g2d, spot, zslice, xcorner, ycorner, lMag, filled);
                }
            }
        }
        this.drawExtraLayer(g2d, frame);
        if (null != this.editingSpot) {
            g2d.setColor(this.displaySettings.getHighlightColor());
            g2d.setStroke(new BasicStroke((float)this.displaySettings.getLineThickness(), 1, 1, 1.0f, new float[]{5.0f, 5.0f}, 0.0f));
            double x = this.editingSpot.getFeature("POSITION_X");
            double y = this.editingSpot.getFeature("POSITION_Y");
            double radius = this.editingSpot.getFeature("RADIUS") / this.calibration[0] * lMag;
            double xp = x / this.calibration[0] + 0.5;
            double yp = y / this.calibration[1] + 0.5;
            double xs = (xp - (double)xcorner) * lMag;
            double ys = (yp - (double)ycorner) * lMag;
            double radiusRatio = this.displaySettings.getSpotDisplayRadius();
            g2d.drawOval((int)Math.round(xs - radius * radiusRatio), (int)Math.round(ys - radius * radiusRatio), (int)Math.round(2.0 * radius * radiusRatio), (int)Math.round(2.0 * radius * radiusRatio));
        }
        g2d.setTransform(originalTransform);
        g2d.setComposite(originalComposite);
        g2d.setStroke(originalStroke);
        g2d.setColor(originalColor);
        g2d.setFont(originalFont);
    }

    protected void drawExtraLayer(Graphics2D g2d, int frame) {
    }

    public void setSpotSelection(Collection<Spot> spots) {
        this.spotSelection = spots;
    }

    protected void drawSpot(Graphics2D g2d, Spot spot, double zslice, int xcorner, int ycorner, double magnification, boolean filled) {
        double x = spot.getFeature("POSITION_X");
        double y = spot.getFeature("POSITION_Y");
        double z = spot.getFeature("POSITION_Z");
        double dz2 = (z - zslice) * (z - zslice);
        double radiusRatio = this.displaySettings.getSpotDisplayRadius();
        double radius = spot.getFeature("RADIUS") * radiusRatio;
        double xp = x / this.calibration[0] + 0.5;
        double yp = y / this.calibration[1] + 0.5;
        double xs = (xp - (double)xcorner) * magnification;
        double ys = (yp - (double)ycorner) * magnification;
        if (dz2 >= radius * radius) {
            g2d.fillOval((int)Math.round(xs - 2.0 * magnification), (int)Math.round(ys - 2.0 * magnification), (int)Math.round(4.0 * magnification), (int)Math.round(4.0 * magnification));
            return;
        }
        SpotRoi roi = spot.getRoi();
        if (!this.displaySettings.isSpotDisplayedAsRoi() || roi == null || roi.x.length < 2) {
            double apparentRadius = Math.sqrt(radius * radius - dz2) / this.calibration[0] * magnification;
            int textPos = (int)apparentRadius;
            if (this.displaySettings.isSpotShowName()) {
                this.drawSpotName(g2d, spot, xs, ys, textPos);
            }
            if (filled) {
                g2d.fillOval((int)Math.round(xs - apparentRadius), (int)Math.round(ys - apparentRadius), (int)Math.round(2.0 * apparentRadius), (int)Math.round(2.0 * apparentRadius));
            } else {
                g2d.drawOval((int)Math.round(xs - apparentRadius), (int)Math.round(ys - apparentRadius), (int)Math.round(2.0 * apparentRadius), (int)Math.round(2.0 * apparentRadius));
            }
        } else {
            double[] polygonX = roi.toPolygonX(this.calibration[0], (double)xcorner - 0.5, x, magnification);
            double[] polygonY = roi.toPolygonY(this.calibration[1], (double)ycorner - 0.5, y, magnification);
            Path2D.Double polygon = new Path2D.Double();
            ((Path2D)polygon).moveTo(polygonX[0], polygonY[0]);
            for (int i = 1; i < polygonX.length; ++i) {
                ((Path2D)polygon).lineTo(polygonX[i], polygonY[i]);
            }
            polygon.closePath();
            int textPos = (int)(Arrays.stream(polygonX).max().getAsDouble() - xs);
            if (filled) {
                if (this.displaySettings.isSpotShowName()) {
                    this.drawSpotName(g2d, spot, xs, ys, textPos);
                }
                g2d.fill(polygon);
                g2d.setColor(Color.BLACK);
                g2d.draw(polygon);
            } else {
                if (this.displaySettings.isSpotShowName()) {
                    this.drawSpotName(g2d, spot, xs, ys, textPos);
                }
                g2d.draw(polygon);
            }
        }
    }

    private final void drawSpotName(Graphics2D g2d, Spot spot, double xs, double ys, int textPos) {
        int xtext = (int)(xs + (double)textPos + 5.0);
        String str = spot.toString();
        int xindent = this.fm.stringWidth(str);
        if (xtext + xindent > this.imp.getWindow().getWidth()) {
            xtext = (int)(xs - (double)textPos - 5.0 - (double)xindent);
        }
        int yindent = this.fm.getAscent() / 2;
        int ytext = (int)ys + yindent;
        g2d.drawString(spot.toString(), xtext, ytext);
    }
}

