/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.hyperstack;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.util.TMUtils;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import ij.ImagePlus;
import ij.gui.Roi;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.graph.DefaultWeightedEdge;

public class TrackOverlay
extends Roi {
    private static final long serialVersionUID = 1L;
    protected final double[] calibration;
    protected Collection<DefaultWeightedEdge> highlight = new HashSet<DefaultWeightedEdge>();
    protected DisplaySettings displaySettings;
    protected final Model model;

    public TrackOverlay(Model model, ImagePlus imp, DisplaySettings displaySettings) {
        super(0, 0, imp);
        this.model = model;
        this.calibration = TMUtils.getSpatialCalibration(imp);
        this.imp = imp;
        this.displaySettings = displaySettings;
    }

    public void setHighlight(Collection<DefaultWeightedEdge> edges) {
        this.highlight = edges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void drawOverlay(Graphics g) {
        Object target;
        Spot source;
        int maxT;
        int minT;
        Graphics2D g2d = (Graphics2D)g;
        double magnification = this.getMagnification();
        int xcorner = this.ic.offScreenX(0);
        int ycorner = this.ic.offScreenY(0);
        double minx = xcorner;
        double miny = ycorner;
        double maxx = minx + (double)this.ic.getWidth() / magnification;
        double maxy = miny + (double)this.ic.getHeight() / magnification;
        if (!this.displaySettings.isTrackVisible() || this.model.getTrackModel().nTracks(true) == 0) {
            return;
        }
        boolean doLimitDrawingDepth = this.displaySettings.isZDrawingDepthLimited();
        double drawingDepth = this.displaySettings.getZDrawingDepth();
        double zslice = (double)(this.imp.getSlice() - 1) * this.calibration[2];
        AffineTransform originalTransform = g2d.getTransform();
        Composite originalComposite = g2d.getComposite();
        Stroke originalStroke = g2d.getStroke();
        Color originalColor = g2d.getColor();
        int currentFrame = this.imp.getFrame() - 1;
        DisplaySettings.TrackDisplayMode trackDisplayMode = this.displaySettings.getTrackDisplayMode();
        int trackDisplayDepth = this.displaySettings.isFadeTracks() ? this.displaySettings.getFadeTrackRange() : 1000000000;
        Set<Integer> filteredTrackKeys = this.model.getTrackModel().unsortedTrackIDs(true);
        g2d.setStroke(new BasicStroke((float)this.displaySettings.getLineThickness()));
        if (trackDisplayMode == DisplaySettings.TrackDisplayMode.LOCAL) {
            g2d.setComposite(AlphaComposite.getInstance(3));
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.displaySettings.getUseAntialiasing() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        FeatureColorGenerator<DefaultWeightedEdge> colorGenerator = FeatureUtils.createTrackColorGenerator(this.model, this.displaySettings);
        switch (trackDisplayMode) {
            default: {
                minT = currentFrame - trackDisplayDepth;
                maxT = currentFrame + trackDisplayDepth;
                break;
            }
            case LOCAL_FORWARD: {
                minT = currentFrame;
                maxT = currentFrame + trackDisplayDepth;
                break;
            }
            case LOCAL_BACKWARD: {
                minT = currentFrame - trackDisplayDepth;
                maxT = currentFrame;
            }
        }
        switch (trackDisplayMode) {
            case SELECTION_ONLY: {
                for (DefaultWeightedEdge edge : this.highlight) {
                    int sourceFrame;
                    source = this.model.getTrackModel().getEdgeSource(edge);
                    if (!TrackOverlay.isOnClip(source, target = this.model.getTrackModel().getEdgeTarget(edge), minx, miny, maxx, maxy, this.calibration) || (sourceFrame = source.getFeature("FRAME").intValue()) < minT || sourceFrame >= maxT) continue;
                    double zs = source.getFeature("POSITION_Z");
                    double zt = ((Spot)target).getFeature("POSITION_Z");
                    if (doLimitDrawingDepth && Math.abs(zs - zslice) > drawingDepth && Math.abs(zt - zslice) > drawingDepth) continue;
                    g2d.setColor(colorGenerator.color(edge));
                    float transparency = (float)(1.0 - Math.abs((double)sourceFrame - (double)currentFrame) / (double)trackDisplayDepth);
                    this.drawEdge(g2d, source, (Spot)target, xcorner, ycorner, magnification, transparency);
                }
                break;
            }
            case FULL: {
                HashSet<DefaultWeightedEdge> track;
                for (Integer trackID : filteredTrackKeys) {
                    track = new HashSet<DefaultWeightedEdge>(this.model.getTrackModel().trackEdges(trackID));
                    target = track.iterator();
                    while (target.hasNext()) {
                        Spot target2;
                        DefaultWeightedEdge edge = (DefaultWeightedEdge)target.next();
                        Spot source2 = this.model.getTrackModel().getEdgeSource(edge);
                        if (!TrackOverlay.isOnClip(source2, target2 = this.model.getTrackModel().getEdgeTarget(edge), minx, miny, maxx, maxy, this.calibration)) continue;
                        double zs = source2.getFeature("POSITION_Z");
                        double zt = target2.getFeature("POSITION_Z");
                        if (doLimitDrawingDepth && Math.abs(zs - zslice) > drawingDepth && Math.abs(zt - zslice) > drawingDepth) continue;
                        g2d.setColor(colorGenerator.color(edge));
                        this.drawEdge(g2d, source2, target2, xcorner, ycorner, magnification);
                    }
                }
                break;
            }
            case LOCAL: 
            case LOCAL_FORWARD: 
            case LOCAL_BACKWARD: {
                HashSet<DefaultWeightedEdge> track;
                for (Integer trackID : filteredTrackKeys) {
                    target = this.model;
                    synchronized (target) {
                        track = new HashSet<DefaultWeightedEdge>(this.model.getTrackModel().trackEdges(trackID));
                    }
                    target = track.iterator();
                    while (target.hasNext()) {
                        DefaultWeightedEdge edge = (DefaultWeightedEdge)target.next();
                        Spot source3 = this.model.getTrackModel().getEdgeSource(edge);
                        int sourceFrame = source3.getFeature("FRAME").intValue();
                        if (sourceFrame < minT || sourceFrame >= maxT) continue;
                        float transparency = (float)(1.0 - Math.abs((double)sourceFrame - (double)currentFrame) / (double)trackDisplayDepth);
                        Spot target3 = this.model.getTrackModel().getEdgeTarget(edge);
                        if (!TrackOverlay.isOnClip(source3, target3, minx, miny, maxx, maxy, this.calibration)) continue;
                        double zs = source3.getFeature("POSITION_Z");
                        double zt = target3.getFeature("POSITION_Z");
                        if (doLimitDrawingDepth && Math.abs(zs - zslice) > drawingDepth && Math.abs(zt - zslice) > drawingDepth) continue;
                        g2d.setColor(colorGenerator.color(edge));
                        this.drawEdge(g2d, source3, target3, xcorner, ycorner, magnification, transparency);
                    }
                }
                break;
            }
        }
        if (trackDisplayMode != DisplaySettings.TrackDisplayMode.SELECTION_ONLY) {
            g2d.setStroke(new BasicStroke((float)this.displaySettings.getSelectionLineThickness()));
            g2d.setColor(this.displaySettings.getHighlightColor());
            g2d.setComposite(AlphaComposite.getInstance(3));
            for (DefaultWeightedEdge edge : this.highlight) {
                source = this.model.getTrackModel().getEdgeSource(edge);
                if (!TrackOverlay.isOnClip(source, (Spot)(target = this.model.getTrackModel().getEdgeTarget(edge)), minx, miny, maxx, maxy, this.calibration)) continue;
                this.drawEdge(g2d, source, (Spot)target, xcorner, ycorner, magnification);
            }
        }
        g2d.setTransform(originalTransform);
        g2d.setComposite(originalComposite);
        g2d.setStroke(originalStroke);
        g2d.setColor(originalColor);
    }

    private static final boolean isOnClip(Spot source, Spot target, double minx, double miny, double maxx, double maxy, double[] calibration) {
        double x0i = source.getFeature("POSITION_X");
        double y0i = source.getFeature("POSITION_Y");
        double x1i = target.getFeature("POSITION_X");
        double y1i = target.getFeature("POSITION_Y");
        double x0p = x0i / calibration[0] + 0.5;
        double y0p = y0i / calibration[1] + 0.5;
        double x1p = x1i / calibration[0] + 0.5;
        double y1p = y1i / calibration[1] + 0.5;
        if (x0p > minx && x0p < maxx && y0p > miny && y0p < maxy || x1p > minx && x1p < maxx && y1p > miny && y1p < maxy) {
            return true;
        }
        if (TrackOverlay.segmentsCross(x0p, y0p, x1p, y1p, minx, miny, maxx, miny)) {
            return true;
        }
        if (TrackOverlay.segmentsCross(x0p, y0p, x1p, y1p, maxx, miny, maxx, maxy)) {
            return true;
        }
        if (TrackOverlay.segmentsCross(x0p, y0p, x1p, y1p, minx, maxy, maxx, maxy)) {
            return true;
        }
        return TrackOverlay.segmentsCross(x0p, y0p, x1p, y1p, minx, miny, minx, maxy);
    }

    private static final boolean segmentsCross(double x0, double y0, double x1, double y1, double x2, double y2, double x3, double y3) {
        double s2_x = x3 - x2;
        double s1_y = y1 - y0;
        double s1_x = x1 - x0;
        double s2_y = y3 - y2;
        double det = -s2_x * s1_y + s1_x * s2_y;
        if (det < 1.1754943508222875E-38) {
            return false;
        }
        double s = -s1_y * (x0 - x2) + s1_x * (y0 - y2);
        double t = s2_x * (y0 - y2) - s2_y * (x0 - x2);
        return s >= 0.0 && s <= det && t >= 0.0 && t <= det;
    }

    protected void drawEdge(Graphics2D g2d, Spot source, Spot target, int xcorner, int ycorner, double magnification, float transparency) {
        double x0i = source.getFeature("POSITION_X");
        double y0i = source.getFeature("POSITION_Y");
        double x1i = target.getFeature("POSITION_X");
        double y1i = target.getFeature("POSITION_Y");
        double x0p = x0i / this.calibration[0] + 0.5;
        double y0p = y0i / this.calibration[1] + 0.5;
        double x1p = x1i / this.calibration[0] + 0.5;
        double y1p = y1i / this.calibration[1] + 0.5;
        double x0s = (x0p - (double)xcorner) * magnification;
        double y0s = (y0p - (double)ycorner) * magnification;
        double x1s = (x1p - (double)xcorner) * magnification;
        double y1s = (y1p - (double)ycorner) * magnification;
        int x0 = (int)Math.round(x0s);
        int y0 = (int)Math.round(y0s);
        int x1 = (int)Math.round(x1s);
        int y1 = (int)Math.round(y1s);
        g2d.setComposite(AlphaComposite.getInstance(3, transparency));
        g2d.drawLine(x0, y0, x1, y1);
    }

    protected void drawEdge(Graphics2D g2d, Spot source, Spot target, int xcorner, int ycorner, double magnification) {
        double x0i = source.getFeature("POSITION_X");
        double y0i = source.getFeature("POSITION_Y");
        double x1i = target.getFeature("POSITION_X");
        double y1i = target.getFeature("POSITION_Y");
        double x0p = x0i / this.calibration[0] + 0.5;
        double y0p = y0i / this.calibration[1] + 0.5;
        double x1p = x1i / this.calibration[0] + 0.5;
        double y1p = y1i / this.calibration[1] + 0.5;
        double x0s = (x0p - (double)xcorner) * magnification;
        double y0s = (y0p - (double)ycorner) * magnification;
        double x1s = (x1p - (double)xcorner) * magnification;
        double y1s = (y1p - (double)ycorner) * magnification;
        int x0 = (int)Math.round(x0s);
        int y0 = (int)Math.round(y0s);
        int x1 = (int)Math.round(x1s);
        int y1 = (int)Math.round(y1s);
        g2d.drawLine(x0, y0, x1, y1);
    }
}

