/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.FeaturePlotSelectionPanel;
import fiji.plugin.trackmate.util.TMUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SmallFeaturePlotSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Dimension BUTTON_SIZE = new Dimension(24, 24);
    private static final Dimension COMBO_BOX_SIZE = new Dimension(150, 22);
    private static final int MAX_FEATURE_ALLOWED = 10;
    private final JPanel panelYFeatures;
    private final Stack<JComboBox<String>> comboBoxes = new Stack();
    private final Stack<Component> struts = new Stack();
    private final List<String> features;
    private final Map<String, String> featureNames;

    public SmallFeaturePlotSelectionPanel(String xKey, List<String> features, Map<String, String> featureNames, FeaturePlotSelectionPanel.PlotAction plotAction) {
        this.features = features;
        this.featureNames = featureNames;
        this.setLayout(null);
        this.setPreferredSize(new Dimension(170, 284));
        JLabel jLabelXFeature = new JLabel();
        this.add(jLabelXFeature);
        jLabelXFeature.setText("Feature for X axis:");
        jLabelXFeature.setFont(Fonts.FONT);
        jLabelXFeature.setBounds(8, 66, 148, 26);
        DefaultComboBoxModel<String> jComboBoxXFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(features, featureNames).toArray(new String[0]));
        JComboBox<String> jComboBoxXFeature = new JComboBox<String>();
        this.add(jComboBoxXFeature);
        jComboBoxXFeature.setModel(jComboBoxXFeatureModel);
        jComboBoxXFeature.setFont(Fonts.SMALL_FONT);
        jComboBoxXFeature.setBounds(8, 92, SmallFeaturePlotSelectionPanel.COMBO_BOX_SIZE.width, SmallFeaturePlotSelectionPanel.COMBO_BOX_SIZE.height);
        jComboBoxXFeature.setSelectedItem(xKey);
        JLabel jLabelYFeatures = new JLabel();
        this.add(jLabelYFeatures);
        jLabelYFeatures.setText("Features for Y axis:");
        jLabelYFeatures.setFont(Fonts.FONT);
        jLabelYFeatures.setBounds(8, 114, 148, 22);
        JScrollPane jScrollPaneYFeatures = new JScrollPane();
        this.add(jScrollPaneYFeatures);
        jScrollPaneYFeatures.setPreferredSize(new Dimension(169, 137));
        jScrollPaneYFeatures.setHorizontalScrollBarPolicy(31);
        jScrollPaneYFeatures.setBounds(0, 139, 168, 105);
        this.panelYFeatures = new JPanel();
        this.panelYFeatures.setLayout(new BoxLayout(this.panelYFeatures, 1));
        jScrollPaneYFeatures.setViewportView(this.panelYFeatures);
        JPanel jPanelButtons = new JPanel();
        BoxLayout jPanelButtonsLayout = new BoxLayout(jPanelButtons, 0);
        jPanelButtons.setLayout(jPanelButtonsLayout);
        this.add(jPanelButtons);
        jPanelButtons.setBounds(10, 244, 148, 29);
        JButton jButtonAdd = new JButton();
        jPanelButtons.add(jButtonAdd);
        jButtonAdd.setIcon(Icons.ADD_ICON);
        jButtonAdd.setMaximumSize(BUTTON_SIZE);
        jButtonAdd.addActionListener(e -> this.addFeature());
        JButton jButtonRemove = new JButton();
        jPanelButtons.add(jButtonRemove);
        jButtonRemove.setIcon(Icons.REMOVE_ICON);
        jButtonRemove.setMaximumSize(BUTTON_SIZE);
        jButtonRemove.addActionListener(e -> this.removeFeature());
        JButton plotButton = new JButton("Plot features", Icons.PLOT_ICON);
        plotButton.setFont(Fonts.FONT.deriveFont(1));
        plotButton.setHorizontalAlignment(4);
        plotButton.setBounds(24, 21, 119, 34);
        this.add(plotButton);
        plotButton.addActionListener(e -> {
            String sKey = (String)features.get(jComboBoxXFeature.getSelectedIndex());
            ArrayList<String> yKeys = new ArrayList<String>(this.comboBoxes.size());
            for (JComboBox jComboBox : this.comboBoxes) {
                yKeys.add((String)features.get(jComboBox.getSelectedIndex()));
            }
            plotAction.plot(sKey, yKeys);
        });
        this.addFeature();
    }

    private void addFeature() {
        if (this.comboBoxes.size() > 10) {
            return;
        }
        DefaultComboBoxModel<String> jComboBoxYFeatureModel = new DefaultComboBoxModel<String>(TMUtils.getArrayFromMaping(this.features, this.featureNames).toArray(new String[0]));
        JComboBox<String> jComboBoxYFeature = new JComboBox<String>();
        jComboBoxYFeature.setModel(jComboBoxYFeatureModel);
        jComboBoxYFeature.setPreferredSize(COMBO_BOX_SIZE);
        jComboBoxYFeature.setMaximumSize(COMBO_BOX_SIZE);
        jComboBoxYFeature.setFont(Fonts.SMALL_FONT);
        if (!this.comboBoxes.isEmpty()) {
            int newIndex = ((JComboBox)this.comboBoxes.get(this.comboBoxes.size() - 1)).getSelectedIndex() + 1;
            if (newIndex >= this.features.size()) {
                newIndex = 0;
            }
            jComboBoxYFeature.setSelectedIndex(newIndex);
        }
        Component strut = Box.createVerticalStrut(5);
        this.panelYFeatures.add(strut);
        this.panelYFeatures.add(jComboBoxYFeature);
        this.panelYFeatures.revalidate();
        this.comboBoxes.push(jComboBoxYFeature);
        this.struts.push(strut);
    }

    private void removeFeature() {
        if (this.comboBoxes.isEmpty()) {
            return;
        }
        this.panelYFeatures.remove(this.comboBoxes.pop());
        this.panelYFeatures.remove(this.struts.pop());
        this.panelYFeatures.revalidate();
        this.panelYFeatures.repaint();
    }
}

