/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme;

import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TrackSchemeSvgCanvas
extends mxSvgCanvas {
    public TrackSchemeSvgCanvas(Document document) {
        super(document);
    }

    public Element drawShape(int x, int y, int w, int h, Map<String, Object> style) {
        String img;
        String fillColor = mxUtils.getString(style, (String)mxConstants.STYLE_FILLCOLOR, (String)"none");
        String gradientColor = mxUtils.getString(style, (String)mxConstants.STYLE_GRADIENTCOLOR, (String)"none");
        String strokeColor = mxUtils.getString(style, (String)mxConstants.STYLE_STROKECOLOR, (String)"none");
        float strokeWidth = (float)((double)mxUtils.getFloat(style, (String)mxConstants.STYLE_STROKEWIDTH, (float)1.0f) * this.scale);
        float opacity = mxUtils.getFloat(style, (String)mxConstants.STYLE_OPACITY, (float)100.0f);
        String shape = mxUtils.getString(style, (String)mxConstants.STYLE_SHAPE, (String)"");
        Element elem = null;
        Element background = null;
        if (!shape.equals("scaledLabel")) {
            return super.drawShape(x, y, w, h, style);
        }
        elem = background = this.document.createElement("rect");
        elem.setAttribute("x", String.valueOf(x));
        elem.setAttribute("y", String.valueOf(y));
        elem.setAttribute("width", String.valueOf(w));
        elem.setAttribute("height", String.valueOf(h));
        if (mxUtils.isTrue(style, (String)mxConstants.STYLE_ROUNDED, (boolean)false)) {
            String r = String.valueOf(Math.min((double)w * mxConstants.RECTANGLE_ROUNDING_FACTOR, (double)h * mxConstants.RECTANGLE_ROUNDING_FACTOR));
            elem.setAttribute("rx", r);
            elem.setAttribute("ry", r);
        }
        if ((img = this.getImageForStyle(style)) != null) {
            String imgAlign = mxUtils.getString(style, (String)mxConstants.STYLE_IMAGE_ALIGN, (String)"left");
            String imgValign = mxUtils.getString(style, (String)mxConstants.STYLE_IMAGE_VERTICAL_ALIGN, (String)"middle");
            int imgWidth = (int)((double)mxUtils.getInt(style, (String)mxConstants.STYLE_IMAGE_WIDTH, (int)mxConstants.DEFAULT_IMAGESIZE) * this.scale);
            int imgHeight = (int)((double)mxUtils.getInt(style, (String)mxConstants.STYLE_IMAGE_HEIGHT, (int)mxConstants.DEFAULT_IMAGESIZE) * this.scale);
            int spacing = (int)((double)mxUtils.getInt(style, (String)mxConstants.STYLE_SPACING, (int)2) * this.scale);
            mxRectangle imageBounds = this.getImageBounds(x, y, w, h);
            if (imgAlign.equals("center")) {
                imageBounds.setX(imageBounds.getX() + (imageBounds.getWidth() - (double)imgWidth) / 2.0);
            } else if (imgAlign.equals("right")) {
                imageBounds.setX(imageBounds.getX() + imageBounds.getWidth() - (double)imgWidth - (double)spacing - 2.0);
            } else {
                imageBounds.setX(imageBounds.getX() + (double)spacing + 4.0);
            }
            if (imgValign.equals("top")) {
                imageBounds.setY(imageBounds.getY() + (double)spacing);
            } else if (imgValign.equals("bottom")) {
                imageBounds.setY(imageBounds.getY() + imageBounds.getHeight() - (double)imgHeight - (double)spacing);
            } else {
                imageBounds.setY(imageBounds.getY() + (imageBounds.getHeight() - (double)imgHeight) / 2.0);
            }
            imageBounds.setWidth((double)imgWidth);
            imageBounds.setHeight((double)imgHeight);
            elem = this.document.createElement("g");
            elem.appendChild(background);
            Element imageElement = this.createImageElement(imageBounds.getX(), imageBounds.getY(), imageBounds.getWidth(), imageBounds.getHeight(), img, false, false, false, this.isEmbedded());
            if (opacity != 100.0f) {
                String value = String.valueOf(opacity / 100.0f);
                imageElement.setAttribute("opacity", value);
            }
            elem.appendChild(imageElement);
        }
        if (mxUtils.isTrue(style, (String)mxConstants.STYLE_GLASS, (boolean)false)) {
            double size = 0.4;
            Element glassOverlay = this.document.createElement("path");
            glassOverlay.setAttribute("fill", "url(#" + this.getGlassGradientElement().getAttribute("id") + ")");
            String d = "m " + ((float)x - strokeWidth) + "," + ((float)y - strokeWidth) + " L " + ((float)x - strokeWidth) + "," + ((double)y + (double)h * size) + " Q " + ((double)x + (double)w * 0.5) + "," + ((double)y + (double)h * 0.7) + " " + ((float)(x + w) + strokeWidth) + "," + ((double)y + (double)h * size) + " L " + ((float)(x + w) + strokeWidth) + "," + ((float)y - strokeWidth) + " z";
            glassOverlay.setAttribute("stroke-width", String.valueOf(strokeWidth / 2.0f));
            glassOverlay.setAttribute("d", d);
            elem.appendChild(glassOverlay);
        }
        double rotation = mxUtils.getDouble(style, (String)mxConstants.STYLE_ROTATION);
        int cx = x + w / 2;
        int cy = y + h / 2;
        Element bg = background;
        if (bg == null) {
            bg = elem;
        }
        if (!bg.getNodeName().equalsIgnoreCase("use") && !bg.getNodeName().equalsIgnoreCase("image")) {
            if (!fillColor.equalsIgnoreCase("none") && !gradientColor.equalsIgnoreCase("none")) {
                String direction = mxUtils.getString(style, (String)mxConstants.STYLE_GRADIENT_DIRECTION);
                Element gradient = this.getGradientElement(fillColor, gradientColor, direction);
                if (gradient != null) {
                    bg.setAttribute("fill", "url(#" + gradient.getAttribute("id") + ")");
                }
            } else {
                bg.setAttribute("fill", fillColor);
            }
            bg.setAttribute("stroke", strokeColor);
            bg.setAttribute("stroke-width", String.valueOf(strokeWidth));
            Element shadowElement = null;
            if (mxUtils.isTrue(style, (String)mxConstants.STYLE_SHADOW, (boolean)false) && !fillColor.equals("none")) {
                shadowElement = (Element)bg.cloneNode(true);
                shadowElement.setAttribute("transform", mxConstants.SVG_SHADOWTRANSFORM);
                shadowElement.setAttribute("fill", mxConstants.W3C_SHADOWCOLOR);
                shadowElement.setAttribute("stroke", mxConstants.W3C_SHADOWCOLOR);
                shadowElement.setAttribute("stroke-width", String.valueOf(strokeWidth));
                if (rotation != 0.0) {
                    shadowElement.setAttribute("transform", "rotate(" + rotation + "," + cx + "," + cy + ") " + mxConstants.SVG_SHADOWTRANSFORM);
                }
                if (opacity != 100.0f) {
                    String value = String.valueOf(opacity / 100.0f);
                    shadowElement.setAttribute("fill-opacity", value);
                    shadowElement.setAttribute("stroke-opacity", value);
                }
                this.appendSvgElement(shadowElement);
            }
        }
        if (rotation != 0.0) {
            elem.setAttribute("transform", elem.getAttribute("transform") + " rotate(" + rotation + "," + cx + "," + cy + ")");
        }
        if (opacity != 100.0f) {
            String value = String.valueOf(opacity / 100.0f);
            elem.setAttribute("fill-opacity", value);
            elem.setAttribute("stroke-opacity", value);
        }
        if (mxUtils.isTrue(style, (String)mxConstants.STYLE_DASHED)) {
            elem.setAttribute("stroke-dasharray", "3, 3");
        }
        this.appendSvgElement(elem);
        return elem;
    }

    public mxRectangle getImageBounds(int x, int y, int width, int height) {
        int arc = this.getArcSize(width, height) / 2;
        int minSize = Math.min(width - arc * 2, height - 4);
        mxRectangle imageBounds = new mxRectangle((double)(x + arc), (double)(y + 2), (double)minSize, (double)minSize);
        return imageBounds;
    }

    public int getArcSize(int w, int h) {
        int arcSize;
        if (w <= h) {
            arcSize = (int)Math.round((double)h * mxConstants.RECTANGLE_ROUNDING_FACTOR);
            if (arcSize > w / 2) {
                arcSize = w / 2;
            }
        } else {
            arcSize = (int)Math.round((double)w * mxConstants.RECTANGLE_ROUNDING_FACTOR);
            if (arcSize > h / 2) {
                arcSize = h / 2;
            }
        }
        return arcSize;
    }
}

