/*
 * Decompiled with CFR 0.152.
 */
package fiji.util.gui;

import fiji.util.gui.CommandFinderBase;
import ij.WindowManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class JFrameCommandFinder
extends CommandFinderBase {
    JMenuBar menuBar;

    public JFrameCommandFinder(String title, JFrame frame) {
        super(title);
        this.menuBar = frame.getJMenuBar();
    }

    @Override
    public void populateActions() {
        for (int i = 0; i < this.menuBar.getMenuCount(); ++i) {
            JMenu menu = this.menuBar.getMenu(i);
            this.populateActions(menu, menu.getLabel());
        }
    }

    protected void populateActions(JMenu menu, String menuLocation) {
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            String location = menuLocation + ">" + item.getLabel();
            if (item instanceof JMenu) {
                this.populateActions((JMenu)item, location);
                continue;
            }
            this.actions.add(new JMenuItemAction(item, location));
        }
    }

    public static void main(String[] args) {
        JFrame frame = null;
        for (Frame f : WindowManager.getNonImageWindows()) {
            if (!(f instanceof JFrame)) continue;
            frame = (JFrame)f;
        }
        new JFrameCommandFinder("JFrame Command Finder Demo", frame).setVisible(true);
    }

    protected class JMenuItemAction
    extends CommandFinderBase.Action {
        JMenuItem menuItem;

        public JMenuItemAction(JMenuItem menuItem, String menuLocation) {
            super(menuItem.getLabel(), menuLocation);
            this.menuItem = menuItem;
        }

        @Override
        public void run() {
            ActionEvent event = new ActionEvent(this.menuItem, 1001, this.label);
            for (ActionListener listener : this.menuItem.getActionListeners()) {
                listener.actionPerformed(event);
            }
        }
    }
}

