/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.io.IOException;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRFunction;
import org.renjin.compiler.ir.tac.IRFunctionTable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class IRProgram {
    private IRBody main;
    private IRFunctionTable functionTable = new IRFunctionTable();

    public IRProgram(SEXP program) {
        IRBodyBuilder builder = new IRBodyBuilder(this.functionTable);
        this.main = builder.build(program);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRFunction function2 : this.functionTable) {
            sb.append("function@" + function2.getId()).append("\n");
            sb.append(function2.getBody()).append("\n");
        }
        sb.append("\nMAIN:\n");
        sb.append(this.main.toString());
        return sb.toString();
    }

    public SEXP evaluate() throws IOException {
        Context context = Context.newTopLevelContext();
        context.init();
        return this.main.evaluate(context);
    }

    public IRBody getMain() {
        return this.main;
    }

    public Iterable<IRFunction> getFunctions() {
        return this.functionTable.getFunctions();
    }
}

