/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline;

import org.renjin.compiler.pipeline.DeferredGraph;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.DeferredNodeComputer;
import org.renjin.compiler.pipeline.VectorPipeliner;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.primitives.vector.MemoizedDoubleVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Vector;

public class SimpleVectorPipeliner
implements VectorPipeliner {
    @Override
    public Vector materialize(DeferredComputation root) {
        DeferredGraph graph = new DeferredGraph(root);
        if (VectorPipeliner.DEBUG) {
            System.err.println("materialize");
            graph.dumpGraph();
        }
        this.forceMemoizedValues(graph.getRoot());
        return graph.getRoot().getVector();
    }

    @Override
    public Vector simplify(DeferredComputation root) {
        Vector vector2;
        DeferredGraph graph = new DeferredGraph(root);
        if (VectorPipeliner.DEBUG) {
            System.err.println("simplify");
            graph.dumpGraph();
        }
        if ((vector2 = this.materialize(root)) instanceof MemoizedDoubleVector) {
            return vector2;
        }
        if (vector2 instanceof DeferredComputation && vector2 instanceof DoubleVector) {
            return DoubleArrayVector.unsafe(((DoubleVector)vector2).toDoubleArray(), vector2.getAttributes());
        }
        return vector2;
    }

    private void forceMemoizedValues(DeferredNode node) {
        for (DeferredNode child : node.getOperands()) {
            this.forceMemoizedValues(child);
        }
        if (node.isMemoized()) {
            new DeferredNodeComputer(node).run();
        }
    }
}

