/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.graphics;

import org.renjin.graphics.Axis;
import org.renjin.graphics.AxisStyle;
import org.renjin.graphics.ClippingMode;
import org.renjin.graphics.Color;
import org.renjin.graphics.LineType;
import org.renjin.graphics.TextStyle;

public class GraphicParameters {
    private AxisStyle xAxisStyle = new AxisStyle();
    private AxisStyle yAxisStyle = new AxisStyle();
    private ClippingMode clippingMode = ClippingMode.PLOT;
    private Color foreground = Color.BLACK;
    private Color background = Color.TRANSPARENT_WHITE;
    private Color color = Color.TRANSPARENT_WHITE;
    private LineType lineType = LineType.SOLID;
    private double lineWidth = 1.0;
    private double cexBase = 1.0;
    private TextStyle mainTitleStyle = new TextStyle(1.2, Color.BLACK);
    private TextStyle axisAnnotationStyle = new TextStyle();
    private TextStyle xyLabelStyle = new TextStyle();
    private TextStyle subTitleStyle = new TextStyle();
    private double mex = 1.0;

    public ClippingMode getClippingMode() {
        return this.clippingMode;
    }

    public AxisStyle getxAxisStyle() {
        return this.xAxisStyle;
    }

    public AxisStyle getyAxisStyle() {
        return this.yAxisStyle;
    }

    public void setClippingMode(ClippingMode clippingMode) {
        this.clippingMode = clippingMode;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public GraphicParameters setForeground(Color foreground) {
        this.foreground = foreground;
        return this;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public GraphicParameters setLineType(LineType lineType) {
        this.lineType = lineType;
        return this;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public GraphicParameters setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public Color getBackground() {
        return this.background;
    }

    public GraphicParameters setBackground(Color background) {
        this.background = background;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public GraphicParameters setColor(Color color) {
        this.color = color;
        return this;
    }

    public double getMex() {
        return this.mex;
    }

    public void setMex(double mex) {
        this.mex = mex;
    }

    public double getCexBase() {
        return this.cexBase;
    }

    public void setCexBase(double cexBase) {
        this.cexBase = cexBase;
    }

    public TextStyle getMainTitleStyle() {
        return this.mainTitleStyle;
    }

    public void setMainTitleStyle(TextStyle mainTitleStyle) {
        this.mainTitleStyle = mainTitleStyle;
    }

    public TextStyle getAxisAnnotationStyle() {
        return this.axisAnnotationStyle;
    }

    public void setAxisAnnotationStyle(TextStyle axisAnnotationStyle) {
        this.axisAnnotationStyle = axisAnnotationStyle;
    }

    public TextStyle getXyLabelStyle() {
        return this.xyLabelStyle;
    }

    public void setXyLabelStyle(TextStyle xyLabelStyle) {
        this.xyLabelStyle = xyLabelStyle;
    }

    public TextStyle getSubTitleStyle() {
        return this.subTitleStyle;
    }

    public void setSubTitleStyle(TextStyle subTitleStyle) {
        this.subTitleStyle = subTitleStyle;
    }

    public void setxAxisStyle(AxisStyle xAxisStyle) {
        this.xAxisStyle = xAxisStyle;
    }

    public void setyAxisStyle(AxisStyle yAxisStyle) {
        this.yAxisStyle = yAxisStyle;
    }

    public AxisStyle getAxisStyle(Axis axis2) {
        switch (axis2) {
            case X: {
                return this.xAxisStyle;
            }
            case Y: {
                return this.yAxisStyle;
            }
        }
        throw new IllegalArgumentException("" + (Object)((Object)axis2));
    }

    public AxisStyle getXAxisStyle() {
        return this.xAxisStyle;
    }

    public AxisStyle getYAxisStyle() {
        return this.yAxisStyle;
    }

    public double getTextJustification() {
        return 0.5;
    }

    protected GraphicParameters clone() {
        GraphicParameters clone = new GraphicParameters();
        clone.clippingMode = this.clippingMode;
        clone.foreground = this.foreground;
        clone.background = this.background;
        clone.color = this.color;
        clone.lineType = this.lineType;
        clone.lineWidth = this.lineWidth;
        clone.xAxisStyle = this.xAxisStyle.clone();
        clone.yAxisStyle = this.yAxisStyle.clone();
        clone.cexBase = this.cexBase;
        clone.mainTitleStyle = this.mainTitleStyle.clone();
        clone.subTitleStyle = this.subTitleStyle.clone();
        return clone;
    }
}

