/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

import com.google.common.base.Predicate;
import org.renjin.primitives.text.regex.EmptyFixedRE;
import org.renjin.primitives.text.regex.ExtendedRE;
import org.renjin.primitives.text.regex.FixedRE;
import org.renjin.primitives.text.regex.RE;

public class REFactory {
    public static RE compile(String pattern, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        if (fixed) {
            if (pattern.length() == 0) {
                return new EmptyFixedRE();
            }
            return new FixedRE(pattern);
        }
        return new ExtendedRE(pattern, ignoreCase);
    }

    public static Predicate<String> asPredicate(final RE re) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return re.match(input);
            }
        };
    }
}

