/*
 * Decompiled with CFR 0.152.
 */
package siox;

import fiji.util.gui.OverlayedImageCanvas;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.ShapeRoiHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class RoiOverlay
implements OverlayedImageCanvas.Overlay {
    Roi roi = null;
    Color color = Roi.getColor();
    Composite composite = AlphaComposite.getInstance(3);

    public RoiOverlay() {
    }

    public RoiOverlay(Roi roi, Composite composite, Color color) {
        this.setRoi(roi);
        this.setComposite(composite);
        this.setColor(color);
    }

    public void paint(Graphics g, int x, int y, double magnification) {
        if (null == this.roi) {
            return;
        }
        this.roi.setImage(null);
        Shape shape = ShapeRoiHelper.getShape((ShapeRoi)new ShapeRoi(this.roi));
        Rectangle roiBox = this.roi.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform originalTransform = g2d.getTransform();
        AffineTransform at = new AffineTransform();
        at.scale(magnification, magnification);
        at.translate(roiBox.x - x, roiBox.y - y);
        at.concatenate(originalTransform);
        g2d.setTransform(at);
        Composite originalComposite = g2d.getComposite();
        g2d.setComposite(this.composite);
        g2d.setColor(this.color);
        g2d.fill(shape);
        g2d.setTransform(originalTransform);
        g2d.setComposite(originalComposite);
    }

    public void setRoi(Roi roi) {
        this.roi = roi;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        return "RoiOverlay(" + this.roi + ")";
    }
}

