/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.evaluation.output.prediction;

import weka.classifiers.Classifier;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Utils;
import weka.core.Version;

public class XML
extends AbstractOutput {
    private static final long serialVersionUID = -3165514277316824801L;
    public static final String DTD_DOCTYPE = "DOCTYPE";
    public static final String DTD_ELEMENT = "ELEMENT";
    public static final String DTD_ATTLIST = "ATTLIST";
    public static final String DTD_OPTIONAL = "?";
    public static final String DTD_AT_LEAST_ONE = "+";
    public static final String DTD_ZERO_OR_MORE = "*";
    public static final String DTD_SEPARATOR = "|";
    public static final String DTD_CDATA = "CDATA";
    public static final String DTD_ANY = "ANY";
    public static final String DTD_PCDATA = "#PCDATA";
    public static final String DTD_IMPLIED = "#IMPLIED";
    public static final String DTD_REQUIRED = "#REQUIRED";
    public static final String ATT_VERSION = "version";
    public static final String ATT_NAME = "name";
    public static final String ATT_TYPE = "type";
    public static final String VAL_YES = "yes";
    public static final String VAL_NO = "no";
    public static final String TAG_PREDICTIONS = "predictions";
    public static final String TAG_PREDICTION = "prediction";
    public static final String TAG_ACTUAL_LABEL = "actual_label";
    public static final String TAG_PREDICTED_LABEL = "predicted_label";
    public static final String TAG_ERROR = "error";
    public static final String TAG_DISTRIBUTION = "distribution";
    public static final String TAG_CLASS_LABEL = "class_label";
    public static final String TAG_ACTUAL_VALUE = "actual_value";
    public static final String TAG_PREDICTED_VALUE = "predicted_value";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String ATT_INDEX = "index";
    public static final String ATT_PREDICTED = "predicted";
    public static final String DTD = "<!DOCTYPE predictions\n[\n  <!ELEMENT predictions (prediction*)>\n  <!ATTLIST predictions version CDATA \"" + Version.VERSION + "\">\n  <!" + "ATTLIST" + " " + "predictions" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n\n  <!" + "ELEMENT" + " " + "prediction" + " ((" + "actual_label" + "," + "predicted_label" + "," + "error" + ",(" + "prediction" + "|" + "distribution" + ")," + "attributes" + "?" + ")" + "|" + "(" + "actual_value" + "," + "predicted_value" + "," + "error" + "," + "attributes" + "?" + "))>\n  <!" + "ATTLIST" + " " + "prediction" + " " + "index" + " " + "CDATA" + " " + "#REQUIRED" + ">\n\n  <!" + "ELEMENT" + " " + "actual_label" + " " + "ANY" + ">\n  <!" + "ATTLIST" + " " + "actual_label" + " " + "index" + " " + "CDATA" + " " + "#REQUIRED" + ">\n  <!" + "ELEMENT" + " " + "predicted_label" + " " + "ANY" + ">\n  <!" + "ATTLIST" + " " + "predicted_label" + " " + "index" + " " + "CDATA" + " " + "#REQUIRED" + ">\n  <!" + "ELEMENT" + " " + "error" + " " + "ANY" + ">\n  <!" + "ELEMENT" + " " + "prediction" + " " + "ANY" + ">\n  <!" + "ELEMENT" + " " + "distribution" + " (" + "class_label" + "+" + ")>\n  <!" + "ELEMENT" + " " + "class_label" + " " + "ANY" + ">\n  <!" + "ATTLIST" + " " + "class_label" + " " + "index" + " " + "CDATA" + " " + "#REQUIRED" + ">\n  <!" + "ATTLIST" + " " + "class_label" + " " + "predicted" + " (" + "yes" + "|" + "no" + ") \"" + "no" + "\">\n  <!" + "ELEMENT" + " " + "actual_value" + " " + "ANY" + ">\n  <!" + "ELEMENT" + " " + "predicted_value" + " " + "ANY" + ">\n  <!" + "ELEMENT" + " " + "attributes" + " (" + "attribute" + "+" + ")>\n  <!" + "ELEMENT" + " " + "attribute" + " " + "ANY" + ">\n  <!" + "ATTLIST" + " " + "attribute" + " " + "index" + " " + "CDATA" + " " + "#REQUIRED" + ">\n  <!" + "ATTLIST" + " " + "attribute" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n  <!" + "ATTLIST" + " " + "attribute" + " " + "type" + " (" + Attribute.typeToString(0) + "|" + Attribute.typeToString(3) + "|" + Attribute.typeToString(1) + "|" + Attribute.typeToString(2) + "|" + Attribute.typeToString(4) + ") " + "#REQUIRED" + ">\n]\n>";

    @Override
    public String globalInfo() {
        return "Outputs the predictions in XML.\n\nThe following DTD is used:\n\n" + DTD;
    }

    @Override
    public String getDisplay() {
        return "XML";
    }

    protected String sanitize(String s) {
        String result = s;
        result = result.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll(">", "&gt;");
        result = result.replaceAll("\"", "&quot;");
        return result;
    }

    @Override
    protected void doPrintHeader() {
        this.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        this.append("\n");
        this.append(DTD + "\n\n");
        this.append("<predictions version=\"" + Version.VERSION + "\" " + ATT_NAME + "=\"" + this.sanitize(this.m_Header.relationName()) + "\">\n");
    }

    protected String attributeValuesString(Instance instance) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attributes != null) {
            text.append("    <attributes>\n");
            this.m_Attributes.setUpper(instance.numAttributes() - 1);
            for (int i = 0; i < instance.numAttributes(); ++i) {
                if (!this.m_Attributes.isInRange(i) || i == instance.classIndex()) continue;
                text.append("      <attribute index=\"" + (i + 1) + "\" " + ATT_NAME + "=\"" + this.sanitize(instance.attribute(i).name()) + "\" " + ATT_TYPE + "=\"" + Attribute.typeToString(instance.attribute(i).type()) + "\">");
                text.append(this.sanitize(instance.toString(i)));
                text.append("</attribute>\n");
            }
            text.append("    </attributes>\n");
        }
        return text.toString();
    }

    @Override
    protected void doPrintClassification(double[] dist, Instance inst, int index) throws Exception {
        int prec = this.m_NumDecimals;
        Instance withMissing = (Instance)inst.copy();
        withMissing.setDataset(inst.dataset());
        double predValue = 0.0;
        predValue = Utils.sum(dist) == 0.0 ? Utils.missingValue() : (inst.classAttribute().isNominal() ? (double)Utils.maxIndex(dist) : dist[0]);
        this.append("  <prediction index=\"" + (index + 1) + "\">\n");
        if (inst.dataset().classAttribute().isNumeric()) {
            this.append("    <actual_value>");
            if (inst.classIsMissing()) {
                this.append(DTD_OPTIONAL);
            } else {
                this.append(Utils.doubleToString(inst.classValue(), prec));
            }
            this.append("</actual_value>\n");
            this.append("    <predicted_value>");
            if (inst.classIsMissing()) {
                this.append(DTD_OPTIONAL);
            } else {
                this.append(Utils.doubleToString(predValue, prec));
            }
            this.append("</predicted_value>\n");
            this.append("    <error>");
            if (Utils.isMissingValue(predValue) || inst.classIsMissing()) {
                this.append(DTD_OPTIONAL);
            } else {
                this.append(Utils.doubleToString(predValue - inst.classValue(), prec));
            }
            this.append("</error>\n");
        } else {
            this.append("    <actual_label index=\"" + ((int)inst.classValue() + 1) + "\">");
            this.append(this.sanitize(inst.toString(inst.classIndex())));
            this.append("</actual_label>\n");
            this.append("    <predicted_label index=\"" + ((int)predValue + 1) + "\">");
            if (Utils.isMissingValue(predValue)) {
                this.append(DTD_OPTIONAL);
            } else {
                this.append(this.sanitize(inst.dataset().classAttribute().value((int)predValue)));
            }
            this.append("</predicted_label>\n");
            this.append("    <error>");
            if (!Utils.isMissingValue(predValue) && !inst.classIsMissing() && (int)predValue + 1 != (int)inst.classValue() + 1) {
                this.append(VAL_YES);
            } else {
                this.append(VAL_NO);
            }
            this.append("</error>\n");
            if (this.m_OutputDistribution) {
                this.append("    <distribution>\n");
                for (int n = 0; n < dist.length; ++n) {
                    this.append("      <class_label index=\"" + (n + 1) + "\"");
                    if (!Utils.isMissingValue(predValue) && n == (int)predValue) {
                        this.append(" predicted=\"yes\"");
                    }
                    this.append(">");
                    this.append(Utils.doubleToString(dist[n], prec));
                    this.append("</class_label>\n");
                }
                this.append("    </distribution>\n");
            } else {
                this.append("    <prediction>");
                if (Utils.isMissingValue(predValue)) {
                    this.append(DTD_OPTIONAL);
                } else {
                    this.append(Utils.doubleToString(dist[(int)predValue], prec));
                }
                this.append("</prediction>\n");
            }
        }
        if (this.m_Attributes != null) {
            this.append(this.attributeValuesString(withMissing));
        }
        this.append("  </prediction>\n");
    }

    @Override
    protected void doPrintClassification(Classifier classifier, Instance inst, int index) throws Exception {
        double[] d = classifier.distributionForInstance(inst);
        this.doPrintClassification(d, inst, index);
    }

    @Override
    protected void doPrintFooter() {
        this.append("</predictions>\n");
    }
}

