/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import java.util.ArrayList;
import java.util.Collection;
import net.imglib2.KDTree;
import net.imglib2.RealLocalizable;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.roi.geom.real.NNSRealPointCollection;

public class KDTreeRealPointCollection<L extends RealLocalizable>
extends NNSRealPointCollection<L> {
    public KDTreeRealPointCollection(Collection<L> points) {
        this(KDTreeRealPointCollection.createKDTree(points));
    }

    public KDTreeRealPointCollection(KDTree<L> tree) {
        super(tree, new NearestNeighborSearchOnKDTree(tree));
    }

    private static final <R extends RealLocalizable> KDTree<R> createKDTree(Collection<R> points) {
        ArrayList<R> pointsList = new ArrayList<R>(points);
        return new KDTree(pointsList, pointsList);
    }
}

