/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import java.util.ArrayList;
import java.util.List;
import net.imagej.Dataset;
import net.imagej.ImgPlus;
import net.imagej.plugins.commands.assign.noisereduce.Reducer;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.ops.function.Function;
import net.imglib2.ops.function.real.RealAdaptiveMedianFunction;
import net.imglib2.ops.function.real.RealImageFunction;
import net.imglib2.ops.pointset.HyperVolumePointSet;
import net.imglib2.ops.pointset.PointSet;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Process", weight=3.0, mnemonic=112), @Menu(label="Noise", mnemonic=110), @Menu(label="Noise Reduction", mnemonic=114), @Menu(label="Adaptive Median")}, headless=true, attrs={@Attr(name="no-legacy")})
public class NoiseReductionAdaptiveMedian<U extends RealType<U>>
extends ContextCommand {
    @Parameter
    private Context context;
    @Parameter
    private Dataset input;
    @Parameter(label="Neighborhood: negative width", min="0")
    private int windowNegWidthSpan = 1;
    @Parameter(label="Neighborhood: negative height", min="0")
    private int windowNegHeightSpan = 1;
    @Parameter(label="Neighborhood: positive width", min="0")
    private int windowPosWidthSpan = 1;
    @Parameter(label="Neighborhood: positive height", min="0")
    private int windowPosHeightSpan = 1;
    @Parameter(label="Number of expansions", min="1")
    private int windowExpansions = 1;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset output;

    public void run() {
        ImgPlus inputImg = this.input.getImgPlus();
        OutOfBoundsMirrorFactory oobFactory = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE);
        RealImageFunction otherFunc = new RealImageFunction((RandomAccessibleInterval)inputImg, (OutOfBoundsFactory)oobFactory, (RealType)new DoubleType());
        List<PointSet> pointSets = this.getNeighborhoods(this.input.numDimensions());
        Reducer reducer = new Reducer(this.context, inputImg, this.getFunction((Function<long[], DoubleType>)otherFunc, pointSets), pointSets.get(0));
        this.output = reducer.reduceNoise("Adaptive window neighborhood");
    }

    private Function<PointSet, DoubleType> getFunction(Function<long[], DoubleType> otherFunc, List<PointSet> neighs) {
        return new RealAdaptiveMedianFunction(otherFunc, neighs);
    }

    private List<PointSet> getNeighborhoods(int numDims) {
        ArrayList<PointSet> pointSets = new ArrayList<PointSet>();
        for (int i = 0; i < this.windowExpansions; ++i) {
            HyperVolumePointSet rect = new HyperVolumePointSet(new long[numDims], this.offsets(this.windowNegWidthSpan + i, this.windowNegHeightSpan + i, numDims), this.offsets(this.windowPosWidthSpan + i, this.windowPosHeightSpan + i, numDims));
            pointSets.add((PointSet)rect);
        }
        return pointSets;
    }

    private long[] offsets(int xOffset, int yOffset, int numDims) {
        long[] offsets = new long[numDims];
        offsets[0] = xOffset;
        offsets[1] = yOffset;
        return offsets;
    }
}

