/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.assign.noisereduce;

import net.imglib2.ops.condition.Condition;
import net.imglib2.ops.pointset.PointSet;

public class WithinRadiusOfPointSetOriginCondition
implements Condition<long[]> {
    private final PointSet pointSet;
    private final long radius;
    private final long radiusSquared;

    public WithinRadiusOfPointSetOriginCondition(long radius, PointSet pointSet) {
        this.pointSet = pointSet;
        this.radius = radius;
        this.radiusSquared = radius * radius;
    }

    public boolean isTrue(long[] val) {
        long[] origin = this.pointSet.getOrigin();
        long sumSq = 0L;
        for (int i = 0; i < val.length; ++i) {
            long delta = val[i] - origin[i];
            sumSq += delta * delta;
        }
        return sumSq <= this.radiusSquared;
    }

    public WithinRadiusOfPointSetOriginCondition copy() {
        return new WithinRadiusOfPointSetOriginCondition(this.radius, this.pointSet);
    }
}

